/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public abstract class RealExpr extends ASTNode
{
	public abstract double eval();

	public static final double MAX_RANDOM_REAL = 2.0;
	//nodes with children:  (cumulative probabilitites)

	public static final double IF_prob = 0.33;
	public static final double BINARY_prob = 1.0;
	
	//nodes without:  (cumulative probabilitites)
	public static final double ACCESS_prob = 0.8;
	public static final double CONST_prob = 1.0;
	
	public static RealExpr generate (Walker walker, int vertexNum, double probOfChildren)
	{
		double randomNum = Math.random();
		if (probOfChildren > randomNum)
		{
			double exprType = Math.random();
			double probOfGrandchildren = probOfChildren*PROB_OF_MORE_CHILDREN;
			if (exprType <= IF_prob)
				return new IfExpr(walker,vertexNum, 
								  BoolExpr.generate(walker,vertexNum, probOfGrandchildren),
								  RealExpr.generate(walker,vertexNum, probOfGrandchildren),
								  RealExpr.generate(walker,vertexNum, probOfGrandchildren));
			else  // exprType <= BINARY_prob
				return new BinaryOp(walker,vertexNum, 
									BinaryOp.RANDOM_OP,
									RealExpr.generate(walker,vertexNum, probOfGrandchildren),
									RealExpr.generate(walker,vertexNum, probOfGrandchildren));
		}
		else
		{
			if(Math.random() < ACCESS_prob)
				return new Accessor(walker,vertexNum, Accessor.RANDOM_OP, IndexExpr.generate(walker, vertexNum));
			else
				return new RealConst(walker,vertexNum, 2*MAX_RANDOM_REAL*Math.random() - MAX_RANDOM_REAL);
		}
	}
	
	public abstract void dumpNode(PrintWriter out);
	public abstract RealExpr copy(Walker newWalker);
	
	//replaces a random child node with a newly generated subtree
	public abstract RealExpr mutate();
	
	//replaces a random child node with the specified subtree
	protected abstract RealExpr insert(RealExpr subtree);
	public RealExpr insertCross(RealExpr subtree, Walker newW, int newIndex)
	{
		subtree.setNewWalker(newW, newIndex);
		return insert(subtree);
	}
	
	public abstract RealExpr getRandomChild();

	protected RealExpr(Walker walker, int vertexNum){
		super(walker,vertexNum);
	}
}
