/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class RealConst extends RealExpr
{
	public RealConst(Walker walker, int vertexNum, double value)
	{
		super(walker,vertexNum);
		this.value = value;
	}
	protected double value;

	public double eval()
	{
		return value;
	}

	public void dumpNode(PrintWriter out){
		out.print("(R " + value + ")");
	}
	
	public RealExpr mutate(){
		return RealExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
	}
	
	protected RealExpr insert(RealExpr subtree){
		return subtree;
	}
	
	public RealExpr getRandomChild(){
		return this;
	}
	
	public RealExpr copy(Walker newWalker){
		return new RealConst(newWalker,vertexNum, value);
	}
	
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
	}
}
