/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class Parser
{
	StreamTokenizer tokenStream;
	Walker walker;
	public int vertexNum;
	
	public static RealExpr parse(String filename, Walker walker, int vertexNum)
	{
		try {
			Parser parser = new Parser(filename, walker, vertexNum);
			return parser.parseReal();
		}
		catch (Exception e){
			System.out.println("Error: "+e.getMessage());
			e.printStackTrace();
			return null;
		}
	}
	
	public Parser(String filename, Walker walker, int vertexNum) throws FileNotFoundException, IOException
	{
		FileReader reader = new FileReader(filename);
		tokenStream = new StreamTokenizer(reader);
		
		tokenStream.eolIsSignificant(false);
		tokenStream.parseNumbers();
		tokenStream.ordinaryChar('/'); // make '/' ordinary, (which is otherwise a comment).

		tokenStream.nextToken(); 
		
		this.walker = walker;
		this.vertexNum = vertexNum;
	}
	
	public RealExpr parseReal() throws IOException, Exception
	{
		char type = parseType();
		RealExpr returnValue;

		switch (type)
		{
		case('+'):
		case('-'):
		case('*'):
		case('/'):
			returnValue = new BinaryOp(walker,vertexNum, type, parseReal(), parseReal());
			break;
		case('I'):
			returnValue = new IfExpr(walker,vertexNum, parseBool(), parseReal(), parseReal());
			break;
		case('R'):
			if (tokenStream.ttype != StreamTokenizer.TT_NUMBER) throw new Exception("Parser Error: expecting a number after \"R\"");
			returnValue = new RealConst(walker,vertexNum, tokenStream.nval);
			tokenStream.nextToken(); //eat the number
			break;
		case('X'):
		case('Y'):
		case('U'):
		case('V'):
			returnValue = new Accessor(walker,vertexNum, type, parseIndex());
			break;
			
		case('='):
		case('<'):
		case('>'):
		case('B'):
		case('N'):
		case('G'):
			throw new Exception("Parser Error: received type " + type + "when expecting a real.");
		default:
			throw new Exception("Parser Error: type " + type + "not understood.");
		}
		
	    if (tokenStream.ttype != ')') throw new Exception("Parser Error: expecting a ')'");
		tokenStream.nextToken(); //eat the ')'
		return returnValue;
	}
	
	private BoolExpr parseBool() throws IOException, Exception
	{
		char type = parseType();
		BoolExpr returnValue;
		
		switch (type)
		{
		case('='):
		case('<'):
		case('>'):
			returnValue = new Comparator(walker,vertexNum, type, parseReal(), parseReal());
			break;
		case('B'):
			if (tokenStream.sval.equals("true"))
				returnValue = new BoolConst(walker,vertexNum, true);
			else if (tokenStream.sval.equals("false"))
				returnValue = new BoolConst(walker,vertexNum, false);
			else
				throw new Exception("Parser Error: expecting a boolean after \"B\"");
			tokenStream.nextToken(); //eat the constant
			break;
		case('G'):
			returnValue = new BoolAccess(walker,vertexNum, parseIndex());
			break;
			
		case('+'): case('-'): case('*'): case('/'):
		case('I'): case('R'): case('N'): case('X'):
		case('Y'): case('U'): case('V'):
			throw new Exception("Parser Error: received type " + type + "when expecting a real.");
		default:
			throw new Exception("Parser Error: type " + type + "not understood.");
		}
		
	    if (tokenStream.ttype != ')') throw new Exception("Parser Error: expecting a ')'");
		tokenStream.nextToken(); //eat the ')'
		return returnValue;
	}

	private IndexExpr parseIndex() throws IOException, Exception
	{
		char type = parseType();
		IndexExpr returnValue;

		switch (type)
		{
		case('N'):
			if (tokenStream.ttype != StreamTokenizer.TT_NUMBER) throw new Exception("Parser Error: expecting a number after \"R\"");
			returnValue = new IndexExpr(walker,vertexNum, (int)tokenStream.nval);
			tokenStream.nextToken(); //eat the number
			break;

		case('='): case('<'): case('>'): case('B'):
		case('+'): case('-'): case('*'): case('/'):
		case('I'): case('R'): case('X'): case('Y'):
		case('U'): case('V'): case('G'):
			throw new Exception("Parser Error: received type " + type + "when expecting an index.");
		default:
			throw new Exception("Parser Error: type " + type + "not understood.");
		}
		
	    if (tokenStream.ttype != ')') throw new Exception("Parser Error: expecting a ')'");
		tokenStream.nextToken(); //eat the ')'
		return returnValue;
	}
	
	private char parseType() throws IOException, Exception
	{
	    if (tokenStream.ttype != '(') throw new Exception("Parser Error: expecting a '('");
		tokenStream.nextToken();  // eat the '('
		char type = (char)tokenStream.ttype;  //try to get the node operator as a symbol
		if (tokenStream.ttype <= 0){
			//maybe it's a letter?
			if (tokenStream.ttype == StreamTokenizer.TT_WORD)
				type = tokenStream.sval.charAt(0);
			else
				throw new Exception("Parser Error:  what the heck is "+tokenStream.ttype);
		}
		tokenStream.nextToken();  // eat the type
		return type;
	}
	
}
