/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class IndexExpr extends ASTNode
{
	public IndexExpr(Walker walker, int vertexNum, int	value)
	{
		super(walker,vertexNum);
		this.value = value;
	}
	protected int value;

	public int eval()
	{
		return value;
	}
	
	public void dumpNode(PrintWriter out)
	{
		out.print("(N " + value + ")");
	}
	
	public IndexExpr copy(Walker newWalker){
		return new IndexExpr(newWalker,vertexNum, value);
	}
	
	public IndexExpr mutate(){
		return IndexExpr.generate(walker,vertexNum);
	}
	
	static final double PROB_OF_ANOTHER_VERTEX = 0.3;
	
	public static IndexExpr generate(Walker walker, int vertexNum){
		double aNumber = Math.random();
		if (aNumber >= PROB_OF_ANOTHER_VERTEX)
			return new IndexExpr(walker,vertexNum, vertexNum);
		else
		{
			int index = (int)Math.floor(walker.getNumVertices() * aNumber / PROB_OF_ANOTHER_VERTEX);
			return new IndexExpr(walker,vertexNum, index);
		}
	}
	
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
	}

}
