/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class IfExpr extends RealExpr
{
	public IfExpr(Walker walker, int vertexNum, BoolExpr condition, RealExpr thenExpr, RealExpr elseExpr)
	{
		super(walker,vertexNum);
		this.condition = condition;
		this.thenExpr = thenExpr;
		this.elseExpr = elseExpr;
	}

	protected BoolExpr condition;
	protected RealExpr thenExpr;
	protected RealExpr elseExpr;

	public double eval()
	{
		if(condition.eval())
			return thenExpr.eval();
		else 
			return elseExpr.eval();
	}
	

	public void dumpNode(PrintWriter out)
	{
		out.print("(I");
		condition.dumpNode(out);
		thenExpr.dumpNode(out);
		elseExpr.dumpNode(out);
		out.print(")");
	}

	public RealExpr mutate()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return RealExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
		else
		{
			if (aNumber <= 0.4)
				condition = condition.mutate();
			else if (aNumber <= 0.7)
				thenExpr = thenExpr.mutate();
			else 
				elseExpr = elseExpr.mutate();
			return this;
		}
	}
	
	protected RealExpr insert(RealExpr subtree)
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return subtree;
		else
		{
			if ((aNumber <= 0.4) && (condition instanceof BoolWithRealChildren))
				condition = ((BoolWithRealChildren)condition).insert(subtree);
			else if (aNumber <= 0.7)
				thenExpr = thenExpr.insert(subtree);
			else 
				elseExpr = elseExpr.insert(subtree);
			return this;
		}
	}
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
		thenExpr.setNewWalker(newW, newIndex);
		elseExpr.setNewWalker(newW, newIndex);
		condition.setNewWalker(newW, newIndex);
	}
	public RealExpr getRandomChild()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return this;
		else if ((aNumber <= 0.4) && (condition instanceof BoolWithRealChildren))
			return ((BoolWithRealChildren)condition).getRandomChild();
		else if (aNumber <= 0.7)
			return thenExpr.getRandomChild();
		else 
			return elseExpr.getRandomChild();
	}
	
	public RealExpr copy(Walker newWalker){
		return new IfExpr(newWalker,vertexNum, condition.copy(newWalker), thenExpr.copy(newWalker), elseExpr.copy(newWalker));
	}
}
