/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.lang.Math;
import java.io.*;
import Walker;

public class Comparator extends BoolWithRealChildren
{
	public static final char RANDOM_OP = 0;
	public static final char CLOSE_TO = '='; 
	public static final char LESS = '<';
	public static final char GREATER = '>';

	//cumulative probabilitites
	public static final double CLOSE_TO_prob = 0.34;
	public static final double LESS_prob = 0.67;
	public static final double GREATER_prob = 1.0;
	

	protected char op;
	protected RealExpr left;
	protected RealExpr right;

	public Comparator(Walker walker, int vertexNum, char op, RealExpr left, RealExpr right)
	{
		super(walker,vertexNum);
		this.left = left;
		this.right = right;
		
		if (op != RANDOM_OP)
		{
			this.op = op;
		}
		else
		{
			double comparatorType = Math.random();
			if (comparatorType <= CLOSE_TO_prob)
				this.op = CLOSE_TO;
			else if (comparatorType <= LESS_prob)
				this.op = LESS;
			else  // comparatorType <= Comparator.GREATER_prob
				this.op = GREATER;
		}
	}

	private static final double THRESHOLD = 0.001;
	
	public boolean eval()
	{
		switch (op)
		{
		case CLOSE_TO: return Math.abs(left.eval() - right.eval()) < THRESHOLD;
		case LESS: return left.eval() < right.eval();
		case GREATER: return left.eval() > right.eval();
		default:
			System.out.println("Internal error:  Bad comparator.\n");
			return false;
		}
	}

	public void dumpNode(PrintWriter out)
	{
		out.print("("+op);
		left.dumpNode(out);
		right.dumpNode(out);
		out.print(")");
	}
	
	public BoolExpr mutate()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return BoolExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
		else 
		{
			if (aNumber <= 0.5)
				left = left.mutate();
			else 
				right = right.mutate();
			return this;
		}
	}
	protected BoolExpr insert(RealExpr subtree)
	{
		double aNumber = Math.random();
		if (aNumber <= 0.5)
			left = left.insert(subtree);
		else 
			right = right.insert(subtree);
		return this;
	}
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
		left.setNewWalker(newW, newIndex);
		right.setNewWalker(newW, newIndex);
	}

	public RealExpr getRandomChild()
	{
		double aNumber = Math.random();
		if (aNumber <= 0.5)
			return left.getRandomChild();
		else 
			return right.getRandomChild();
	}
	
	public BoolExpr copy(Walker newWalker){
		return new Comparator(newWalker,vertexNum, op, left.copy(newWalker), right.copy(newWalker));
	}
}