/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public abstract class BoolExpr extends ASTNode
{
	//cumulative probabilitites
	public static final double COMPARATOR_prob = 0.60;
	public static final double CONST_prob = 1.00;

	public static BoolExpr generate (Walker walker, int vertexNum, double probOfChildren)
	{
		double randomNum = Math.random();
		
		if (randomNum < probOfChildren)
		{
			double probOfGrandchildren = probOfChildren*PROB_OF_MORE_CHILDREN;
			return new Comparator(walker,vertexNum, 
								  Comparator.RANDOM_OP,
								  RealExpr.generate(walker,vertexNum, probOfGrandchildren),
								  RealExpr.generate(walker,vertexNum, probOfGrandchildren));
		}
		else 
		{	if(Math.random() < 0.5)
				return new BoolConst(walker,vertexNum, true);
			else 
				return new BoolConst(walker,vertexNum, false);
		}
	}
	
	public abstract boolean eval();
	public abstract BoolExpr mutate();
	public abstract BoolExpr copy(Walker newWalker);
		
	protected BoolExpr(Walker walker, int vertexNum){
		super(walker,vertexNum);
	}
}

//if a subclass of BoolExpr implements this, it's safe to insert
abstract class BoolWithRealChildren extends BoolExpr
{
	//replaces a random child node with the specified subtree
	//Don't call on BoolConst or BoolAccess, because it has no real-valued subtrees
	protected abstract BoolExpr insert(RealExpr subtree);
	
	public abstract RealExpr getRandomChild();

	protected BoolWithRealChildren(Walker walker, int vertexNum){
		super(walker,vertexNum);
	}
}
