/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class BoolConst extends BoolExpr
{
	protected boolean value;
	
	public BoolConst(Walker walker, int vertexNum, boolean value)
	{
		super(walker,vertexNum);
		this.value = value;
	}

	public boolean eval()
	{
		return value;
	}
	
	public void dumpNode(PrintWriter out)
	{
		out.print("(B " + value + ")");
	}

	public BoolExpr mutate()
	{
		return BoolExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
	}
	
	public BoolExpr copy(Walker newWalker){
		return new BoolConst(newWalker,vertexNum, value);
	}

	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
	}

}
