/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class BinaryOp extends RealExpr
{
	public static final char RANDOM_OP = 0;
	public static final char PLUS = '+';
	public static final char MINUS = '-';
	public static final char TIMES = '*';
	public static final char DIV = '/';

	//cumulative probabilitites
	public static final double PLUS_prob = 0.4;
	public static final double MINUS_prob = 0.8;
	public static final double TIMES_prob = 0.9;
	public static final double DIV_prob = 1.0;
	
	public BinaryOp(Walker walker, int vertexNum, char op, RealExpr left, RealExpr right)
	{
		super(walker,vertexNum);
		this.left = left;
		this.right = right;
		
		if (op != RANDOM_OP)
			this.op = op;
		else
			this.op = getRandomOp();
	}

	protected char op;
	protected RealExpr left;
	protected RealExpr right;

	public double eval()
	{
		switch (op)
		{
		case PLUS: return left.eval() + right.eval();
		case MINUS: return left.eval() - right.eval();
		case TIMES: return left.eval() * right.eval();
		case DIV:
			double rightValue = right.eval();
			if(rightValue == 0)
				return 0;
			else
				return left.eval() / rightValue;
		default:
			System.out.println("Internal error:  Bad op\n");
			return 0;
		}
	}
	

	public void dumpNode(PrintWriter out)
	{
		out.print("("+op);
		left.dumpNode(out);
		right.dumpNode(out);
		out.print(")");
	}
	
	public RealExpr mutate()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return RealExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
		else
		{
			if (aNumber <= 0.5)
				left = left.mutate();
			else 
				right = right.mutate();
			return this;
		}
	}
	
	protected RealExpr insert(RealExpr subtree)
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return subtree;
		else
		{
			if (aNumber <= 0.5)
				left = left.insert(subtree);
			else 
				right = right.insert(subtree);
			return this;
		}
	}
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
		left.setNewWalker(newW, newIndex);
		right.setNewWalker(newW, newIndex);
	}
	
	public RealExpr getRandomChild()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return this;
		else if (aNumber <= 0.5)
			return left.getRandomChild();
		else 
			return right.getRandomChild();
	}
	
	private static final char getRandomOp()
	{
		double opType = Math.random();
		if (opType <= PLUS_prob)
			return PLUS;
		else if (opType <= MINUS_prob)
			return MINUS;
		else if (opType <= TIMES_prob)
			return TIMES;
		else  // opType <= Comparator.DIV_prob
			return DIV;
	}
	
	public RealExpr copy(Walker newWalker){
		return new BinaryOp(newWalker,vertexNum, op, left.copy(newWalker), right.copy(newWalker));
	}
}
