/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public class Accessor extends RealExpr
{
	public static final char RANDOM_OP = 0;
	public static final char GET_X = 'X';
	public static final char GET_Y = 'Y';
	public static final char GET_VX = 'U';
	public static final char GET_VY = 'V';

	//cumulative probabilitites
	static final double X_prob = 0.4;
	static final double Y_prob = 0.8;
	static final double VX_prob = 0.9;
	static final double VY_prob = 1.0;
	
	char op;
	IndexExpr index;
	
	public Accessor(Walker walker, int vertexNum, char op, IndexExpr index)
	{
		super(walker,vertexNum);
		this.index = index;
		this.op = op;
		if (op == RANDOM_OP)
			this.op = getRandomOp();
	}
	
	
	public double eval()
	{
		int i = index.eval();
		if ( i >= walker.getNumVertices())
		{
			System.out.println("Bad index: " + i);
			i = 0;
		}
		switch (op) 
		{
		case(GET_X):
			return walker.getXScaled(i);
		case(GET_Y):
			return walker.getYScaled(i);
		case(GET_VX):
			return walker.getVXScaled(i);
		case(GET_VY):
			return walker.getVYScaled(i);
		default:
			System.out.println("I have no idea what that operator is.");
			return 0;
		}
	}
	
	public void dumpNode(PrintWriter out)
	{
		out.print("("+op);
		index.dumpNode(out);
		out.print(")");
	}
	
	public RealExpr mutate()
	{
		double aNumber = Math.random();
		if (aNumber <= PROB_OF_USING_THIS_NODE)
			return RealExpr.generate(walker,vertexNum, PROB_OF_CHILDREN_IN_MUTATION);
		else
		{
			index = index.mutate();
			return this;
		}
	}
	
	//always replace
	protected RealExpr insert(RealExpr subtree)
	{
		return subtree;
	}
	public void setNewWalker(Walker newW, int newIndex) {
		walker = newW;    vertexNum = newIndex;
		index.setNewWalker(newW, newIndex);
	}

	
	private static final char getRandomOp()
	{
		double opType = Math.random();
		if (opType <= X_prob)
			return GET_X;
		else if (opType <= Y_prob)
			return GET_Y;
		else if (opType <= VX_prob)
			return GET_VX;
		else  // opType <= VY_prob
			return GET_VY;
	}
	
	public RealExpr getRandomChild()
	{
		return this;
	}
	
	
	public RealExpr copy(Walker newWalker){
		return new Accessor(newWalker,vertexNum, op, index.copy(newWalker));
	}
	
}
