/************************
* Vertex Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

package Program;

import java.io.*;
import Walker;

public abstract class ASTNode implements Serializable
{
	protected ASTNode(Walker walker, int vertexNum){
		this.walker = walker;
		this.vertexNum = vertexNum;
	}
	protected Walker walker;
	protected int vertexNum;

	public static final double PROB_OF_MORE_CHILDREN = 0.80;
	public static final double PROB_OF_USING_THIS_NODE = 0.20;
	public static final double PROB_OF_CHILDREN_IN_MUTATION = 0.40;
	
	abstract public void setNewWalker(Walker newW, int newIndex);
	abstract public void dumpNode(PrintWriter out);
	public void dumpToFile(String filename)
	{
		try {
			PrintWriter output = new PrintWriter(new FileOutputStream(filename));			
			dumpNode(output);
			output.close();
		} 
		catch (IOException e)	{
			e.printStackTrace();
		}
	}
	public void dumpToScreen()
	{
		PrintWriter console = new PrintWriter(System.out);
		dumpNode(console);
		console.flush();
	}

}
