/*
 * Swing version.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.border.Border;
import javax.swing.*;
import javax.swing.event.*;
import java.util.Vector;
import java.text.NumberFormat;
import java.io.*;
import Program.*;

public class PhysicalSim extends JFrame
                                      implements ActionListener {
    int frameNumber = -1;
    Timer timer;
    boolean frozen = false;
    JLabel label;
	animFrame animation;
	NumberFormat formatter;
	boolean bruce, scroll;
	String fileToLoad;
	
	
    PhysicalSim(int fps, String fileToLoad, String windowTitle, boolean bruce) {
        super(windowTitle);
		this.bruce = bruce;
		this.fileToLoad = fileToLoad;
		
        int delay = (fps > 0) ? (1000 / fps) : 100;

		//Set up a timer that calls this object's action handler.
        timer = new Timer(delay, this);
        timer.setInitialDelay(0);
        timer.setCoalesce(true);

        addWindowListener(new WindowAdapter() {
            public void windowIconified(WindowEvent e) {
                stopAnimation();
            }
            public void windowDeiconified(WindowEvent e) {
                startAnimation();
            }
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }  
        });

		label = new JLabel("x value: ", JLabel.CENTER);

		animation = new animFrame(this);
        getContentPane().add(label, BorderLayout.NORTH);
		getContentPane().add(animation, BorderLayout.CENTER);
		
		formatter = NumberFormat.getInstance();
		formatter.setMaximumFractionDigits(4);
    }

    //Can be invoked by any thread (since timer is thread-safe).
    public void startAnimation() {
        if (frozen) {
            //Do nothing.  The user has requested that we
            //stop changing the image.
        } else {
            //Start animating!
            if (!timer.isRunning()) {
				if(bruce)
				{
					repaint();
					try {
						Thread.sleep(3000);
					} catch (Exception e) {}
				}
                timer.start();
            }
        }
    }

    //Can be invoked by any thread (since timer is thread-safe).
    public void stopAnimation() {
        //Stop the animating thread.
        if (timer.isRunning()) {
            timer.stop();
        }
    }

    public void actionPerformed(ActionEvent e) {
        //Advance the animation frame.
        frameNumber++;
		animation.walkingThing.w.step(true);
		repaint();
		label.setText( "x value: "+formatter.format(animation.walkingThing.w.getTorsoX())
					  +"   time: "+frameNumber);
    }

	public void updateLabel(Point point) {
    }
	
	public static void main(String args[]) {
		PhysicalSim animator = null;
		
		int fps = 10;
		boolean bruce = false;
		String fileToLoad = "best.txt";
		int i = 0;
		try {
			for (; i < args.length; i++)
			{
				if (args[i].equals("-bruce")) {
					bruce = true;
					continue;
				}
				if (args[i].equals("-f")) {
					i++;
					fps = Integer.parseInt(args[i]);
					continue;
				}
				if (args[i].charAt(0) != '-') {
					fileToLoad = args[i];
					continue;
				}
				System.out.println("What does " + args[i] + " mean?");
				System.exit(1);
			}
		} catch (NumberFormatException nfe) {
			System.out.println("Umm... since when is \""+args[i]+"\" an integer?");
			System.exit(1);
		} catch (Exception e) {}
		String windowTitle =  bruce ? "Bruce on Broadway" : "Walker visualization";
		
		animator = new PhysicalSim(fps, fileToLoad, windowTitle, bruce);
		animator.pack();
		animator.setVisible(true);
		
		//startAnimation can be invoked by any thread.
		animator.startAnimation();
	}
	
	static final int VERTEX = 0;
	static final int FOOT = 1;

	public class WalkerWrapper{
		Walker w;
		Image body;
		Component c;
		
		public WalkerWrapper(Walker t){
			w = t;
			body = Toolkit.getDefaultToolkit().getImage("bruce_tutu.jpg");
		}
		
		public void setComponent(Component cc){
			c = cc;
		}
		
		public void draw(Graphics g){
			int yOffset = 460;
			int vRadius = 5;
			
			int screenWidth = 600;
			int moveOffset = 300;
			
			Vector vertices = w.vertices;
			Vertex tempA = (Vertex)vertices.elementAt(0);
			Vertex tempB = (Vertex)vertices.elementAt(1);
			Vertex tempC = (Vertex)vertices.elementAt(2);
			g.drawLine((int)tempA.getX()-(int)tempB.getX() + vRadius+moveOffset, yOffset - (int)tempA.getY() + vRadius,
					   2*vRadius+moveOffset, yOffset - (int)tempB.getY() + 2*vRadius);
			g.drawLine((int)tempC.getX()-(int)tempB.getX() + vRadius+moveOffset, yOffset - (int)tempC.getY() + vRadius,
					   2*vRadius+moveOffset, yOffset - (int)tempB.getY() + 2*vRadius);

			int triangleOffset = 100;
			for(int i=0;i<screenWidth;i+=50){
				g.setColor(Color.red);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)+i, 200+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)+i-10, 205+triangleOffset);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)+i, 200+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)+i-10, 195+triangleOffset);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)-i, 200+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)-i-10, 205+triangleOffset);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)-i, 200+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)-i-10, 195+triangleOffset);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)+i-10, 205+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)+i-10, 195+triangleOffset);
				g.drawLine(screenWidth-((int)tempB.getX()%screenWidth)-i-10, 205+triangleOffset,
						   screenWidth-((int)tempB.getX()%screenWidth)-i-10, 195+triangleOffset);

			}
			

			g.setColor(Color.black);
			g.drawLine(0,yOffset+2*vRadius,640,yOffset+2*vRadius);
			
			// left foot
			g.setColor(Color.magenta);
			g.fillOval((int)tempA.getX() - (int)tempB.getX() + moveOffset, yOffset-(int)tempA.getY(),vRadius*2,vRadius*2);
			g.setColor(Color.black);
			g.drawOval((int)tempA.getX() - (int)tempB.getX() + moveOffset,yOffset-(int)tempA.getY(),vRadius*2,vRadius*2);
			
			// torso
			if(bruce)
			{
				g.drawImage(body, moveOffset-18, (yOffset-(int)tempB.getY())-45, c);
				c.repaint();
			}
			else
			{
				g.setColor(Color.blue);
				g.fillOval(moveOffset, yOffset-(int)tempB.getY(),vRadius*4,vRadius*4);
				g.setColor(Color.black);
				g.drawOval(moveOffset,yOffset-(int)tempB.getY(),vRadius*4,vRadius*4);
			}
			
			// right foot
			g.setColor(Color.cyan);
			g.fillOval((int)tempC.getX() - (int)tempB.getX() + moveOffset, yOffset-(int)tempC.getY(),vRadius*2,vRadius*2);
			g.setColor(Color.black);
			g.drawOval((int)tempC.getX() - (int)tempB.getX() + moveOffset,yOffset-(int)tempC.getY(),vRadius*2,vRadius*2);
			
		}
			
		
	}
	
	static final int WIDTH = 640;
	static final int HEIGHT = 480;
	
	class animFrame extends JPanel {
	    Point point = null;
		PhysicalSim controller;
		Dimension preferredSize = new Dimension(PhysicalSim.WIDTH,PhysicalSim.HEIGHT);
	    int rectWidth = 50;
	    int rectHeight = 50;
		WalkerWrapper walkingThing = null;

		public animFrame(PhysicalSim controller) {
			this.controller = controller;
	
			Border raisedBevel = BorderFactory.createRaisedBevelBorder();
			Border loweredBevel = BorderFactory.createLoweredBevelBorder();
			Border compound = BorderFactory.createCompoundBorder
								(raisedBevel, loweredBevel);
			setBorder(compound);
	
			addAllObjects(controller.fileToLoad);
			
			addMouseListener(new MouseAdapter() {
	            public void mousePressed(MouseEvent e) {
					int x = e.getX();
					int y = e.getY();
					if (point == null) {
	                    point = new Point(x, y);
					} else {
	                    point.x = x;
						point.y = y;
					}
					repaint();
				}
			});
		}
	
		// this adds the objects to be animated
		public void addAllObjects(String fileToLoad){
			Walker w = new Walker(fileToLoad);;
			
			GA genePool = new GA();
			System.out.println(genePool.fitness(w));
			
			w.resetLocations();
			walkingThing = new WalkerWrapper(w);
			walkingThing.setComponent(this);
		}

		
		public Dimension getPreferredSize() {
		    return preferredSize;
		}
	
	    public void paintComponent(Graphics g) {
			super.paintComponent(g);  //paint background
	
			if(walkingThing != null){
				walkingThing.draw(g);
			}
		}
	}	
}
