/************************
* Walker Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

import java.util.Vector;
import java.io.*;
import Program.*;

public class GA{

	public GA(){
	}
	
	public static void main(String[] args){
	
		GA g = new GA();
		try{
			g.evolve(Integer.parseInt(args[0]),
					 Integer.parseInt(args[1]),
					 Double.valueOf(args[2]).doubleValue(),
					 Double.valueOf(args[3]).doubleValue(),
					 Integer.parseInt(args[4]),
				     (args.length > 5) ? args[5] : null);
		}
		catch (ArrayIndexOutOfBoundsException a)
		{
			a.printStackTrace();
			System.out.println("Format: GA pop_size max_gen mutation_prob cross_prob {0/1} [filename for seed]");
			System.out.println("\nSee the README file.");
		}
	}
	
	public void evolve(int ps, int mg, double mp, double cp, int st, String seed){
		
		// in reality we'll have to initialize the population somehow
		Vector population = new Vector();
		if (seed != null)
		{
			int ii;
			Walker best = new Walker(seed);
			for (ii = 0; ii < ps/10; ii++) {
				population.addElement(best);
			}
			for(; ii<ps;ii++){
				population.addElement(new Walker());
			}
		}
		else
		{
			for(int i=0;i<ps;i++){
				population.addElement(new Walker());
			}
		}
		
		double mutationProb = mp;
		double crossProb = cp;
		int	maxGen = mg;
		int	M =	ps;	// number of individuals in	population
		
		int selectionType = st;
		
		int	curBest; //	index into vector of best individual in	population
		double	curBestFitness;	// fitness of that individual;
		
		Walker Best = null; //	data structure to hold the best	individual ever	found
		double	BestFitness	= 260; //	fitness	of the best	individual ever	found

		double tempFitness = 0;
		double[] probVector = new double[M];
		
		for(int	i=1;i<maxGen;i++){

			curBest	= 0;
			curBestFitness = 260;	

			for(int	j=0;j<M;j++){
				tempFitness	= fitness((Walker)population.elementAt(j)) + 1;
				probVector[j] = tempFitness;
				if(tempFitness > curBestFitness){
					curBest	= j;
					curBestFitness = tempFitness;
				}
			}
				
			
			// if the fitnesses all SuX0rz we will regenerate the entire population and
			// skip to the next generation
			if(curBestFitness == 261){
				population.removeAllElements();
				System.gc();
				System.out.println(i+"\t"+BestFitness);
				for(int j=0;j<ps;j++){
					population.addElement(new Walker());
				}
				continue;
			}
			
			//////// elitism, stuff the best into the population, replacing the worst one
			if(Best != null){ // only do this, of course, if we have a best one
				double minFitness = 99999999;
				int minIndex = 0;
				for(int j=0;j<M;j++){
					if(probVector[j] < minFitness){
						minFitness = probVector[j];
						minIndex = j;
					}
				}
				population.setElementAt(Best.copy(),minIndex);
				if(BestFitness > curBestFitness){
					curBest = minIndex;
					curBestFitness = BestFitness;
				}
			}
			//////// end of elitism code
			System.out.println(i+"\t"+BestFitness);
			
			if(curBestFitness >	BestFitness){
				Best = ((Walker)population.elementAt(curBest)).copy();
				BestFitness	= curBestFitness;
				Best.dumpToFile("walker"+(int)curBestFitness+".txt",
								i, ps, mg, mp, cp);
			}

			// get offspring for the next population
			// first select	from the population	the	parents
			// then	perform	crossover
			// then	mutate with	some probability
			population = Rselect(population, probVector, selectionType);
			System.gc();
			population = cross(population, crossProb);
			System.gc();
			population = mutate(population,mutationProb);
			System.gc();
			
		}
		Best.dumpToFile("best.txt", mg, ps, mg, mp, cp);
	}
	
	// returns parents, 
	// performing roulette wheel selection if selectionType is 0
	// performing weak tournament selection if selectionType is 1
	public Vector Rselect(Vector pop, double[] probVector, int selectionType){

		Vector parents = new Vector();
		
		//roulette wheel selection
		if(selectionType == 0){
			
			double[] cumVector = new double[pop.size()];
			double sumFitness = 0;

			// Create a probability Vector. Each value in the vector is a probability,
			// adding on to its predecessor. The final value should be 1. This makes
			// a "roulette-wheel" selection process simple.
			for(int i=0;i<probVector.length;i++){
				sumFitness = sumFitness + probVector[i];
			}

			if(sumFitness <= 0.00001){
				for(int i=0;i<probVector.length;i++){
					cumVector[i] = ((double)(i+1))/probVector.length;
				}
			}else{
				for(int i=0;i<probVector.length;i++){
					cumVector[i] = probVector[i]/sumFitness;
					if(i>0){
						cumVector[i] += cumVector[i-1];
					}
				}
			}
			// Now we select the parents.
			// Each pair of parents will produce two children through crossover.
			// A pair of parents cannot be the same individual, twice.
			double randKey;
			int firstIndex;
			int secondIndex;
			for(int i=0;i<pop.size();i++){
				firstIndex = 0;
				randKey = Math.random();
				
				while(randKey>cumVector[firstIndex]){
					firstIndex++;
				}
				do{
					secondIndex = 0;
					randKey = Math.random();
					while(randKey>cumVector[secondIndex]){
						secondIndex++;
					}
				}while(secondIndex == firstIndex);
				
				parents.addElement( ((Walker)pop.elementAt(firstIndex)).copy());
				parents.addElement( ((Walker)pop.elementAt(secondIndex)).copy());
			}
		}		
		// tournament selection
		if(selectionType == 1){
			int index = 0;
			int firstIndex = 0;
			int secondIndex = index;
			double tempFitness = 0;
			
			for(int j=0;j<pop.size();j++){

				// given n elements,
				// want to choose an index from 1 to n-1.
				// this is random * (n-2) + 1
				index = (int)Math.random()*(probVector.length-2)+1;
				
				tempFitness = 0;
				for(int i=0;i<index;i++){
					if(probVector[i] > tempFitness){
						tempFitness = probVector[i];
						firstIndex = i;
					}
				}
				
				tempFitness = 0;
				for(int i=index;i<probVector.length;i++){
					if(probVector[i] > tempFitness){
						tempFitness = probVector[i];
						secondIndex = i;
					}
				}
				
				parents.addElement( ((Walker)pop.elementAt(firstIndex)).copy());
				parents.addElement( ((Walker)pop.elementAt(secondIndex)).copy());
			}
		}
		
		return parents;
	}
	
	// passing in population of parents to do crossover with to produce M offspring
	public Vector cross(Vector parents, double crossProb){
		Vector offspring = new Vector();
		Walker parent1 = null;
		Walker parent2 = null;
		RealExpr tempHolder = null;
		int crossIndex = 0;
		
		for(int i=0;i<parents.size();i+=2){
			parent1 = (Walker)parents.elementAt(i);
			parent2 = (Walker)parents.elementAt(i+1);
			
			if(Math.random() > crossProb){
				// just use a form of elitism if we don't cross over
				offspring.addElement(parent1);
			}else{
				crossIndex = (int)(Math.random()*parent1.programs.size());
				tempHolder = ((RealExpr)parent1.programs.elementAt(crossIndex))
					.insertCross(((RealExpr)parent2.programs.elementAt(crossIndex)).getRandomChild(),
								 parent1, crossIndex);  //remap the subtree to use new parent to get location info.
				parent1.programs.setElementAt(tempHolder,crossIndex);
				offspring.addElement(parent1);
			}
		}
		
		return offspring;
	}
	
	// passing in population of children to mutate with probability mutationProb
	public Vector mutate(Vector pop, double mutationProb){
		
		Vector mutants = new Vector();
		Walker tempWalker;
		double randKey;
		
		for(int i=0;i<pop.size();i++){
			if(Math.random() < mutationProb){
				// do something the pop.elementAt(i) and addElement to mutants..
				tempWalker = (Walker)pop.elementAt(i);
				randKey = Math.random();
				if(randKey < (1.0/3.0)){
					tempWalker.programs.setElementAt(((RealExpr)tempWalker.programs.elementAt(0)).mutate(), 0);
				}else if(randKey < (2.0/3.0)){
					tempWalker.programs.setElementAt(((RealExpr)tempWalker.programs.elementAt(1)).mutate(), 1);
				}else{
					tempWalker.programs.setElementAt(((RealExpr)tempWalker.programs.elementAt(2)).mutate(), 2);
				}
				mutants.addElement(tempWalker);
			}else{
				mutants.addElement(pop.elementAt(i));
			}
		}
		
		return mutants;
	}
	
	// calculate the fitness of the individual
	public double fitness(Walker individual){

		int stepRes = 0;
		
		individual.resetLocations();
		
		for(int i=0;i<750;i++){
			stepRes = individual.step(false);
			if(stepRes == Walker.STEP_OK){
				continue;
			}
			if(stepRes == Walker.STEP_DEAD){
				individual.cleanLocations();
				return 0;
			}
			if(stepRes == Walker.STEP_STUCK){
				double fitness = individual.getTorsoX();
				individual.cleanLocations();
				return fitness;
			}
		}
		
		
		double fitness = individual.getTorsoX();
		individual.cleanLocations();
		return fitness;
	}
}