/* The following code was generated by JFlex 1.5.1 */

package ppg.lex;

import java.io.Reader;
import ppg.parse.*;

@SuppressWarnings({"unused", "fallthrough"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.5.1
 * from the specification file <tt>ppg.flex</tt>
 */
public class Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 2;
  public static final int STRING = 4;
  public static final int CODE = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3, 3
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\5\1\6\1\5\1\5\22\0\1\13\1\12\1\23"+
    "\2\12\1\62\4\12\1\7\1\12\1\52\1\12\1\51\1\4\12\2"+
    "\1\10\1\50\1\56\1\47\1\57\1\60\1\22\15\1\1\15\14\1"+
    "\1\54\1\14\1\55\1\20\1\21\1\22\1\37\1\1\1\25\1\30"+
    "\1\31\1\41\1\43\1\46\1\24\1\1\1\42\1\26\1\44\1\16"+
    "\1\34\1\35\1\1\1\33\1\40\1\17\1\27\1\36\1\45\1\32"+
    "\2\1\1\53\1\61\1\11\1\22\6\0\1\6\u1fa2\0\1\6\1\6"+
    "\udfd6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\0\1\2\1\3\1\4\1\2\1\5"+
    "\1\6\1\7\2\3\1\10\13\3\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\2"+
    "\1\23\1\0\1\23\1\24\1\1\1\25\1\26\1\27"+
    "\1\0\1\27\1\4\1\30\1\0\3\3\1\31\16\3"+
    "\1\32\2\0\1\33\4\0\1\34\1\35\1\36\22\3"+
    "\2\0\4\3\1\37\3\3\1\40\1\41\1\42\10\3"+
    "\1\43\1\44\1\0\10\3\1\45\5\3\1\46\1\47"+
    "\6\3\1\50\1\51\3\3\1\52\1\53\4\3\1\54"+
    "\1\3\1\55\2\3\1\56\1\3\1\57\1\60\1\61"+
    "\1\3\1\62\5\3\1\63\1\64\1\65";

  private static int [] zzUnpackAction() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\u0132\0\u0165"+
    "\0\314\0\u0198\0\314\0\u01cb\0\u01fe\0\314\0\u0231\0\u0264"+
    "\0\u0297\0\u02ca\0\u02fd\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc"+
    "\0\u042f\0\314\0\314\0\314\0\u0462\0\314\0\314\0\314"+
    "\0\314\0\314\0\314\0\u0495\0\u04c8\0\u04c8\0\u04fb\0\314"+
    "\0\u052e\0\u0561\0\314\0\u0594\0\u0594\0\u05c7\0\u05fa\0\314"+
    "\0\u062d\0\u0660\0\u0693\0\u06c6\0\377\0\u06f9\0\u072c\0\u075f"+
    "\0\u0792\0\u07c5\0\u07f8\0\u082b\0\u085e\0\u0891\0\u08c4\0\u08f7"+
    "\0\u092a\0\u095d\0\u0990\0\314\0\u09c3\0\u04fb\0\314\0\u09f6"+
    "\0\u0a29\0\u0a5c\0\u05c7\0\314\0\314\0\u0a8f\0\u0ac2\0\u0af5"+
    "\0\u0b28\0\u0b5b\0\u0b8e\0\u0bc1\0\u0bf4\0\u0c27\0\u0c5a\0\u0c8d"+
    "\0\u0cc0\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf\0\u0df2\0\u0e25"+
    "\0\u0e58\0\u0e8b\0\u0ebe\0\u0ef1\0\u0f24\0\u0f57\0\377\0\u0f8a"+
    "\0\u0fbd\0\u0ff0\0\377\0\377\0\377\0\u1023\0\u1056\0\u1089"+
    "\0\u10bc\0\u10ef\0\u1122\0\u1155\0\u1188\0\377\0\377\0\u11bb"+
    "\0\u11ee\0\u1221\0\u1254\0\u1287\0\u12ba\0\u12ed\0\u1320\0\u1353"+
    "\0\377\0\u1386\0\u13b9\0\u13ec\0\u141f\0\u1452\0\377\0\314"+
    "\0\u1485\0\u14b8\0\u14eb\0\u151e\0\u1551\0\u1584\0\377\0\u15b7"+
    "\0\u15ea\0\u161d\0\u1650\0\377\0\377\0\u1683\0\u16b6\0\u16e9"+
    "\0\u171c\0\377\0\u174f\0\377\0\u1782\0\u17b5\0\377\0\u17e8"+
    "\0\377\0\377\0\377\0\u181b\0\377\0\u184e\0\u1881\0\u18b4"+
    "\0\u18e7\0\u191a\0\377\0\377\0\377";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\1\5\1\7\1\10\1\7\1\0\1\11"+
    "\1\12\1\13\1\5\1\7\1\5\1\6\1\14\1\15"+
    "\3\5\1\16\1\17\1\20\1\21\1\6\1\22\1\23"+
    "\1\6\1\24\1\25\1\26\1\6\1\27\1\30\4\6"+
    "\1\31\1\6\1\5\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\5\45\2\46"+
    "\1\47\53\45\1\50\2\51\1\50\1\51\2\0\5\51"+
    "\1\52\6\51\1\53\37\51\5\54\2\55\1\54\1\56"+
    "\52\54\64\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\23\6\17\0\1\7\1\0\1\7\5\0\1\7\53\0"+
    "\1\57\2\0\1\60\63\0\1\61\53\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\10\6\1\62\12\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\5\6\1\63"+
    "\1\6\1\64\1\65\12\6\15\0\2\6\12\0\1\6"+
    "\1\66\1\6\1\0\1\6\2\0\20\6\1\67\2\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\10\6"+
    "\1\70\12\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\5\6\1\71\15\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\7\6\1\72\13\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\6\6\1\73\14\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\1\74"+
    "\22\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\12\6\1\75\10\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\7\6\1\76\3\6\1\77\7\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\1\6\1\100"+
    "\21\6\15\0\2\6\12\0\2\6\1\101\1\0\1\6"+
    "\2\0\1\6\1\102\21\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\1\103\22\6\24\0\1\104\107\0"+
    "\1\105\25\0\7\46\1\106\57\46\1\107\2\46\1\106"+
    "\53\46\1\0\2\51\1\0\1\51\2\0\5\51\1\52"+
    "\6\51\1\53\37\51\2\0\1\110\1\111\1\0\1\111"+
    "\5\0\1\111\4\51\1\112\2\0\1\51\37\0\10\55"+
    "\1\113\62\55\1\113\1\114\51\55\5\57\2\0\54\57"+
    "\47\0\1\115\14\0\2\6\12\0\1\6\1\116\1\6"+
    "\1\0\1\6\2\0\23\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\7\6\1\117\13\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\13\6\1\120\7\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\1\121"+
    "\1\122\21\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\11\6\1\123\11\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\4\6\1\124\16\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\15\6\1\125\5\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\10\6"+
    "\1\126\12\6\15\0\2\6\12\0\2\6\1\127\1\0"+
    "\1\6\2\0\23\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\17\6\1\130\3\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\5\6\1\131\15\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\5\6\1\132"+
    "\15\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\1\6\1\133\5\6\1\134\13\6\15\0\2\6\12\0"+
    "\2\6\1\135\1\0\1\6\2\0\23\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\13\6\1\136\7\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\13\6"+
    "\1\137\7\6\15\0\2\6\12\0\2\6\1\140\1\0"+
    "\1\6\2\0\23\6\47\0\1\141\31\0\1\142\63\0"+
    "\1\111\1\0\1\111\5\0\1\111\1\51\47\0\1\51"+
    "\7\0\1\51\2\0\7\51\1\0\23\51\4\0\3\51"+
    "\3\0\1\51\2\0\2\6\12\0\2\6\1\143\1\0"+
    "\1\6\2\0\13\6\1\144\7\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\20\6\1\145\2\6\15\0"+
    "\2\6\12\0\1\6\1\146\1\6\1\0\1\6\2\0"+
    "\23\6\15\0\2\6\12\0\2\6\1\147\1\0\1\6"+
    "\2\0\23\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\2\6\1\150\20\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\2\6\1\151\5\6\1\152\12\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\5\6"+
    "\1\153\15\6\15\0\2\6\12\0\2\6\1\154\1\0"+
    "\1\6\2\0\23\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\11\6\1\155\11\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\5\6\1\156\15\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\22\6\1\157"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\7\6"+
    "\1\160\13\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\1\6\1\161\21\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\16\6\1\162\4\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\14\6\1\163\6\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\1\164"+
    "\22\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\7\6\1\165\13\6\15\0\2\6\12\0\1\6\1\166"+
    "\1\6\1\0\1\6\2\0\23\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\22\6\1\167\45\0\1\170"+
    "\33\0\1\51\61\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\5\6\1\171\15\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\14\6\1\172\6\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\1\173\22\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\14\6\1\174"+
    "\6\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\3\6\1\175\17\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\5\6\1\176\15\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\7\6\1\177\13\6\15\0"+
    "\2\6\12\0\1\6\1\200\1\6\1\0\1\6\2\0"+
    "\23\6\15\0\2\6\12\0\2\6\1\201\1\0\1\6"+
    "\2\0\23\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\7\6\1\202\13\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\5\6\1\203\15\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\13\6\1\204\7\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\5\6"+
    "\1\205\15\6\15\0\2\6\12\0\3\6\1\0\1\6"+
    "\2\0\10\6\1\206\12\6\15\0\2\6\12\0\2\6"+
    "\1\207\1\0\1\6\2\0\23\6\41\0\1\210\36\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\7\6\1\211"+
    "\13\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\14\6\1\212\6\6\15\0\2\6\12\0\1\6\1\213"+
    "\1\6\1\0\1\6\2\0\23\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\15\6\1\214\5\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\4\6\1\215"+
    "\16\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\20\6\1\216\2\6\15\0\2\6\12\0\2\6\1\217"+
    "\1\0\1\6\2\0\23\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\4\6\1\220\16\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\1\221\22\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\4\6\1\222"+
    "\16\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\17\6\1\223\3\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\7\6\1\224\13\6\15\0\2\6\12\0"+
    "\1\6\1\225\1\6\1\0\1\6\2\0\23\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\20\6\1\226"+
    "\2\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\10\6\1\227\12\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\13\6\1\230\7\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\5\6\1\231\15\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\5\6\1\232"+
    "\15\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\5\6\1\233\15\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\14\6\1\234\6\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\4\6\1\235\16\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\5\6\1\236"+
    "\15\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\5\6\1\237\15\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\1\240\22\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\1\6\1\241\21\6\15\0\2\6"+
    "\12\0\3\6\1\0\1\6\2\0\2\6\1\242\20\6"+
    "\15\0\2\6\12\0\3\6\1\0\1\6\2\0\7\6"+
    "\1\243\13\6\15\0\2\6\12\0\1\6\1\244\1\6"+
    "\1\0\1\6\2\0\23\6\15\0\2\6\12\0\3\6"+
    "\1\0\1\6\2\0\5\6\1\245\15\6\15\0\2\6"+
    "\12\0\1\6\1\246\1\6\1\0\1\6\2\0\23\6"+
    "\15\0\2\6\12\0\1\6\1\247\1\6\1\0\1\6"+
    "\2\0\23\6\15\0\2\6\12\0\2\6\1\250\1\0"+
    "\1\6\2\0\23\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\1\6\1\251\21\6\15\0\2\6\12\0"+
    "\3\6\1\0\1\6\2\0\13\6\1\252\7\6\15\0"+
    "\2\6\12\0\3\6\1\0\1\6\2\0\14\6\1\253"+
    "\6\6\15\0\2\6\12\0\3\6\1\0\1\6\2\0"+
    "\5\6\1\254\15\6\15\0\2\6\12\0\3\6\1\0"+
    "\1\6\2\0\2\6\1\255\20\6\14\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[6477];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\1\1\0\1\11\3\1\1\11\1\1\1\11"+
    "\2\1\1\11\13\1\3\11\1\1\6\11\2\1\1\0"+
    "\1\1\1\11\2\1\1\11\1\1\1\0\2\1\1\11"+
    "\1\0\22\1\1\11\2\0\1\11\4\0\2\11\23\1"+
    "\2\0\25\1\1\0\17\1\1\11\45\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

    private String filename = "";
/*
    private Position pos() {
        return new Position(filename, yyline+1, yycolumn);
    }
*/
    public Lexer(Reader in, String filename) {
        this(in);
        this.filename = filename;
    }

    private void error(String message) throws LexicalError {
        throw new LexicalError(filename, yyline+1, message);
    }

    private Token t(int id, Object value) {
        return new Token(id, filename, yyline + 1, yychar, yychar + yylength(), value);
    }

    private Token t(int id) {
        return t(id, yytext());
    }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 142) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

    // numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token getToken() throws java.io.IOException,     LexicalError
 {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { error("Unclosed string literal");
          }
        case 54: break;
        case 2: 
          { error("Invalid character: " + yytext());
          }
        case 55: break;
        case 3: 
          { return t(Constant.ID, yytext().intern());
          }
        case 56: break;
        case 4: 
          { 
          }
        case 57: break;
        case 5: 
          { return t(Constant.STAR);
          }
        case 58: break;
        case 6: 
          { return t(Constant.COLON);
          }
        case 59: break;
        case 7: 
          { return t(Constant.RBRACE);
          }
        case 60: break;
        case 8: 
          { yybegin(STRING);
          }
        case 61: break;
        case 9: 
          { return t(Constant.SEMI);
          }
        case 62: break;
        case 10: 
          { return t(Constant.DOT);
          }
        case 63: break;
        case 11: 
          { return t(Constant.COMMA);
          }
        case 64: break;
        case 12: 
          { return t(Constant.LBRACE);
          }
        case 65: break;
        case 13: 
          { return t(Constant.LBRACK);
          }
        case 66: break;
        case 14: 
          { return t(Constant.RBRACK);
          }
        case 67: break;
        case 15: 
          { return t(Constant.LT);
          }
        case 68: break;
        case 16: 
          { return t(Constant.GT);
          }
        case 69: break;
        case 17: 
          { return t(Constant.QUESTION);
          }
        case 70: break;
        case 18: 
          { return t(Constant.BAR);
          }
        case 71: break;
        case 19: 
          { error("Illegal comment");
          }
        case 72: break;
        case 20: 
          { error("Illegal character in string literal: " + yytext());
          }
        case 73: break;
        case 21: 
          { error("Illegal escape character");
          }
        case 74: break;
        case 22: 
          { yybegin(YYINITIAL);
    String literal = yytext();
    return t(Constant.STRING_CONST, literal.substring(0, literal.length()-1));
          }
        case 75: break;
        case 23: 
          { error("Invalid character in code block: '" + yytext() + "'");
          }
        case 76: break;
        case 24: 
          { yybegin (COMMENT);
          }
        case 77: break;
        case 25: 
          { return t(Constant.TO);
          }
        case 78: break;
        case 26: 
          { yybegin (CODE);
          }
        case 79: break;
        case 27: 
          { yybegin (YYINITIAL);
          }
        case 80: break;
        case 28: 
          { yybegin(YYINITIAL);
    String codeStr = yytext();
    // cut off ":}" from the end of the code string
    return t(Constant.CODE_STR, codeStr.substring(0, codeStr.length()-2));
          }
        case 81: break;
        case 29: 
          { return t(Constant.COLON_COLON_EQUALS);
          }
        case 82: break;
        case 30: 
          { return t(Constant.NON);
          }
        case 83: break;
        case 31: 
          { return t(Constant.INIT);
          }
        case 84: break;
        case 32: 
          { return t(Constant.CODE);
          }
        case 85: break;
        case 33: 
          { return t(Constant.LEFT);
          }
        case 86: break;
        case 34: 
          { return t(Constant.DROP);
          }
        case 87: break;
        case 35: 
          { return t(Constant.SCAN);
          }
        case 88: break;
        case 36: 
          { return t(Constant.WITH);
          }
        case 89: break;
        case 37: 
          { return t(Constant.RIGHT);
          }
        case 90: break;
        case 38: 
          { return t(Constant.START);
          }
        case 91: break;
        case 39: 
          { return t(Constant.PERCENT_PREC);
          }
        case 92: break;
        case 40: 
          { return t(Constant.IMPORT);
          }
        case 93: break;
        case 41: 
          { return t(Constant.EXTEND);
          }
        case 94: break;
        case 42: 
          { return t(Constant.PARSER);
          }
        case 95: break;
        case 43: 
          { return t(Constant.ACTION);
          }
        case 96: break;
        case 44: 
          { return t(Constant.INCLUDE);
          }
        case 97: break;
        case 45: 
          { return t(Constant.EXTENDS);
          }
        case 98: break;
        case 46: 
          { return t(Constant.PACKAGE);
          }
        case 99: break;
        case 47: 
          { return t(Constant.NONASSOC);
          }
        case 100: break;
        case 48: 
          { return t(Constant.TERMINAL);
          }
        case 101: break;
        case 49: 
          { return t(Constant.TRANSFER);
          }
        case 102: break;
        case 50: 
          { return t(Constant.OVERRIDE);
          }
        case 103: break;
        case 51: 
          { return t(Constant.IMPLEMENTS);
          }
        case 104: break;
        case 52: 
          { return t(Constant.PRECEDENCE);
          }
        case 105: break;
        case 53: 
          { return t(Constant.NONTERMINAL);
          }
        case 106: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return t(Constant.EOF, "EOF");
    //return Constant.EOF;
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
