/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.PrintStream;
import polyglot.pth.OutputController;
import polyglot.pth.ScriptTestSuite;
import polyglot.pth.SourceFileTest;
import polyglot.pth.Test;
import polyglot.pth.TestResult;
import polyglot.pth.TestSuite;
import polyglot.pth.TestSuiteResult;
import polyglot.util.ErrorQueue;

public class StdOutputController
extends OutputController {
    private static final int TEST_NAME_COLUMN_WIDTH = 30;

    public StdOutputController(PrintStream out) {
        super(out);
    }

    @Override
    protected void startScriptTestSuite(ScriptTestSuite sts) {
        this.out.println("Test script " + sts.getName());
    }

    @Override
    protected void finishScriptTestSuite(ScriptTestSuite sts) {
        if (!sts.success() && sts.failureMessage != null) {
            this.out.println(sts.failureMessage);
        }
        this.out.println(sts.getName() + ": " + sts.getSuccesfulTestCount() + " out of " + sts.getTotalTestCount() + " tests succeeded.");
    }

    @Override
    protected void startSourceFileTest(SourceFileTest sft) {
        this.out.print("  " + sft.getName() + ": ");
    }

    @Override
    protected void finishSourceFileTest(SourceFileTest sft, ErrorQueue eq) {
        if (sft.success()) {
            this.out.println("OK");
        } else if (sft.getFailureMessage() != null) {
            this.out.println(sft.getFailureMessage());
        } else {
            this.out.println("Failed (no message)");
        }
    }

    @Override
    public void displayTestSuiteResults(String suiteName, TestSuite ts) {
        TestSuiteResult tsr = ts.getTestSuiteResult();
        if (tsr == null || tsr.testResults.isEmpty()) {
            this.out.println("No test results for " + suiteName);
            return;
        }
        this.out.print("Test script \"" + tsr.testName + "\"");
        this.out.println("    Last run: " + this.getDateDisplay(tsr.dateTestRun));
        this.out.println("  Contains tests:");
        int total = 0;
        int grandTotal = 0;
        int lastSuccess = 0;
        int neverRun = 0;
        int neverSuccess = 0;
        for (Test t : ts.getTests()) {
            String testId = t.getUniqueId();
            TestResult tr = tsr.testResults.get(testId);
            if (TestSuite.executeTest(t.getName(), tr)) {
                this.displayTestResults(tr, t.getName());
                ++total;
                if (tr != null && tr.dateLastSuccess != null && tr.dateLastSuccess.equals(tr.dateTestRun)) {
                    ++lastSuccess;
                }
                if (tr == null || tr.dateTestRun == null) {
                    ++neverRun;
                }
                if (tr == null || tr.dateLastSuccess == null) {
                    ++neverSuccess;
                }
            }
            ++grandTotal;
        }
        this.out.print("Total tests displayed: " + total);
        if (total != grandTotal) {
            this.out.print(" (out of " + grandTotal + " in script)");
        }
        this.out.println();
        this.out.println("   Succeeded last run: " + lastSuccess);
        this.out.println("   Never run         : " + neverRun);
        this.out.println("   Never succeeded   : " + neverSuccess);
    }

    @Override
    public void displayTestResults(TestResult tr, String testName) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ");
        sb.append(testName);
        while (sb.length() < 30) {
            sb.append(' ');
        }
        sb.append(" run ");
        sb.append(this.getDateDisplay(tr == null ? null : tr.dateTestRun));
        sb.append("; success ");
        sb.append(this.getDateDisplay(tr == null ? null : tr.dateLastSuccess));
        this.out.println(sb.toString());
    }

    @Override
    public void warning(String w) {
        this.out.println("Warning: " + w);
    }
}

