/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.PrintStream;
import polyglot.pth.ScriptTestSuite;
import polyglot.pth.SourceFileTest;
import polyglot.pth.StdOutputController;
import polyglot.util.ErrorQueue;

public class QuietOutputController
extends StdOutputController {
    private final boolean showStartScript;
    private final boolean showFinishScript;
    private final boolean showScriptProgress;
    private final boolean showStartFile;
    private final boolean showFinishFile;
    private int count = 0;
    private static final char PROGRESS_PASS_CHAR = '.';
    private static final char PROGRESS_FAIL_CHAR = '!';
    private static final int PROGRESS_LIMIT = 50;

    public QuietOutputController(PrintStream out, boolean showStartScript, boolean showFinishScript, boolean showStartFile, boolean showFinishFile, boolean showScriptProgress) {
        super(out);
        this.showStartScript = showStartScript;
        this.showFinishScript = showFinishScript;
        this.showScriptProgress = showScriptProgress;
        this.showStartFile = showStartFile;
        this.showFinishFile = showFinishFile;
    }

    @Override
    protected void finishScriptTestSuite(ScriptTestSuite sts) {
        if (this.showScriptProgress) {
            this.out.println();
        }
        if (this.showFinishScript) {
            super.finishScriptTestSuite(sts);
        }
    }

    @Override
    protected void finishSourceFileTest(SourceFileTest sft, ErrorQueue eq) {
        if (this.showFinishFile) {
            super.finishSourceFileTest(sft, eq);
        } else if (this.showScriptProgress) {
            this.out.print(sft.success() ? (char)'.' : '!');
            if (++this.count >= 50) {
                this.out.println();
                this.count = 0;
            }
        }
    }

    @Override
    protected void startScriptTestSuite(ScriptTestSuite sts) {
        if (this.showStartScript) {
            super.startScriptTestSuite(sts);
        }
    }

    @Override
    protected void startSourceFileTest(SourceFileTest sft) {
        if (this.showStartFile) {
            super.startSourceFileTest(sft);
        }
    }
}

