/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import polyglot.pth.ScriptTestSuite;
import polyglot.pth.SourceFileTest;
import polyglot.pth.Test;
import polyglot.pth.TestResult;
import polyglot.pth.TestSuite;
import polyglot.util.ErrorQueue;

public abstract class OutputController {
    protected final PrintStream out;
    protected final Calendar today;
    protected final Calendar week;

    public OutputController(PrintStream out) {
        this.out = out;
        this.today = Calendar.getInstance();
        this.week = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        this.today.clear();
        this.today.set(now.get(1), now.get(2), now.get(5));
        this.week.setTimeInMillis(this.today.getTimeInMillis());
        this.week.add(5, -6);
    }

    public void startTest(Test t) {
        if (t instanceof ScriptTestSuite) {
            this.startScriptTestSuite((ScriptTestSuite)t);
        } else if (t instanceof SourceFileTest) {
            this.startSourceFileTest((SourceFileTest)t);
        }
    }

    public void finishTest(Test t, ErrorQueue eq) {
        if (t instanceof ScriptTestSuite) {
            this.finishScriptTestSuite((ScriptTestSuite)t);
        } else if (t instanceof SourceFileTest) {
            this.finishSourceFileTest((SourceFileTest)t, eq);
        }
    }

    protected abstract void startScriptTestSuite(ScriptTestSuite var1);

    protected abstract void startSourceFileTest(SourceFileTest var1);

    protected abstract void finishScriptTestSuite(ScriptTestSuite var1);

    protected abstract void finishSourceFileTest(SourceFileTest var1, ErrorQueue var2);

    public abstract void displayTestSuiteResults(String var1, TestSuite var2);

    public abstract void displayTestResults(TestResult var1, String var2);

    protected DateFormat getDefaultDateFormat() {
        return new SimpleDateFormat("d-MMM-yy");
    }

    protected DateFormat getSameYearDateFormat() {
        return new SimpleDateFormat("d-MMM");
    }

    protected DateFormat getSameWeekDateFormat() {
        return new SimpleDateFormat("EEE k:mm");
    }

    protected DateFormat getTodayDateFormat() {
        return new SimpleDateFormat("k:mm");
    }

    public String getDateDisplay(Date d) {
        if (d == null) {
            return "never";
        }
        Calendar dt = Calendar.getInstance();
        dt.setTime(d);
        DateFormat df = dt.after(this.today) ? this.getTodayDateFormat() : (dt.after(this.week) ? this.getSameWeekDateFormat() : (dt.get(1) == this.today.get(1) ? this.getSameYearDateFormat() : this.getDefaultDateFormat()));
        return df.format(d);
    }

    public abstract void warning(String var1);
}

