/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

abstract class CommandLineOption {
    final String[] switches;
    final String additionalArg;
    final String explanation;
    private int currOpt;

    public CommandLineOption(String swtch, String explanation) {
        this(swtch, null, explanation);
    }

    public CommandLineOption(String swtch, String additionalArgs, String explanation) {
        this.switches = new String[]{swtch};
        this.explanation = explanation;
        this.additionalArg = additionalArgs;
    }

    public CommandLineOption(String[] switches, String explanation) {
        this(switches, null, explanation);
    }

    public CommandLineOption(String[] switches, String additionalArgs, String explanation) {
        this.switches = switches;
        this.explanation = explanation;
        this.additionalArg = additionalArgs;
    }

    protected int parse(int currentInd, String[] args) {
        String s = args[currentInd];
        if (s.startsWith("-")) {
            while (s.startsWith("-")) {
                s = s.substring(1);
            }
            for (String switche : this.switches) {
                if (!switche.equals(s)) continue;
                this.currOpt = currentInd;
                return this.invoke(currentInd, args);
            }
        }
        return currentInd;
    }

    protected abstract int invoke(int var1, String[] var2);

    protected int getIntArg(int index, String[] args) {
        try {
            return Integer.parseInt(args[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Expected an integer for the option " + args[this.currOpt] + (this.additionalArg == null ? "" : " " + this.additionalArg));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer, not " + args[index]);
        }
    }

    protected String getStringArg(int index, String[] args) {
        try {
            return args[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Expected a string for the option " + args[this.currOpt] + (this.additionalArg == null ? "" : " " + this.additionalArg));
        }
    }
}

