/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.Branch;
import polyglot.ast.Do;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.ForUpdate;
import polyglot.ast.If;
import polyglot.ast.JLang;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.NodeVisitor;

public class LoopNormalizer
extends NodeVisitor {
    protected final Job job;
    protected final TypeSystem ts;
    protected final NodeFactory nf;

    public LoopNormalizer(Job job, TypeSystem ts, NodeFactory nf) {
        super(nf.lang());
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    @Override
    public JLang lang() {
        return (JLang)super.lang();
    }

    @Override
    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (n instanceof While) {
            While s = (While)n;
            return this.translateWhile(s);
        }
        if (n instanceof Do) {
            Do s = (Do)n;
            return this.translateDo(s);
        }
        if (n instanceof For) {
            For s = (For)n;
            return this.translateFor(s);
        }
        return n;
    }

    protected <N extends Node> N postCreate(N n) {
        return n;
    }

    protected String newId() {
        return UniqueID.newID("loop");
    }

    protected Block createBlock(List<Stmt> stmts) {
        return this.postCreate(this.nf.Block(Position.compilerGenerated(), stmts));
    }

    protected Block createBlock() {
        return this.postCreate(this.nf.Block(Position.compilerGenerated(), new Stmt[0]));
    }

    protected While createLoop(Loop source) {
        Position pos = source.position();
        While w = this.nf.While(pos, this.createBool(true), this.createBlock());
        w = this.postCreate(w);
        return w;
    }

    protected LocalDecl createLoopVar(Loop source, Expr cond) {
        Position pos = source.position();
        LocalInstance li = this.ts.localInstance(pos, Flags.NONE, this.ts.Boolean(), this.newId());
        LocalDecl var = this.nf.LocalDecl(pos, Flags.NONE, (TypeNode)this.postCreate(this.nf.CanonicalTypeNode(pos, this.ts.Boolean())), this.postCreate(this.nf.Id(pos, li.name())), cond);
        var = var.localInstance(li);
        var = this.postCreate(var);
        return var;
    }

    protected LocalDecl createLoopVar(Loop source) {
        return this.createLoopVar(source, this.createBool(false));
    }

    protected If createLoopIf(LocalDecl var, Stmt body) {
        Position pos = var.position();
        Local cond = this.createLocal(var.localInstance(), pos);
        Branch exit = this.postCreate(this.nf.Branch(pos, Branch.BREAK));
        If s = this.nf.If(pos, cond, body, exit);
        s = this.postCreate(s);
        return s;
    }

    protected Eval createAssign(LocalDecl var, Expr right) {
        Position pos = var.position();
        Local left = this.createLocal(var.localInstance(), pos);
        Eval a = this.nf.Eval(pos, this.postCreate(this.nf.Assign(pos, left, Assign.ASSIGN, right)));
        a = this.postCreate(a);
        return a;
    }

    protected Eval createAssign(LocalDecl var) {
        return this.createAssign(var, this.createBool(true));
    }

    protected If createInitIf(LocalDecl var, Expr cond) {
        Position pos = var.position();
        Local use = this.createLocal(var.localInstance(), pos);
        If s = this.nf.If(pos, use, this.createAssign(var, cond), this.createAssign(var));
        s = this.postCreate(s);
        return s;
    }

    protected If createIterIf(LocalDecl var, List<ForUpdate> iters) {
        Position pos = var.position();
        Local use = this.createLocal(var.localInstance(), pos);
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(iters.size());
        for (Stmt stmt : iters) {
            stmts.add(this.postCreate(stmt));
        }
        If s = this.nf.If(pos, use, this.createBlock(stmts));
        s = this.postCreate(s);
        return s;
    }

    protected Local createLocal(LocalInstance li, Position pos) {
        Local l = this.nf.Local(pos, this.nf.Id(pos, li.name()));
        l = l.localInstance(li);
        l = (Local)l.type(li.type());
        l = this.postCreate(l);
        return l;
    }

    protected void addInits(List<Stmt> stmts, For source) {
        for (Stmt stmt : source.inits()) {
            stmts.add(this.postCreate(stmt));
        }
    }

    protected BooleanLit createBool(boolean val) {
        return (BooleanLit)this.nf.BooleanLit(Position.compilerGenerated(), val).type(this.ts.Boolean());
    }

    protected Stmt translateWhile(While s) {
        Expr cond = s.cond();
        if (this.lang().condIsConstantTrue(s, this.lang())) {
            if (cond instanceof BooleanLit) {
                return s;
            }
            return s.cond(this.createBool(true));
        }
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(2);
        stmts.add(var);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        return w;
    }

    protected Stmt translateDo(Do s) {
        Expr cond = s.cond();
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s);
        If init = this.createInitIf(var, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(2);
        stmts.add(init);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        stmts = new ArrayList(2);
        stmts.add(var);
        stmts.add(w);
        return this.createBlock(stmts);
    }

    protected Stmt translateFor(For s) {
        Expr cond = s.cond();
        if (cond == null) {
            cond = this.createBool(true);
        }
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s);
        If iter = this.createIterIf(var, s.iters());
        Eval update = this.createAssign(var, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(3);
        stmts.add(iter);
        stmts.add(update);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        stmts = new ArrayList(s.inits().size() + 2);
        this.addInits(stmts, s);
        stmts.add(var);
        stmts.add(w);
        return this.createBlock(stmts);
    }
}

