/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Formal;
import polyglot.ast.Lang;
import polyglot.ast.Local;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.ContextVisitor;
import polyglot.visit.InnerClassRemover;
import polyglot.visit.NodeVisitor;

public class LocalClassRemover
extends ContextVisitor {
    Map<Pair<LocalInstance, ClassType>, FieldInstance> fieldForLocal = new HashMap<Pair<LocalInstance, ClassType>, FieldInstance>();
    Map<ParsedClassType, List<ClassDecl>> orphans = new HashMap<ParsedClassType, List<ClassDecl>>();
    Map<ParsedClassType, List<FieldInstance>> newFields = new HashMap<ParsedClassType, List<FieldInstance>>();
    boolean inConstructorCall;
    Map<FieldInstance, LocalInstance> localOfField = new HashMap<FieldInstance, LocalInstance>();

    public LocalClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList<Stmt> ss = new ArrayList<Stmt>(b.statements());
            for (int i = 0; i < ss.size(); ++i) {
                Stmt s = (Stmt)ss.get(i);
                if (s instanceof LocalClassDecl) {
                    s = n.visitChild(s, this);
                    LocalClassDecl lcd = (LocalClassDecl)s;
                    ClassDecl cd = lcd.decl();
                    Flags flags = this.context.inStaticContext() ? Flags.PUBLIC.Static() : Flags.PUBLIC;
                    cd = cd.flags(flags);
                    cd.type().flags(flags);
                    cd.type().kind(ClassType.MEMBER);
                    cd = this.rewriteLocalClass(cd, LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.emptyList()));
                    if (cd != lcd.decl()) {
                        ss.set(i, lcd.decl(cd));
                        for (int j = i; j < ss.size(); ++j) {
                            Stmt sj = (Stmt)ss.get(j);
                            sj = (Stmt)this.rewriteConstructorCalls(sj, cd.type(), LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.emptyList()));
                            ss.set(j, sj);
                        }
                        lcd = (LocalClassDecl)ss.get(i);
                        cd = lcd.decl();
                    }
                    LocalClassRemover.hashAdd(this.orphans, this.context.currentClassScope(), cd);
                    ss.remove(i);
                    --i;
                    continue;
                }
                s = n.visitChild(s, this);
                ss.set(i, s);
            }
            return b.statements(ss);
        }
        return null;
    }

    @Override
    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        LocalClassRemover v = (LocalClassRemover)super.enterCall(parent, n);
        if (n instanceof ConstructorCall && !this.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = true;
            return v;
        }
        if ((n instanceof ClassBody || n instanceof CodeNode) && v.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = false;
            return v;
        }
        return v;
    }

    protected boolean isLocal(Context c, String name) {
        return c.isLocal(name);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Position pos = n.position();
        if (n instanceof Local) {
            Local l = (Local)n;
            return this.processLocal(l, pos);
        }
        if (n instanceof New) {
            ClassType s;
            New neu = (New)n;
            ClassBody body = neu.body();
            if (body == null) {
                return neu;
            }
            TypeNode superClass = neu.objectType();
            List<TypeNode> interfaces = Collections.emptyList();
            Type supertype = neu.objectType().type();
            if (supertype instanceof ClassType && (s = (ClassType)supertype).flags().isInterface()) {
                superClass = this.defaultSuperType(pos);
                interfaces = Collections.singletonList(neu.objectType());
            }
            String name = UniqueID.newID("Anonymous");
            ClassDecl cd = this.nf.ClassDecl(pos, Flags.PUBLIC, this.nf.Id(pos, name), superClass, interfaces, body);
            ParsedClassType type = neu.anonType();
            type.kind(ClassType.MEMBER);
            type.name(cd.name());
            type.setContainer(this.context.currentClass());
            type.package_(this.context.package_());
            Flags flags = this.context.inStaticContext() ? Flags.PUBLIC.Static() : Flags.PUBLIC;
            type.flags(flags);
            cd = cd.type(type);
            cd = cd.flags(flags);
            ConstructorDecl td = this.addConstructor(cd, neu);
            cd.type().addConstructor(td.constructorInstance());
            ClassBody b = cd.body();
            ArrayList<ClassMember> members = new ArrayList<ClassMember>();
            members.addAll(b.members());
            members.add(td);
            b = b.members(members);
            cd = cd.body(b);
            neu = neu.constructorInstance(td.constructorInstance());
            neu = neu.anonType(null);
            if (!flags.isStatic()) {
                neu = neu.qualifier(this.nf.This(pos).type(this.context.currentClass()));
                neu = neu.qualifierImplicit(false);
            }
            cd = this.addOrphans(cd);
            cd = this.rewriteLocalClass(cd, LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.emptyList()));
            LocalClassRemover.hashAdd(this.orphans, this.context.currentClassScope(), cd);
            neu = neu.objectType(this.nf.CanonicalTypeNode(pos, type)).body(null);
            neu = (New)this.rewriteConstructorCalls(neu, cd.type(), LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.emptyList()));
            return neu;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            return this.addOrphans(cd);
        }
        return n;
    }

    protected Expr processLocal(Local l, Position pos) {
        FieldInstance fi;
        if (!this.inConstructorCall && !this.isLocal(this.context, l.name()) && (fi = this.boxLocal(l.localInstance())) != null) {
            Field f = this.nf.Field(pos, this.makeMissingFieldTarget(fi, pos), this.nf.Id(pos, fi.name()));
            f = f.fieldInstance(fi);
            f = (Field)f.type(fi.type());
            return f;
        }
        return l;
    }

    protected ClassDecl addOrphans(ClassDecl cd) {
        List<ClassDecl> o = this.orphans.get(cd.type());
        if (o == null) {
            return cd;
        }
        ClassBody b = cd.body();
        ArrayList<ClassMember> members = new ArrayList<ClassMember>();
        members.addAll(b.members());
        members.addAll(o);
        b = b.members(members);
        return cd.body(b);
    }

    protected TypeNode defaultSuperType(Position pos) {
        return this.nf.CanonicalTypeNode(pos, this.ts.Object());
    }

    ClassDecl rewriteLocalClass(ClassDecl cd, List<FieldInstance> newFields) {
        return InnerClassRemover.addFieldsToClass(cd, newFields, this.ts, this.nf, false);
    }

    Node rewriteConstructorCalls(Node s, ClassType ct, List<FieldInstance> fields) {
        Node r = s.visit(new ConstructorCallRewriter(this.lang(), fields, ct));
        return r;
    }

    ConstructorDecl addConstructor(ClassDecl cd, New neu) throws SemanticException {
        ArrayList<Formal> formals = new ArrayList<Formal>();
        ArrayList<Expr> args = new ArrayList<Expr>();
        ArrayList<Type> argTypes = new ArrayList<Type>();
        ClassType superType = cd.type().superType().toClass();
        for (Expr e : neu.arguments()) {
            argTypes.add(e.type());
        }
        ConstructorInstance superCi = this.typeSystem().findConstructor(superType, argTypes, cd.type(), false);
        Position argpos = Position.compilerGenerated();
        for (int i = 0; i < superCi.formalTypes().size(); ++i) {
            Type at = superCi.formalTypes().get(i);
            if (i < neu.arguments().size()) {
                argpos = neu.arguments().get(i).position();
            }
            String name = "a" + (i + 1);
            Formal f = this.nf.Formal(argpos, Flags.FINAL, (TypeNode)this.nf.CanonicalTypeNode(argpos, at), this.nf.Id(argpos, name));
            Local l = this.nf.Local(argpos, this.nf.Id(argpos, name));
            LocalInstance li = this.ts.localInstance(argpos, f.flags(), f.declType(), name);
            li.setNotConstant();
            f = f.localInstance(li);
            l = l.localInstance(li);
            l = (Local)l.type(li.type());
            formals.add(f);
            args.add(l);
        }
        Position pos = cd.position();
        ConstructorCall cc = this.nf.SuperCall(pos, args);
        cc = cc.constructorInstance(superCi);
        cc = cc.qualifier(this.adjustQualifier(neu.qualifier()));
        ArrayList<Stmt> statements = new ArrayList<Stmt>();
        statements.add(cc);
        ArrayList<TypeNode> throwTypeNodes = new ArrayList<TypeNode>();
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        for (Type type : neu.constructorInstance().throwTypes()) {
            throwTypes.add(type);
            throwTypeNodes.add(this.nf.CanonicalTypeNode(pos, type));
        }
        ConstructorDecl td = this.nf.ConstructorDecl(pos, Flags.PRIVATE, this.nf.Id(cd.position(), cd.name()), formals, throwTypeNodes, this.nf.Block(pos, statements));
        ConstructorInstance constructorInstance = this.ts.constructorInstance(pos, cd.type(), Flags.PRIVATE, argTypes, throwTypes);
        td = td.constructorInstance(constructorInstance);
        return td;
    }

    private Expr adjustQualifier(Expr e) {
        Special s;
        if (e instanceof Special && (s = (Special)e).kind() == Special.THIS && s.qualifier() == null) {
            return s.qualifier(this.nf.CanonicalTypeNode(s.position(), s.type()));
        }
        return e;
    }

    private FieldInstance boxLocal(LocalInstance li) {
        ClassType curr = this.currLocalClass();
        if (curr == null) {
            return null;
        }
        Pair<LocalInstance, ClassType> key = new Pair<LocalInstance, ClassType>(li = (LocalInstance)li.declaration(), curr);
        FieldInstance fi = this.fieldForLocal.get(key);
        if (fi != null) {
            return fi;
        }
        Position pos = li.position();
        fi = this.ts.fieldInstance(pos, curr, li.flags().Private(), li.type(), li.name());
        fi.setNotConstant();
        ParsedClassType ct = (ParsedClassType)curr.declaration();
        ct.addField(fi);
        List l = LocalClassRemover.hashGet(this.newFields, ct, new ArrayList());
        l.add(fi);
        this.localOfField.put(fi, li);
        this.fieldForLocal.put(key, fi);
        return fi;
    }

    private ClassType currLocalClass() {
        for (ClassType curr = this.context.currentClass(); curr != null; curr = curr.outer()) {
            if (curr.isLocal() || curr.isAnonymous()) {
                return curr;
            }
            if (curr.isTopLevel()) break;
        }
        return null;
    }

    protected Receiver makeMissingFieldTarget(FieldInstance fi, Position pos) {
        ClassType scope;
        Context c = this.context();
        Receiver r = fi.flags().isStatic() ? this.nf.CanonicalTypeNode(pos, fi.container()) : (!this.ts.equals(scope = (ClassType)fi.container(), c.currentClass()) ? this.nf.This(pos.startOf(), this.nf.CanonicalTypeNode(pos, scope)).type(scope) : this.nf.This(pos.startOf()).type(scope));
        return r;
    }

    public static <K, V> V hashGet(Map<K, V> map, K k, V v) {
        V x = map.get(k);
        if (x != null) {
            return x;
        }
        map.put(k, v);
        return v;
    }

    public static <K, V> void hashAdd(Map<K, List<V>> map, K k, V v) {
        List<V> l = map.get(k);
        if (l == null) {
            l = new ArrayList<V>();
            map.put(k, l);
        }
        l.add(v);
    }

    protected final class ConstructorCallRewriter
    extends NodeVisitor {
        private final List<FieldInstance> newFields;
        private final ClassType theLocalClass;
        ParsedClassType curr;

        protected ConstructorCallRewriter(Lang lang, List<FieldInstance> fields, ClassType ct) {
            super(lang);
            this.newFields = fields;
            this.theLocalClass = ct;
        }

        @Override
        public NodeVisitor enter(Node n) {
            if (n instanceof ClassDecl) {
                ConstructorCallRewriter v = (ConstructorCallRewriter)this.copy();
                v.curr = ((ClassDecl)n).type();
                return v;
            }
            return this;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            if (n instanceof New) {
                New neu = (New)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorInstance nci = (ConstructorInstance)ci.declaration();
                if (nci.container().toClass().declaration() == this.theLocalClass.declaration()) {
                    neu = neu.arguments(this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        Expr q = this.theLocalClass.outer() == LocalClassRemover.this.context.currentClass() ? LocalClassRemover.this.nf.This(neu.position()).type(this.theLocalClass.outer()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), this.theLocalClass.outer())).type(this.theLocalClass.outer());
                        neu = neu.qualifier(q);
                        neu = neu.qualifierImplicit(false);
                    }
                }
                return neu;
            }
            if (n instanceof ConstructorCall) {
                ConstructorCall neu = (ConstructorCall)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorInstance nci = (ConstructorInstance)ci.declaration();
                if (nci.container().toClass().declaration() == this.theLocalClass.declaration()) {
                    neu = (ConstructorCall)neu.arguments(this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        Expr q = this.theLocalClass.outer() == LocalClassRemover.this.context.currentClass() ? LocalClassRemover.this.nf.This(neu.position()).type(this.theLocalClass.outer()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), this.theLocalClass.outer())).type(this.theLocalClass.outer());
                        neu = neu.qualifier(q);
                    }
                }
                return neu;
            }
            return n;
        }

        List<Expr> addArgs(ProcedureCall n, ConstructorInstance nci, List<FieldInstance> fields, ClassType curr, ClassType theLocalClass) {
            if (nci == null || fields == null || fields.isEmpty() || n.arguments().size() == nci.formalTypes().size()) {
                return n.arguments();
            }
            ArrayList<Expr> args = new ArrayList<Expr>();
            for (FieldInstance fi : fields) {
                if (curr != null && theLocalClass != null && LocalClassRemover.this.ts.isEnclosed((ClassType)curr.declaration(), (ClassType)theLocalClass.declaration())) {
                    Position pos = fi.position();
                    Field f = LocalClassRemover.this.nf.Field(pos, LocalClassRemover.this.makeMissingFieldTarget(fi, pos), LocalClassRemover.this.nf.Id(pos, fi.name()));
                    f = f.fieldInstance(fi);
                    f = (Field)f.type(fi.type());
                    args.add(f);
                    continue;
                }
                LocalInstance li = LocalClassRemover.this.localOfField.get(fi);
                if (li != null) {
                    Local l = LocalClassRemover.this.nf.Local(li.position(), LocalClassRemover.this.nf.Id(li.position(), li.name()));
                    l = l.localInstance(li);
                    l = (Local)l.type(li.type());
                    args.add(LocalClassRemover.this.processLocal(l, l.position()));
                    continue;
                }
                throw new InternalCompilerError("field " + fi + " created with rev map to null", n.position());
            }
            args.addAll(n.arguments());
            assert (args.size() == nci.formalTypes().size());
            return args;
        }
    }
}

