/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.NamedVariable;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class InnerTranslator
extends NodeVisitor {
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected Stack<ClassInfo> classContext;
    protected Stack<CodeInfo> codeContext;
    protected HashMap<String, ClassInfo> innerClassInfoMap;
    protected Stack<Boolean> insideCode;
    protected Stack<Boolean> staticFieldDecl;

    protected String namePrefix() {
        return "jl$";
    }

    protected String newFieldName(String name) {
        return this.namePrefix() + name;
    }

    public InnerTranslator(TypeSystem ts, NodeFactory nf) {
        super(nf.lang());
        this.ts = ts;
        this.nf = nf;
        this.classContext = new Stack();
        this.codeContext = new Stack();
        this.innerClassInfoMap = new HashMap();
        this.insideCode = new Stack();
        this.staticFieldDecl = new Stack();
    }

    @Override
    public NodeVisitor enter(Node n) {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            this.enterClassDecl(cd);
        } else if (n instanceof New) {
            New newExpr = (New)n;
            this.enterNew(newExpr);
        } else if (n instanceof CodeDecl) {
            CodeDecl cd = (CodeDecl)n;
            this.enterCodeDecl(cd);
        } else if (n instanceof Block) {
            CodeInfo cinfo = this.codeContext.peek();
            cinfo.pushBlock();
        } else if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            this.enterLocalDecl(ld);
        } else if (n instanceof ClassBody) {
            this.insideCode.push(false);
        } else if (n instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)n;
            this.enterFieldDecl(fd);
        }
        return this;
    }

    protected void enterFieldDecl(FieldDecl fd) {
        if (fd.flags().isStatic()) {
            this.staticFieldDecl.push(true);
        } else {
            this.staticFieldDecl.push(false);
        }
    }

    protected void enterClassDecl(ClassDecl cd) {
        ParsedClassType ct = cd.type();
        ClassInfo cinfo = new ClassInfo(ct);
        if (ct.isInnerClass() && ct.isMember()) {
            ClassInfo classInfo = this.classContext.peek();
            cinfo.addConsFormal(this.produceOuterFormal(ct, classInfo.classType()));
            cinfo.hasOuterField(true);
            classInfo.addInnerClassInfo(cinfo);
            this.innerClassInfoMap.put(ct.fullName(), cinfo);
        }
        if (ct.isLocal()) {
            CodeInfo codeInfo = this.codeContext.peek();
            ClassInfo classInfo = this.classContext.peek();
            if (!codeInfo.isStatic()) {
                cinfo.addConsFormal(this.produceOuterFormal(cd.type(), classInfo.classType()));
                cinfo.hasOuterField(true);
            }
            codeInfo.addLocalClassInfo(cinfo);
            cinfo.insideCode(codeInfo);
            ct.kind(ClassType.MEMBER);
            ct.outer(classInfo.classType());
            ct.needSerialization(false);
            String className = classInfo.localClassName(cd.name(), classInfo.addLocalClassName(cd.name()));
            ct.name(className);
            for (LocalInstance li : codeInfo.finalList()) {
                Id name = this.nf.Id(Position.compilerGenerated(), li.name());
                Formal f = this.nf.Formal(Position.compilerGenerated(), Flags.NONE, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), li.type()), name);
                f = f.localInstance(this.ts.localInstance(Position.compilerGenerated(), f.flags(), f.type().type(), f.name()));
                cinfo.addConsFormal(f);
            }
            this.innerClassInfoMap.put(ct.fullName(), cinfo);
        }
        this.classContext.push(cinfo);
    }

    protected void enterNew(New newExpr) {
        if (newExpr.body() != null) {
            ParsedClassType ct = newExpr.anonType();
            ct.flags(Flags.NONE);
            ClassInfo cinfo = new ClassInfo(ct);
            boolean inCode = this.insideCode.peek();
            CodeInfo codeInfo = null;
            if (inCode) {
                codeInfo = this.codeContext.peek();
            }
            ClassInfo classInfo = this.classContext.peek();
            if (inCode && !codeInfo.isStatic() || !inCode && !this.staticFieldDecl.peek().booleanValue()) {
                cinfo.addConsFormal(this.produceOuterFormal(ct, classInfo.classType()));
                cinfo.hasOuterField(true);
            }
            if (inCode) {
                codeInfo.addLocalClassInfo(cinfo);
            } else {
                classInfo.addInnerClassInfo(cinfo);
            }
            cinfo.insideCode(codeInfo);
            ct.kind(ClassType.MEMBER);
            ct.outer(classInfo.classType());
            ct.needSerialization(false);
            String className = classInfo.localClassName("", classInfo.addLocalClassName(""));
            ct.name(className);
            if (inCode) {
                for (LocalInstance li : codeInfo.finalList()) {
                    Id name = this.nf.Id(Position.compilerGenerated(), li.name());
                    Formal f = this.nf.Formal(Position.compilerGenerated(), Flags.NONE, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), li.type()), name);
                    f = f.localInstance(this.ts.localInstance(Position.compilerGenerated(), f.flags(), f.type().type(), f.name()));
                    cinfo.addConsFormal(f);
                }
            }
            this.innerClassInfoMap.put(ct.fullName(), cinfo);
            this.classContext.push(cinfo);
        }
    }

    protected void enterCodeDecl(CodeDecl cd) {
        CodeInfo cinfo = new CodeInfo(cd.codeInstance());
        if (cd instanceof ProcedureDecl) {
            ProcedureDecl pd = (ProcedureDecl)cd;
            for (Formal f : pd.formals()) {
                if (!f.flags().isFinal()) continue;
                cinfo.addFinalArg(f.localInstance());
            }
        }
        this.codeContext.push(cinfo);
        this.insideCode.push(true);
    }

    protected void enterLocalDecl(LocalDecl ld) {
        if (ld.flags().isFinal()) {
            this.codeContext.peek().addFinalLocal(ld.localInstance());
        }
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            return this.leaveClassDecl(old, cd, v);
        }
        if (n instanceof New) {
            New newExpr = (New)n;
            return this.leaveNew(old, newExpr, v);
        }
        if (n instanceof ConstructorCall) {
            ConstructorCall cc = (ConstructorCall)n;
            return this.leaveConstructorCall(old, cc, v);
        }
        if (n instanceof Special) {
            Special s = (Special)n;
            return this.leaveSpecial(old, s, v);
        }
        if (n instanceof Field) {
            Field field = (Field)n;
            return this.leaveField(old, field, v);
        }
        if (n instanceof Call) {
            Call c = (Call)n;
            return this.leaveCall(old, c, v);
        }
        if (n instanceof LocalClassDecl) {
            return this.nf.Empty(Position.compilerGenerated());
        }
        if (n instanceof CodeDecl) {
            this.codeContext.pop();
            this.insideCode.pop();
        } else if (n instanceof Block) {
            CodeInfo cinfo = this.codeContext.peek();
            cinfo.popBlock();
        } else {
            if (n instanceof Local) {
                Local local = (Local)n;
                return this.leaveLocal(old, local, v);
            }
            if (n instanceof ClassBody) {
                this.insideCode.pop();
            } else if (n instanceof FieldDecl) {
                this.staticFieldDecl.pop();
            }
        }
        return n;
    }

    protected Node leaveClassDecl(Node old, ClassDecl cd, NodeVisitor v) {
        ParsedClassType ct = cd.type();
        ClassInfo selfInfo = this.classContext.pop();
        if (ct.flags().isStatic() || ct.isTopLevel()) {
            if (selfInfo.newMemberClasses().size() > 0 || selfInfo.newMemberMethods().size() > 0) {
                cd = this.addNewMembers(cd, selfInfo);
            }
            return cd;
        }
        if (selfInfo.insideCode() == null) {
            cd = this.updateClassDecl(cd, ct, selfInfo);
        } else {
            ClassInfo cinfo = this.classContext.peek();
            cd = cd.name(ct.name());
            cd = this.updateClassDecl(cd, ct, selfInfo);
            cinfo.addMemberClass(cd);
        }
        return cd;
    }

    protected Node leaveNew(Node old, New newExpr, NodeVisitor v) {
        if (newExpr.body() != null) {
            ParsedClassType ct = newExpr.anonType();
            Id name = this.nf.Id(Position.compilerGenerated(), ct.name());
            ClassDecl cd = this.nf.ClassDecl(Position.compilerGenerated(), ct.flags(), name, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), ct.superType()), Collections.emptyList(), newExpr.body());
            cd = cd.type(ct);
            ClassInfo selfInfo = this.classContext.pop();
            ClassInfo cinfo = this.classContext.peek();
            cd = cd.name(ct.name());
            cd = this.addAnonymousConstructor(cd, ct, selfInfo, newExpr);
            cd = this.updateClassDecl(cd, ct, selfInfo);
            cinfo.addMemberClass(cd);
            newExpr = (New)newExpr.type(ct);
        }
        return this.updateNewExpr(newExpr);
    }

    protected Node leaveConstructorCall(Node old, ConstructorCall cc, NodeVisitor v) {
        ClassInfo cinfo = this.classContext.peek();
        return this.updateConstructorCall(cc, cinfo);
    }

    protected Node leaveSpecial(Node old, Special s, NodeVisitor v) {
        if (s.kind() == Special.THIS && s.qualifier() != null) {
            ClassType tOuter = (ClassType)s.qualifier().type();
            ClassType tThis = this.classContext.peek().classType();
            Expr t = s.qualifier(null);
            while (!this.ts.equals(tOuter, tThis)) {
                t = this.produceOuterField(tThis, t);
                tThis = tThis.outer();
            }
            return t;
        }
        return s;
    }

    protected Node leaveField(Node old, Field field, NodeVisitor v) {
        if (!field.flags().isStatic() && field.isTargetImplicit()) {
            ClassType tThis = this.classContext.peek().classType();
            ParsedClassType tOuter = this.findField(field.name(), tThis);
            Expr t = this.produceThis(tThis);
            while (!this.ts.equals(tOuter, tThis)) {
                t = this.produceOuterField(tThis, t);
                tThis = tThis.outer();
            }
            Id name = this.nf.Id(Position.compilerGenerated(), field.name());
            Field f = this.nf.Field(field.position(), (Receiver)t, name);
            f = f.fieldInstance(field.fieldInstance());
            return f;
        }
        return field;
    }

    protected Node leaveCall(Node old, Call c, NodeVisitor v) {
        MethodInstance mi = c.methodInstance();
        if (!mi.flags().isStatic() && c.isTargetImplicit()) {
            ClassType tThis = this.classContext.peek().classType();
            ParsedClassType tOuter = this.findMethod(mi, tThis);
            Expr t = this.produceThis(tThis);
            while (!this.ts.equals(tOuter, tThis)) {
                t = this.produceOuterField(tThis, t);
                tThis = tThis.outer();
            }
            Call nc = c.target(t).targetImplicit(false);
            return nc;
        }
        return c;
    }

    protected Node leaveLocal(Node old, Local local, NodeVisitor v) {
        CodeInfo codeInfo;
        if (local.flags().isFinal() && !(codeInfo = this.codeContext.peek()).existFinal(local.name())) {
            String newName = this.newFieldName(local.name());
            ClassType tThis = this.classContext.peek().classType();
            ParsedClassType tOuter = this.findField(newName, tThis);
            Expr t = this.produceThis(tThis);
            while (!this.ts.equals(tOuter, tThis)) {
                t = this.produceOuterField(tThis, t);
                tThis = tThis.outer();
            }
            Id id = this.nf.Id(Position.compilerGenerated(), newName);
            Field f = this.nf.Field(Position.compilerGenerated(), (Receiver)t, id);
            f = f.fieldInstance(this.ts.fieldInstance(Position.compilerGenerated(), (ReferenceType)t.type(), Flags.PROTECTED, local.type(), f.name()));
            return f;
        }
        return local;
    }

    protected Special produceThis(ClassType ct) {
        Special s = this.nf.Special(Position.compilerGenerated(), Special.THIS);
        s = (Special)s.type(ct);
        return s;
    }

    protected ClassDecl addAnonymousConstructor(ClassDecl cd, ParsedClassType ct, ClassInfo cinfo, New newExpr) {
        ArrayList<Formal> formals = new ArrayList<Formal>(newExpr.arguments().size() + 1);
        ArrayList<Expr> args = new ArrayList<Expr>(newExpr.arguments().size() + 1);
        ArrayList<Type> ftypes = new ArrayList<Type>(newExpr.arguments().size() + 1);
        int i = 0;
        for (Expr arg : newExpr.arguments()) {
            Id id = this.nf.Id(Position.compilerGenerated(), "arg" + i);
            Formal f = this.nf.Formal(Position.compilerGenerated(), Flags.NONE, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), arg.type()), id);
            LocalInstance li = this.ts.localInstance(Position.compilerGenerated(), Flags.NONE, arg.type(), "arg" + i);
            f = f.localInstance(li);
            formals.add(f);
            Local l = this.nf.Local(Position.compilerGenerated(), id);
            l = l.localInstance(li);
            args.add(l);
            ftypes.add(arg.type());
        }
        ConstructorCall cc = this.nf.SuperCall(Position.compilerGenerated(), args);
        cc = cc.constructorInstance(newExpr.constructorInstance());
        cc = this.updateConstructorCall(cc, cinfo);
        Id cid = this.nf.Id(Position.compilerGenerated(), ct.name());
        ConstructorDecl cons = this.nf.ConstructorDecl(Position.compilerGenerated(), Flags.NONE, cid, formals, Collections.emptyList(), this.nf.Block(Position.compilerGenerated(), cc));
        ConstructorInstance consInst = this.ts.constructorInstance(Position.compilerGenerated(), ct, Flags.NONE, ftypes, Collections.emptyList());
        cons = cons.constructorInstance(consInst);
        List<ClassMember> members = cd.body().members();
        ArrayList<ClassMember> newMembers = new ArrayList<ClassMember>(members.size() + 1);
        newMembers.add(cons);
        newMembers.addAll(members);
        cd = cd.body(this.nf.ClassBody(cd.body().position(), newMembers));
        return cd;
    }

    protected ParsedClassType findField(String name, ClassType current) {
        for (int i = this.classContext.size() - 1; i >= 0; --i) {
            ClassInfo cinfo = (ClassInfo)this.classContext.get(i);
            ParsedClassType ct = cinfo.classType();
            try {
                this.ts.findField(ct, name, current, true);
            }
            catch (SemanticException se) {
                continue;
            }
            return ct;
        }
        throw new InternalCompilerError("Unable to find field " + name + ".");
    }

    protected ParsedClassType findMethod(MethodInstance mi, ClassType current) {
        for (int i = this.classContext.size() - 1; i >= 0; --i) {
            ClassInfo cinfo = (ClassInfo)this.classContext.get(i);
            ParsedClassType ct = cinfo.classType();
            try {
                this.ts.findMethod(ct, mi.name(), mi.formalTypes(), current, true);
            }
            catch (SemanticException se) {
                continue;
            }
            return ct;
        }
        throw new InternalCompilerError("Unable to find " + mi + ".");
    }

    protected ConstructorCall updateConstructorCall(ConstructorCall cc, ClassInfo selfInfo) {
        ConstructorInstance ci = cc.constructorInstance();
        ClassType ct = (ClassType)ci.container();
        if (cc.kind().equals(ConstructorCall.THIS)) {
            ClassInfo cinfo = this.classContext.peek();
            ci = this.updateConstructorInst(ct, ci, cinfo);
            List<Formal> formals = cinfo.newConsFormals();
            ArrayList<Expr> args = new ArrayList<Expr>(cc.arguments().size() + formals.size());
            args.addAll(cc.arguments());
            for (Formal f : formals) {
                Id id = this.nf.Id(Position.compilerGenerated(), f.name());
                Local l = this.nf.Local(Position.compilerGenerated(), id);
                l = l.localInstance(f.localInstance());
                l = (Local)l.type(f.type().type());
                args.add(l);
            }
            cc = (ConstructorCall)cc.arguments(args);
            cc = cc.constructorInstance(ci);
        } else {
            ClassInfo cinfo = this.innerClassInfoMap.get(ct.fullName());
            if (cinfo != null) {
                if (cinfo.insideCode() == null) {
                    ci = this.updateConstructorInst(ct, ci, cinfo);
                    ArrayList<Expr> args = new ArrayList<Expr>(cc.arguments().size() + 1);
                    Formal f = selfInfo.newConsFormals().get(0);
                    Id id = this.nf.Id(Position.compilerGenerated(), this.outerThisName(ct));
                    Local l = this.nf.Local(Position.compilerGenerated(), id);
                    l = l.localInstance(f.localInstance());
                    l = (Local)l.type(f.type().type());
                    args.addAll(cc.arguments());
                    args.add(l);
                    cc = (ConstructorCall)cc.arguments(args);
                    cc = cc.constructorInstance(ci);
                } else if (selfInfo.insideCode() == cinfo.insideCode()) {
                    ci = this.updateConstructorInst(ct, ci, cinfo);
                    List<Formal> formals = cinfo.newConsFormals();
                    ArrayList<Expr> args = new ArrayList<Expr>(cc.arguments().size() + formals.size());
                    args.addAll(cc.arguments());
                    for (Formal f : formals) {
                        Id id = this.nf.Id(Position.compilerGenerated(), f.name());
                        args.add(this.nf.Local(Position.compilerGenerated(), id));
                    }
                    cc = (ConstructorCall)cc.arguments(args);
                    cc = cc.constructorInstance(ci);
                } else {
                    Id id = this.nf.Id(Position.compilerGenerated(), this.outerThisName(ct));
                    Local outerLocal = this.nf.Local(Position.compilerGenerated(), id);
                    NamedVariable outer = outerLocal = outerLocal.localInstance(selfInfo.newConsFormals().get(0).localInstance());
                    ClassType outerCt = selfInfo.classType().outer();
                    ClassType tThis = ct;
                    ClassInfo outerCInfo = this.innerClassInfoMap.get(outerCt.fullName());
                    while (outerCInfo.insideCode() != cinfo.insideCode()) {
                        outer = this.produceOuterField(tThis, outer);
                        tThis = outerCt;
                        outerCt = outerCt.outer();
                        outerCInfo = this.innerClassInfoMap.get(outerCt.fullName());
                    }
                    ci = this.updateConstructorInst(ct, ci, cinfo);
                    List<Formal> formals = cinfo.newConsFormals();
                    ArrayList<Expr> args = new ArrayList<Expr>(cc.arguments().size() + formals.size());
                    args.addAll(cc.arguments());
                    for (Formal f : formals) {
                        Id fid = this.nf.Id(Position.compilerGenerated(), this.newFieldName(f.name()));
                        args.add(this.nf.Field(Position.compilerGenerated(), (Receiver)outer, fid));
                    }
                    cc = (ConstructorCall)cc.arguments(args);
                    cc = cc.constructorInstance(ci);
                }
            }
        }
        return cc;
    }

    protected ClassDecl addNewMembers(ClassDecl cd, ClassInfo cinfo) {
        ArrayList<ClassMember> members = new ArrayList<ClassMember>(cd.body().members().size() + cinfo.newMemberClasses().size() + cinfo.newMemberMethods().size());
        members.addAll(cd.body().members());
        members.addAll(cinfo.newMemberClasses());
        members.addAll(cinfo.newMemberMethods());
        ClassBody b = this.nf.ClassBody(cd.body().position(), members);
        b = (ClassBody)b.exceptions(cd.body().exceptions());
        cd = cd.body(b);
        return cd;
    }

    protected ClassInfo findClassInfo(ClassType ct) {
        ClassInfo cinfo = this.innerClassInfoMap.get(ct.fullName());
        return cinfo;
    }

    protected boolean isSourceType(ClassType ct) {
        return true;
    }

    protected Expr updateNewExpr(New newExpr) {
        ClassType ct = (ClassType)newExpr.type();
        ClassInfo classInfo = this.classContext.peek();
        ClassInfo cinfo = this.findClassInfo(ct);
        if (cinfo != null) {
            ConstructorInstance ci = newExpr.constructorInstance();
            List<Formal> formals = cinfo.newConsFormals();
            ArrayList<Expr> args = new ArrayList<Expr>(newExpr.arguments().size() + formals.size());
            ArrayList<? extends Type> ftypes = new ArrayList<Type>(newExpr.arguments().size() + formals.size());
            args.addAll(newExpr.arguments());
            ftypes.addAll(ci.formalTypes());
            Iterator<Formal> it = formals.iterator();
            if (cinfo.hasOuterField()) {
                if (newExpr.qualifier() != null) {
                    args.add(newExpr.qualifier());
                    ftypes.add(newExpr.qualifier().type());
                } else {
                    args.add(this.nf.This(Position.compilerGenerated()));
                    ftypes.add(classInfo.classType());
                }
                it.next();
            }
            while (it.hasNext()) {
                Formal f = it.next();
                Id id = this.nf.Id(Position.compilerGenerated(), f.name());
                args.add(this.nf.Local(Position.compilerGenerated(), id));
                ftypes.add(f.type().type());
            }
            New nExpr = newExpr.arguments(args);
            ci.setFormalTypes(ftypes);
            if (newExpr.anonType() != null) {
                ci.setContainer(newExpr.anonType());
                nExpr = nExpr.objectType(this.nf.CanonicalTypeNode(Position.compilerGenerated(), newExpr.anonType()));
            }
            nExpr = nExpr.qualifier(null);
            nExpr = nExpr.anonType(null);
            nExpr = nExpr.body(null);
            nExpr = nExpr.constructorInstance(ci);
            return nExpr;
        }
        if (ct.isInnerClass() && this.isSourceType(ct)) {
            ConstructorInstance ci = newExpr.constructorInstance();
            ArrayList<Expr> args = new ArrayList<Expr>(newExpr.arguments().size() + 1);
            ArrayList<? extends Type> ftypes = new ArrayList<Type>(newExpr.arguments().size() + 1);
            args.addAll(newExpr.arguments());
            ftypes.addAll(ci.formalTypes());
            if (newExpr.qualifier() != null) {
                args.add(newExpr.qualifier());
                ftypes.add(newExpr.qualifier().type());
            } else {
                args.add(this.nf.This(Position.compilerGenerated()));
                ftypes.add(this.classContext.peek().classType());
            }
            ci.setFormalTypes(ftypes);
            New nExpr = newExpr.arguments(args);
            nExpr = nExpr.qualifier(null);
            nExpr = nExpr.constructorInstance(ci);
            return nExpr;
        }
        return newExpr;
    }

    protected ConstructorDecl produceDefaultConstructor(ParsedClassType ct, ClassInfo cinfo) {
        ConstructorCall cc = this.nf.ConstructorCall(Position.compilerGenerated(), ConstructorCall.SUPER, Collections.emptyList());
        ConstructorInstance cci = this.ts.constructorInstance(Position.compilerGenerated(), (ClassType)ct.superType(), Flags.PUBLIC, Collections.emptyList(), Collections.emptyList());
        cc = cc.constructorInstance(cci);
        cc = this.updateConstructorCall(cc, cinfo);
        Id id = this.nf.Id(Position.compilerGenerated(), ct.name());
        ConstructorDecl cd = this.nf.ConstructorDecl(Position.compilerGenerated(), Flags.PUBLIC, id, Collections.emptyList(), Collections.emptyList(), this.nf.Block(Position.compilerGenerated(), cc));
        ConstructorInstance cdi = this.ts.constructorInstance(Position.compilerGenerated(), ct, Flags.PUBLIC, Collections.emptyList(), Collections.emptyList());
        cd = cd.constructorInstance(cdi);
        return cd;
    }

    protected ClassDecl updateClassDecl(ClassDecl cd, ParsedClassType ct, ClassInfo cinfo) {
        Flags f = ct.flags().Static();
        ct.flags(f);
        LinkedList<ClassMember> members = new LinkedList<ClassMember>();
        List<FieldDecl> fields = this.produceFieldDecls(ct, cinfo);
        members.addAll(fields);
        ct.setConstructors(Collections.emptyList());
        for (ClassMember m : cd.body().members()) {
            if (m instanceof ConstructorDecl) {
                ConstructorDecl cons = (ConstructorDecl)m;
                ConstructorDecl newCons = this.updateConstructor(cd, ct, cons, cinfo);
                members.add(newCons);
                ct.addConstructor(newCons.constructorInstance());
                continue;
            }
            members.add(m);
        }
        if (ct.constructors().size() == 0) {
            ConstructorDecl cons = this.updateConstructor(cd, ct, this.produceDefaultConstructor(ct, cinfo), cinfo);
            members.add(cons);
            ct.addConstructor(cons.constructorInstance());
        }
        List<ClassDecl> newMemClasses = cinfo.newMemberClasses();
        members.addAll(newMemClasses);
        List<MethodDecl> newMethods = cinfo.newMemberMethods();
        members.addAll(newMethods);
        ClassBody cb = cd.body();
        cb = cb.members(members);
        cd = cd.body(cb);
        cd = cd.type(ct);
        cd = cd.flags(f);
        return cd;
    }

    protected List<FieldDecl> produceFieldDecls(ClassType ct, ClassInfo cinfo) {
        List<Formal> newFormals = cinfo.newConsFormals();
        ArrayList<FieldDecl> fields = new ArrayList<FieldDecl>(newFormals.size());
        for (Formal formal : newFormals) {
            Id id = this.nf.Id(Position.compilerGenerated(), this.newFieldName(formal.name()));
            FieldDecl fd = this.nf.FieldDecl(Position.compilerGenerated(), Flags.PROTECTED, formal.type(), id);
            FieldInstance fi = this.ts.fieldInstance(Position.compilerGenerated(), ct, Flags.PROTECTED, formal.type().type(), this.newFieldName(formal.name()));
            fd = fd.fieldInstance(fi);
            fields.add(fd);
        }
        return fields;
    }

    protected String outerThisName(ClassType ct) {
        return "outer$this";
    }

    protected Formal produceOuterFormal(ParsedClassType ct, ParsedClassType oct) {
        Id fn = this.nf.Id(Position.compilerGenerated(), this.outerThisName(ct));
        Formal formal = this.nf.Formal(Position.compilerGenerated(), Flags.NONE, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), oct), fn);
        formal = formal.localInstance(this.ts.localInstance(Position.compilerGenerated(), formal.flags(), formal.type().type(), formal.name()));
        return formal;
    }

    protected Field produceOuterField(ClassType ct, Expr rec) {
        Id id = this.nf.Id(Position.compilerGenerated(), this.newFieldName(this.outerThisName(ct)));
        Field f = this.nf.Field(Position.compilerGenerated(), (Receiver)rec, id);
        f = f.fieldInstance(this.ts.fieldInstance(Position.compilerGenerated(), ct, Flags.PROTECTED, ct.container(), f.name()));
        return f;
    }

    protected ConstructorInstance updateConstructorInst(ClassType ct, ConstructorInstance ci, ClassInfo cinfo) {
        List<Formal> newFormals = cinfo.newConsFormals();
        ArrayList<? extends Type> ftypes = new ArrayList<Type>(ci.formalTypes().size() + newFormals.size());
        ftypes.addAll(ci.formalTypes());
        for (Formal f : newFormals) {
            ftypes.add(f.type().type());
        }
        ci.setFormalTypes(ftypes);
        ci.setContainer(ct);
        return ci;
    }

    protected ConstructorCall produceDefaultSuperConstructorCall(ClassType ct) {
        ConstructorCall superCc = this.nf.ConstructorCall(Position.compilerGenerated(), ConstructorCall.SUPER, Collections.emptyList());
        ConstructorInstance superCi = this.ts.constructorInstance(Position.compilerGenerated(), (ClassType)ct.superType(), Flags.PUBLIC, Collections.emptyList(), Collections.emptyList());
        superCc = superCc.constructorInstance(superCi);
        superCc = this.updateConstructorCall(superCc, this.classContext.peek());
        return superCc;
    }

    protected ConstructorDecl updateConstructor(ClassDecl cd, ClassType ct, ConstructorDecl cons, ClassInfo cinfo) {
        List<Formal> newFormals = cinfo.newConsFormals();
        ArrayList<Formal> formals = new ArrayList<Formal>(cons.formals().size() + newFormals.size());
        formals.addAll(cons.formals());
        formals.addAll(newFormals);
        List<Stmt> oldStmts = cons.body().statements();
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(oldStmts.size() + newFormals.size());
        Iterator<Stmt> it = oldStmts.iterator();
        if (it.hasNext()) {
            Stmt s = it.next();
            if (s instanceof ConstructorCall) {
                stmts.add(s);
                if (((ConstructorCall)s).kind() != ConstructorCall.THIS) {
                    stmts.addAll(this.produceFieldInits(cinfo));
                }
            } else {
                stmts.add(this.produceDefaultSuperConstructorCall(ct));
                stmts.addAll(this.produceFieldInits(cinfo));
                stmts.add(s);
            }
        } else {
            stmts.add(this.produceDefaultSuperConstructorCall(ct));
            stmts.addAll(this.produceFieldInits(cinfo));
        }
        while (it.hasNext()) {
            stmts.add(it.next());
        }
        Block b = this.nf.Block(Position.compilerGenerated(), stmts);
        Id id = this.nf.Id(Position.compilerGenerated(), ct.name());
        ConstructorDecl newCons = this.nf.ConstructorDecl(Position.compilerGenerated(), cons.flags(), id, formals, cons.throwTypes(), b);
        newCons = newCons.constructorInstance(this.updateConstructorInst(ct, cons.constructorInstance(), cinfo));
        return newCons;
    }

    protected List<Stmt> produceFieldInits(ClassInfo cinfo) {
        List<Formal> newFormals = cinfo.newConsFormals();
        ArrayList<Stmt> fInits = new ArrayList<Stmt>(newFormals.size());
        for (Formal formal : newFormals) {
            Id formalId = this.nf.Id(Position.compilerGenerated(), formal.name());
            Local local = this.nf.Local(Position.compilerGenerated(), formalId);
            local = local.localInstance(formal.localInstance());
            Special thisExpr = this.nf.This(Position.compilerGenerated());
            thisExpr = (Special)thisExpr.type(cinfo.classType());
            Id fieldId = this.nf.Id(Position.compilerGenerated(), this.newFieldName(formal.name()));
            Field field = this.nf.Field(Position.compilerGenerated(), (Receiver)thisExpr, fieldId);
            field = field.fieldInstance(this.ts.fieldInstance(Position.compilerGenerated(), cinfo.classType(), Flags.PROTECTED, formal.type().type(), field.name()));
            FieldAssign fAssign = this.nf.FieldAssign(Position.compilerGenerated(), field, Assign.ASSIGN, local);
            Eval stmt = this.nf.Eval(Position.compilerGenerated(), fAssign);
            fInits.add(stmt);
        }
        return fInits;
    }

    protected class CodeInfo {
        CodeInstance ci;
        List<LocalInstance> finalArgs;
        List<ClassInfo> localClassInfo;
        Stack<LinkedList<LocalInstance>> blockFinals;

        public CodeInfo(CodeInstance ci) {
            this.ci = ci;
            this.finalArgs = new LinkedList<LocalInstance>();
            this.localClassInfo = new LinkedList<ClassInfo>();
            this.blockFinals = new Stack();
        }

        public String toString() {
            return this.ci.toString();
        }

        public void addFinalArg(LocalInstance li) {
            this.finalArgs.add(li);
        }

        public void pushBlock() {
            this.blockFinals.push(new LinkedList());
        }

        public void popBlock() {
            this.blockFinals.pop();
        }

        public void addFinalLocal(LocalInstance li) {
            List current = this.blockFinals.peek();
            current.add(li);
        }

        public List<LocalInstance> finalList() {
            LinkedList<LocalInstance> result = new LinkedList<LocalInstance>();
            result.addAll(this.finalArgs);
            for (List list : this.blockFinals) {
                result.addAll(list);
            }
            return result;
        }

        public ClassInfo findLocalClassInfo(ClassType ct) {
            for (ClassInfo cinfo : this.localClassInfo) {
                if (!cinfo.classType().equals(ct)) continue;
                return cinfo;
            }
            return null;
        }

        public void addLocalClassInfo(ClassInfo cinfo) {
            this.localClassInfo.add(cinfo);
        }

        public boolean isStatic() {
            return this.ci.flags().isStatic();
        }

        public boolean existFinal(String name) {
            for (int i = this.blockFinals.size() - 1; i >= 0; --i) {
                List l = (List)this.blockFinals.get(i);
                for (LocalInstance li : l) {
                    if (!li.name().equals(name)) continue;
                    return true;
                }
            }
            for (LocalInstance li : this.finalArgs) {
                if (!li.name().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    protected class ClassInfo {
        ParsedClassType ct;
        Map<String, Integer> localNameCount;
        List<ClassDecl> newMemberClasses;
        List<MethodDecl> newMemberMethods;
        List<Formal> newConsFormals;
        List<ClassInfo> innerClassInfo;
        boolean hasOuterField;
        CodeInfo insideCode;

        public ClassInfo(ParsedClassType ct) {
            this.ct = ct;
            this.localNameCount = new HashMap<String, Integer>();
            this.newMemberClasses = new LinkedList<ClassDecl>();
            this.newMemberMethods = new LinkedList<MethodDecl>();
            this.newConsFormals = new LinkedList<Formal>();
            this.innerClassInfo = new LinkedList<ClassInfo>();
            this.hasOuterField = false;
            this.insideCode = null;
        }

        public String toString() {
            return this.ct.toString();
        }

        public int addLocalClassName(String name) {
            if (this.localNameCount.containsKey(name)) {
                int i = this.localNameCount.get(name);
                this.localNameCount.put(name, i + 1);
                return i;
            }
            this.localNameCount.put(name, 1);
            return 0;
        }

        public String localClassName(String name, int nameCount) {
            String thisName = this.ct.fullName();
            return InnerTranslator.this.namePrefix() + thisName + "$" + nameCount + name;
        }

        public ParsedClassType classType() {
            return this.ct;
        }

        public void addConsFormal(Formal f) {
            this.newConsFormals.add(f);
            FieldInstance fi = InnerTranslator.this.ts.fieldInstance(Position.compilerGenerated(), this.ct, Flags.PROTECTED, f.type().type(), InnerTranslator.this.newFieldName(f.name()));
            this.ct.addField(fi);
        }

        public List<Formal> newConsFormals() {
            return this.newConsFormals;
        }

        public List<ClassDecl> newMemberClasses() {
            return this.newMemberClasses;
        }

        public void addMemberClass(ClassDecl cd) {
            this.newMemberClasses.add(cd);
            this.ct.addMemberClass(cd.type());
        }

        public List<MethodDecl> newMemberMethods() {
            return this.newMemberMethods;
        }

        public void addMemberMethods(MethodDecl md) {
            this.newMemberMethods.add(md);
            this.ct.addMethod(md.methodInstance());
        }

        public void addInnerClassInfo(ClassInfo cinfo) {
            this.innerClassInfo.add(cinfo);
        }

        public ClassInfo findInnerClassInfo(ClassType ct) {
            for (ClassInfo cinfo : this.innerClassInfo) {
                if (!cinfo.classType().equals(ct)) continue;
                return cinfo;
            }
            return null;
        }

        public void hasOuterField(boolean b) {
            this.hasOuterField = b;
        }

        public boolean hasOuterField() {
            return this.hasOuterField;
        }

        public CodeInfo insideCode() {
            return this.insideCode;
        }

        public void insideCode(CodeInfo ci) {
            this.insideCode = ci;
        }
    }
}

