/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.IdentityKey;
import polyglot.visit.DataFlow;

public class FlowGraph<FlowItem extends DataFlow.Item> {
    protected Map<IdentityKey, Map<PeerKey, Peer<FlowItem>>> peerMap;
    protected Term root;
    protected boolean forward;
    protected final boolean alwaysHaveSuccEdgeKey;
    public static final EdgeKey EDGE_KEY_TRUE = new EdgeKey("true");
    public static final EdgeKey EDGE_KEY_FALSE = new EdgeKey("false");
    public static final EdgeKey EDGE_KEY_OTHER = new EdgeKey("other");

    public FlowGraph(Term root, boolean forward) {
        this(root, forward, true);
    }

    public FlowGraph(Term root, boolean forward, boolean alwaysHaveSuccEdgeKey) {
        this.root = root;
        this.forward = forward;
        this.peerMap = new HashMap<IdentityKey, Map<PeerKey, Peer<FlowItem>>>();
        this.alwaysHaveSuccEdgeKey = alwaysHaveSuccEdgeKey;
    }

    public Term root() {
        return this.root;
    }

    public boolean forward() {
        return this.forward;
    }

    public Collection<Peer<FlowItem>> entryPeers() {
        return this.peers(this.root, 1);
    }

    public Collection<Peer<FlowItem>> exitPeers() {
        return this.peers(this.root, 0);
    }

    public Collection<Peer<FlowItem>> startPeers() {
        return this.forward ? this.entryPeers() : this.exitPeers();
    }

    public Collection<Peer<FlowItem>> finishPeers() {
        return this.forward ? this.exitPeers() : this.entryPeers();
    }

    public Collection<Map<PeerKey, Peer<FlowItem>>> pathMaps() {
        return this.peerMap.values();
    }

    public Map<PeerKey, Peer<FlowItem>> pathMap(Node n) {
        return this.peerMap.get(new IdentityKey(n));
    }

    public Collection<Peer<FlowItem>> peers() {
        ArrayList<Peer<FlowItem>> c = new ArrayList<Peer<FlowItem>>();
        for (Map<PeerKey, Peer<FlowItem>> m : this.peerMap.values()) {
            for (Peer<FlowItem> p : m.values()) {
                c.add(p);
            }
        }
        return c;
    }

    public Peer<FlowItem> peer(Term n, int entry) {
        return this.peer(n, Collections.emptyList(), entry);
    }

    public Peer<FlowItem> peer(Term n, boolean isEntry) {
        return this.peer(n, Collections.emptyList(), isEntry ? 1 : 0);
    }

    public Collection<Peer<FlowItem>> peers(Term n, int entry) {
        IdentityKey k = new IdentityKey(n);
        Map<PeerKey, Peer<FlowItem>> pathMap = this.peerMap.get(k);
        if (pathMap == null) {
            return Collections.emptyList();
        }
        Collection<Peer<FlowItem>> peers = pathMap.values();
        ArrayList<Peer<FlowItem>> l = new ArrayList<Peer<FlowItem>>(peers.size());
        for (Peer<FlowItem> p : peers) {
            if (p.entry != entry) continue;
            l.add(p);
        }
        return l;
    }

    public Peer<FlowItem> peer(Term n, List<Term> path_to_finally, int entry) {
        PeerKey lk = new PeerKey(path_to_finally, entry);
        return this.peer(n, lk);
    }

    public Peer<FlowItem> peer(Term n, PeerKey peerKey) {
        Peer<FlowItem> p;
        IdentityKey k = new IdentityKey(n);
        Map<PeerKey, Peer<FlowItem>> pathMap = this.peerMap.get(k);
        if (pathMap == null) {
            pathMap = new HashMap<PeerKey, Peer<FlowItem>>();
            this.peerMap.put(k, pathMap);
        }
        if ((p = pathMap.get(peerKey)) == null) {
            p = new Peer(n, peerKey.list, peerKey.entry, this.alwaysHaveSuccEdgeKey);
            pathMap.put(peerKey, p);
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<Peer<Object>> todo = new HashSet<Peer<FlowItem>>(this.peers());
        LinkedList<Peer<FlowItem>> queue = new LinkedList<Peer<FlowItem>>(this.startPeers());
        while (!queue.isEmpty()) {
            Peer<FlowItem> p = queue.removeFirst();
            todo.remove(p);
            sb.append(p.node + " (" + p.node.position() + ")\n");
            for (Edge e : p.succs) {
                Peer q = e.getTarget();
                sb.append("    -> " + q.node + " (" + q.node.position() + ")\n");
                if (!todo.contains(q) || queue.contains(q)) continue;
                queue.addLast(q);
            }
            if (!queue.isEmpty() || todo.isEmpty()) continue;
            sb.append("\n\n***UNREACHABLE***\n");
            queue.addAll(todo);
            todo = Collections.emptySet();
        }
        return sb.toString();
    }

    public static class PeerKey {
        protected final List<Term> list;
        protected final int entry;

        public PeerKey(List<Term> list, int entry) {
            this.list = list;
            this.entry = entry;
        }

        public int hashCode() {
            return this.list.hashCode() ^ this.entry;
        }

        public boolean equals(Object other) {
            if (other instanceof PeerKey) {
                PeerKey k = (PeerKey)other;
                return CollectionUtil.equals(this.list, k.list) && this.entry == k.entry;
            }
            return false;
        }
    }

    public static class Peer<FlowItem extends DataFlow.Item> {
        protected FlowItem inItem;
        protected Map<EdgeKey, FlowItem> outItems;
        protected Term node;
        protected List<Edge<FlowItem>> succs;
        protected List<Edge<FlowItem>> preds;
        protected final boolean alwaysHaveSuccEdgeKey;
        protected List<Term> path_to_finally;
        protected int entry;
        private Set<EdgeKey> succEdgeKeys;

        public Peer(Term node, List<Term> path_to_finally, int entry, boolean alwaysHaveSuccEdgeKey) {
            this.node = node;
            this.path_to_finally = path_to_finally;
            this.inItem = null;
            this.outItems = null;
            this.succs = new ArrayList<Edge<FlowItem>>();
            this.preds = new ArrayList<Edge<FlowItem>>();
            this.entry = entry;
            this.succEdgeKeys = null;
            this.alwaysHaveSuccEdgeKey = alwaysHaveSuccEdgeKey;
        }

        public List<Edge<FlowItem>> succs() {
            return this.succs;
        }

        public List<Edge<FlowItem>> preds() {
            return this.preds;
        }

        public Term node() {
            return this.node;
        }

        public PeerKey peerKey() {
            return new PeerKey(this.path_to_finally, this.entry);
        }

        public FlowItem inItem() {
            return this.inItem;
        }

        public FlowItem outItem(EdgeKey key) {
            if (this.outItems == null) {
                return null;
            }
            return (FlowItem)((DataFlow.Item)this.outItems.get(key));
        }

        public String toString() {
            return (this.entry == 1 ? "entry: " : "") + this.node + this.path_to_finally;
        }

        public boolean isEntry() {
            return this.entry == 1;
        }

        public Set<EdgeKey> succEdgeKeys() {
            if (this.succEdgeKeys == null) {
                this.succEdgeKeys = new HashSet<EdgeKey>();
                for (Edge<FlowItem> e : this.succs) {
                    this.succEdgeKeys.add(e.getKey());
                }
                if (this.alwaysHaveSuccEdgeKey && this.succEdgeKeys.isEmpty()) {
                    this.succEdgeKeys.add(EDGE_KEY_OTHER);
                }
            }
            return this.succEdgeKeys;
        }
    }

    public static class Edge<FlowItem extends DataFlow.Item> {
        protected EdgeKey key;
        protected Peer<FlowItem> target;

        public Edge(EdgeKey key, Peer<FlowItem> target) {
            this.key = key;
            this.target = target;
        }

        public EdgeKey getKey() {
            return this.key;
        }

        public Peer<FlowItem> getTarget() {
            return this.target;
        }

        public String toString() {
            return "(" + this.key + ")" + this.target;
        }
    }

    public static class ExceptionEdgeKey
    extends EdgeKey {
        public ExceptionEdgeKey(Type t) {
            super(t);
        }

        public Type type() {
            return (Type)this.o;
        }

        @Override
        public String toString() {
            return this.type().isClass() ? this.type().toClass().name() : this.type().toString();
        }
    }

    public static class EdgeKey {
        protected Object o;

        protected EdgeKey(Object o) {
            this.o = o;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof EdgeKey && ((EdgeKey)other).o.equals(this.o);
        }

        public String toString() {
            return this.o.toString();
        }
    }
}

