/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.ForInit;
import polyglot.ast.If;
import polyglot.ast.IntLit;
import polyglot.ast.Labeled;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.ArrayType;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.NullType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.DeepCopy;
import polyglot.visit.NodeVisitor;

public class ExpressionFlattener
extends NodeVisitor {
    protected final Job job;
    protected final TypeSystem ts;
    protected final NodeFactory nf;
    protected final Stack<List<Stmt>> blockStack = new Stack();
    protected final Set<Expr> dontFlatten = new HashSet<Expr>();
    protected final DeepCopy deepCopier;
    protected boolean flatten_all_decls;

    public ExpressionFlattener(Job job, TypeSystem ts, NodeFactory nf) {
        this(job, ts, nf, false);
    }

    public ExpressionFlattener(Job job, TypeSystem ts, NodeFactory nf, boolean flatten_all_decls) {
        super(nf.lang());
        this.job = job;
        this.ts = ts;
        this.nf = nf;
        this.deepCopier = new DeepCopy(nf.lang());
        this.flatten_all_decls = flatten_all_decls;
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof If) {
            If s = (If)n;
            Stmt s1 = s.consequent();
            Stmt s2 = s.alternative();
            if (!(s1 instanceof Block)) {
                s = s.consequent(this.createBlock(s1));
            }
            if (s2 != null && !(s2 instanceof Block)) {
                s = s.alternative(this.createBlock(s2));
            }
            return this.visitEdgeNoOverride(parent, s);
        }
        if (n instanceof Loop) {
            Loop lp = (Loop)n;
            Stmt b = this.visitEdge(lp, this.createBlock(lp.body()));
            lp = lp.body(b);
            if (!(parent instanceof Labeled)) {
                this.addStmt(lp);
            }
            return lp;
        }
        if (n instanceof Binary) {
            Binary b = (Binary)n;
            return this.translateBinary(b);
        }
        if (n instanceof Conditional) {
            Conditional c = (Conditional)n;
            Expr cond = this.visitEdge(c, c.cond());
            LocalDecl d = this.createDecl(c.type(), c.position(), null);
            this.addStmt(d);
            Local l = this.createLocal(d);
            If s = this.createCondIf(cond, l, c.consequent(), c.alternative(), c);
            s = this.visitEdge(c, s);
            this.addStmt(s);
            return l;
        }
        if (n instanceof ConstructorCall) {
            this.addStmt((Stmt)n);
            return n;
        }
        if (n instanceof FieldDecl) {
            return n;
        }
        return null;
    }

    @Override
    public NodeVisitor enter(Node n) {
        Unary u;
        LocalDecl d;
        Expr e;
        if (n instanceof Block) {
            this.pushBlock();
        }
        if (n instanceof Eval) {
            Eval s = (Eval)n;
            this.addDontFlatten(s.expr());
        }
        if (n instanceof Assign) {
            Assign a = (Assign)n;
            this.addDontFlatten(a.left());
            if (a.left() instanceof Local && !this.isAssign(a.right())) {
                this.addDontFlatten(a.right());
            }
        }
        if (n instanceof LocalDecl && (e = (d = (LocalDecl)n).init()) != null && !this.isAssign(e)) {
            this.addDontFlatten(e);
        }
        if (n instanceof ArrayInit) {
            this.addDontFlatten((ArrayInit)n);
        }
        if (n instanceof Unary && this.isAssign(u = (Unary)n)) {
            this.addDontFlatten(u.expr());
        }
        if (n instanceof Expr) {
            Expr e2 = (Expr)n;
            if (this.lang().isConstant(e2, this.lang())) {
                this.addDontFlatten(e2);
            }
        }
        return this;
    }

    @Override
    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        Eval ev;
        if (n instanceof Block) {
            Block b = (Block)n;
            n = b.statements(this.popBlock());
        }
        if (n instanceof Eval && (ev = (Eval)n).expr() instanceof Local) {
            n = this.createEmpty();
        }
        if (n instanceof LocalDecl) {
            n = this.translateLocalDecl((LocalDecl)n);
        }
        if (n instanceof Stmt && parent instanceof Block) {
            this.addStmt((Stmt)n);
            return n;
        }
        if (!this.inBlock()) {
            return n;
        }
        if (n instanceof Expr) {
            Expr e = (Expr)n;
            Expr o = (Expr)old;
            return this.flattenExpr(e, o);
        }
        return n;
    }

    public Expr flattenExpr(Expr n, Expr old) {
        boolean flatten = !this.dontFlatten(old);
        Type t = this.declType(n.type());
        if (n instanceof Unary && this.isAssign(n)) {
            Unary u = (Unary)n;
            Block inc = this.createBlock(this.createIncDec(u));
            Local l = null;
            Eval a = null;
            if (flatten) {
                Expr e = u.expr();
                LocalDecl d = this.createDecl(t, e.position(), null);
                this.addStmt(d);
                l = this.createLocal(d);
                a = this.createAssign(l, e);
            }
            if (u.operator().isPrefix()) {
                inc = this.visitEdge(n, inc);
                this.addStmt(inc);
                if (flatten) {
                    this.addStmt(a);
                }
            } else {
                if (flatten) {
                    this.addStmt(a);
                }
                inc = this.visitEdge(n, inc);
                this.addStmt(inc);
            }
            if (flatten) {
                return l;
            }
            return this.nf.Local(n.position().startOf(), this.nf.Id(n.position().startOf(), "dummy"));
        }
        if (n instanceof Assign && !this.isSimpleAssign(n)) {
            Assign a = (Assign)n;
            a = this.createSimpleAssign(a);
            if (!flatten) {
                this.addDontFlatten(a);
            }
            return this.visitEdge(n, a);
        }
        if (flatten) {
            Expr e;
            Expr val = e = n;
            if (e instanceof Assign) {
                Assign a = (Assign)e;
                val = (Expr)this.deepCopy(a.left());
                Eval s = this.createEval(a);
                this.addStmt(s);
            }
            if (!this.flatten_all_decls) {
                return this.createDeclWithInit(t, e.position(), val);
            }
            LocalDecl d = this.createDecl(t, val.position(), null);
            this.addStmt(d);
            Local l = this.createLocal(d);
            this.addStmt(this.createAssign(l, val));
            return this.createLocal(d);
        }
        return n;
    }

    protected Type declType(Type t) {
        return t;
    }

    protected Expr translateBinary(Binary b) {
        if (this.neverFlatten(b)) {
            return b;
        }
        return this.translateShortCircuitBinary(b);
    }

    protected Expr translateShortCircuitBinary(Binary b) {
        if (b.operator() == Binary.COND_AND) {
            Expr left = this.visitEdge(b, b.left());
            if (left instanceof BooleanLit) {
                BooleanLit lit = (BooleanLit)left;
                if (!lit.value()) {
                    return lit;
                }
                return this.visitEdge(b, b.right());
            }
            LocalDecl d = this.createDecl(this.ts.Boolean(), b.position(), null);
            this.addStmt(d);
            Local r = this.createLocal(d);
            If s = this.createAndIf(left, r, b.right(), b);
            s = this.visitEdge(b, s);
            this.addStmt(s);
            return r;
        }
        if (b.operator() == Binary.COND_OR) {
            Expr left = this.visitEdge(b, b.left());
            if (left instanceof BooleanLit) {
                BooleanLit lit = (BooleanLit)left;
                if (lit.value()) {
                    return lit;
                }
                return this.visitEdge(b, b.right());
            }
            LocalDecl d = this.createDecl(this.ts.Boolean(), b.position(), null);
            this.addStmt(d);
            Local r = this.createLocal(d);
            If s = this.createOrIf(left, r, b.right(), b);
            s = this.visitEdge(b, s);
            this.addStmt(s);
            return r;
        }
        return null;
    }

    protected Stmt translateLocalDecl(LocalDecl d) {
        ForInit n = d;
        Expr e = d.init();
        if (e != null) {
            d = d.flags().isFinal() ? d.init(null) : d.init(this.defaultValue(d.declType(), d.position()));
            this.addStmt(d);
            if (e instanceof ArrayInit) {
                ArrayType at;
                if (e.type() instanceof ArrayType) {
                    at = (ArrayType)e.type();
                    e = this.createNewArray((ArrayInit)e, at.ultimateBase(), at.dims());
                } else if (e.type() instanceof NullType) {
                    at = (ArrayType)d.type().type();
                    e = this.createNewArray((ArrayInit)e, at.ultimateBase(), at.dims());
                } else {
                    throw new InternalCompilerError("Unexpected type for array init: " + e.type());
                }
            }
            Local l = this.createLocal(d);
            n = this.createAssign(l, e);
        } else if (!d.flags().isFinal()) {
            n = d.init(this.defaultValue(d.declType(), d.position()));
        }
        return n;
    }

    private Expr createNewArray(ArrayInit e, Type t, int dims) {
        Position pos = e.position();
        CanonicalTypeNode base = this.nf.CanonicalTypeNode(pos, t);
        NewArray na = this.nf.NewArray(pos, (TypeNode)base, dims, e);
        return na.type(this.ts.arrayOf(t));
    }

    protected Local createDeclWithInit(Type t, Position pos, Expr val) {
        LocalDecl d = this.createDecl(t, pos, val);
        this.addStmt(d);
        Local l = this.createLocal(d);
        return l;
    }

    protected boolean dontFlatten(Expr e) {
        boolean ret = this.dontFlatten.contains(e);
        this.dontFlatten.remove(e);
        return ret || this.neverFlatten(e);
    }

    protected void addDontFlatten(Expr e) {
        this.dontFlatten.add(e);
    }

    protected boolean neverFlatten(Expr e) {
        return e instanceof Lit || e instanceof Special || e instanceof Local;
    }

    protected void pushBlock() {
        this.blockStack.push(new ArrayList());
    }

    protected List<Stmt> popBlock() {
        return this.blockStack.pop();
    }

    protected boolean inBlock() {
        return !this.blockStack.empty();
    }

    protected void addStmt(Stmt s) {
        this.blockStack.peek().add(s);
    }

    protected <N extends Node> N postCreate(N n) {
        return n;
    }

    protected String newId() {
        return UniqueID.newID("flat");
    }

    protected boolean isAssign(Expr e) {
        if (e instanceof Unary) {
            Unary u = (Unary)e;
            return u.operator() == Unary.POST_INC || u.operator() == Unary.POST_DEC || u.operator() == Unary.PRE_INC || u.operator() == Unary.PRE_DEC;
        }
        return e instanceof Assign;
    }

    protected boolean isSimpleAssign(Expr e) {
        if (e instanceof Assign) {
            Assign a = (Assign)e;
            return a.operator() == Assign.ASSIGN;
        }
        return false;
    }

    protected Node deepCopy(Node n) {
        return n.visit(this.deepCopier);
    }

    protected Block createBlock(Stmt s) {
        if (s instanceof Block) {
            return (Block)s;
        }
        Block b = this.nf.Block(s.position(), s);
        b = this.postCreate(b);
        return b;
    }

    protected Empty createEmpty() {
        Empty s = this.nf.Empty(Position.compilerGenerated());
        s = this.postCreate(s);
        return s;
    }

    protected Eval createEval(Expr e) {
        Eval s = this.nf.Eval(e.position(), e);
        s = this.postCreate(s);
        return s;
    }

    private Expr defaultValue(Type t, Position pos) {
        if (t.isPrimitive()) {
            if (t.isBoolean()) {
                return this.nf.BooleanLit(pos, false).type(this.ts.Boolean());
            }
            if (t.isNumeric()) {
                return this.nf.IntLit(pos, IntLit.INT, 0L).type(t);
            }
            throw new InternalCompilerError("Unexpected primitive type: " + t);
        }
        return this.nf.NullLit(pos).type(this.ts.Null());
    }

    protected LocalDecl createDecl(Type t, Position pos, Expr init) {
        String name = this.newId();
        LocalInstance li = this.ts.localInstance(pos, Flags.NONE, t, name);
        if (init == null) {
            init = this.defaultValue(t, pos);
        }
        LocalDecl d = this.nf.LocalDecl(pos, Flags.NONE, (TypeNode)this.postCreate(this.nf.CanonicalTypeNode(pos, t)), this.postCreate(this.nf.Id(pos, name)), init);
        d = d.localInstance(li);
        d = this.postCreate(d);
        return d;
    }

    protected Local createLocal(LocalDecl d) {
        Position pos = d.position();
        LocalInstance li = d.localInstance();
        Local l = (Local)this.nf.Local(pos, this.postCreate(this.nf.Id(pos, d.name()))).type(this.typeOf(li));
        l = l.localInstance(li);
        l = this.postCreate(l);
        return l;
    }

    protected Eval createAssign(Expr l, Expr r) {
        Position pos = l.position();
        l = (Expr)this.deepCopy(l);
        Eval a = this.nf.Eval(pos, this.postCreate(this.nf.Assign(pos, l, Assign.ASSIGN, r)).type(this.typeOf(l)));
        a = this.postCreate(a);
        return a;
    }

    protected Assign createSimpleAssign(Assign a) {
        Position pos = a.position();
        Binary.Operator op = a.operator().binaryOperator();
        Binary b = this.postCreate(this.nf.Binary(pos, (Expr)this.deepCopy(a.left()), op, a.right()));
        if (this.typeOf(a.left()).isNumeric() && this.typeOf(a.right()).isNumeric()) {
            try {
                b = (Binary)b.type(this.ts.promote(this.typeOf(a.left()), this.typeOf(a.right())));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError(e);
            }
        } else {
            b = (Binary)b.type(a.left().type());
        }
        TypeNode tn = this.postCreate(this.nf.CanonicalTypeNode(pos, a.left().type()));
        Cast c = this.postCreate(this.nf.Cast(pos, tn, b));
        c = (Cast)c.type(a.left().type());
        a = (Assign)this.nf.Assign(pos, a.left(), Assign.ASSIGN, c).type(this.typeOf(a));
        a = this.postCreate(a);
        return a;
    }

    protected Eval createIncDec(Unary u) {
        Expr plus;
        Position pos = u.position();
        Binary.Operator op = u.operator() == Unary.PRE_INC || u.operator() == Unary.POST_INC ? Binary.ADD : Binary.SUB;
        Expr e = u.expr();
        Expr e2 = (Expr)this.deepCopy(e);
        if (e.type().isChar()) {
            e2 = this.nf.Cast(pos, this.nf.CanonicalTypeNode(pos, this.ts.Int()), e2).type(this.ts.Int());
        }
        try {
            plus = this.nf.Binary(pos, e2, op, this.createInt(1)).type(this.ts.promote(this.typeOf(e2)));
        }
        catch (SemanticException se) {
            throw new InternalCompilerError(se);
        }
        plus = this.nf.Cast(pos, this.nf.CanonicalTypeNode(pos, e.type()), plus).type(e.type());
        Eval a = this.createAssign(e, this.postCreate(plus).type(this.typeOf(e)));
        return a;
    }

    protected If createAndIf(Expr cond, Local l, Expr e, Binary original) {
        Position pos = l.position();
        cond = (Expr)this.deepCopy(cond);
        If s = this.nf.If(pos, cond, this.createAssign(l, e), this.createAssign(l, this.createBool(false)));
        s = this.postCreate(s);
        return s;
    }

    protected If createOrIf(Expr cond, Local l, Expr e, Binary original) {
        Position pos = l.position();
        cond = (Expr)this.deepCopy(cond);
        If s = this.nf.If(pos, cond, this.createAssign(l, this.createBool(true)), this.createAssign(l, e));
        s = this.postCreate(s);
        return s;
    }

    protected If createCondIf(Expr cond, Local l, Expr e1, Expr e2, Conditional original) {
        Position pos = l.position();
        If s = this.nf.If(pos, cond, this.createAssign(l, e1), this.createAssign(l, e2));
        s = this.postCreate(s);
        return s;
    }

    protected BooleanLit createBool(boolean val) {
        return (BooleanLit)this.postCreate(this.nf.BooleanLit(Position.compilerGenerated(), val)).type(this.ts.Boolean());
    }

    protected IntLit createInt(int val) {
        return (IntLit)this.postCreate(this.nf.IntLit(Position.compilerGenerated(), IntLit.INT, val)).type(this.ts.Int());
    }

    protected Type typeOf(Expr e) {
        return e.type();
    }

    protected Type typeOf(LocalInstance li) {
        return li.type();
    }
}

