/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.CodeNode;
import polyglot.ast.MethodDecl;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class ExitChecker
extends DataFlow<DataFlowItem> {
    protected CodeNode code;

    public ExitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false);
    }

    @Override
    protected FlowGraph<DataFlowItem> initGraph(CodeNode code, Term root) {
        MethodDecl d;
        this.code = code;
        if (code instanceof MethodDecl && !(d = (MethodDecl)code).methodInstance().returnType().isVoid()) {
            return super.initGraph(code, root);
        }
        return null;
    }

    @Override
    public DataFlowItem createInitialItem(FlowGraph<DataFlowItem> graph, Term node, boolean entry) {
        return DataFlowItem.EXITS;
    }

    @Override
    public Map<FlowGraph.EdgeKey, DataFlowItem> flow(DataFlowItem in, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        Term n = peer.node();
        Set<FlowGraph.EdgeKey> succEdgeKeys = peer.succEdgeKeys();
        if (n instanceof Return) {
            return ExitChecker.itemToMap(DataFlowItem.EXITS, succEdgeKeys);
        }
        if (n == graph.root() && !peer.isEntry()) {
            Map<FlowGraph.EdgeKey, DataFlowItem> m = ExitChecker.itemToMap(DataFlowItem.EXITS, succEdgeKeys);
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
                m.put(FlowGraph.EDGE_KEY_OTHER, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
                m.put(FlowGraph.EDGE_KEY_TRUE, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
                m.put(FlowGraph.EDGE_KEY_FALSE, DataFlowItem.DOES_NOT_EXIT);
            }
            return m;
        }
        return ExitChecker.itemToMap(in, succEdgeKeys);
    }

    @Override
    public DataFlowItem confluence(List<DataFlowItem> inItems, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        for (DataFlowItem item : inItems) {
            if (item.exits) continue;
            return DataFlowItem.DOES_NOT_EXIT;
        }
        return DataFlowItem.EXITS;
    }

    @Override
    public void check(FlowGraph<DataFlowItem> graph, Term n, boolean entry, DataFlowItem inItem, Map<FlowGraph.EdgeKey, DataFlowItem> outItems) throws SemanticException {
        DataFlowItem outItem;
        if (n == graph.root() && entry && outItems != null && !outItems.isEmpty() && (outItem = outItems.values().iterator().next()) != null && !outItem.exits) {
            throw new SemanticException("Missing return statement.", this.code.position());
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        public final boolean exits;
        public static final DataFlowItem EXITS = new DataFlowItem(true);
        public static final DataFlowItem DOES_NOT_EXIT = new DataFlowItem(false);

        protected DataFlowItem(boolean exits) {
            this.exits = exits;
        }

        public String toString() {
            return "exits=" + this.exits;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.exits == ((DataFlowItem)o).exits;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.exits ? 5235 : 8673;
        }
    }
}

