/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V>
extends AbstractMap<K, Set<V>> {
    private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    private Set<V> getValueSet(K key) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            this.map.put(key, values);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Set<V> values : this.map.values()) {
            if (!values.contains(values)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<V> get(Object key) {
        return this.map.get(key);
    }

    public Set<V> getValues(Object key) {
        Set<V> s = this.map.get(key);
        if (s == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(s);
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        Set<V> original = this.map.get(key);
        HashSet<V> values = new HashSet<V>();
        values.addAll(value);
        this.map.put(key, values);
        return original;
    }

    public boolean add(K key, V value) {
        return this.getValueSet(key).add(value);
    }

    public boolean addAll(K key, Collection<V> values) {
        return this.getValueSet(key).addAll(values);
    }

    @Override
    public Set<V> remove(Object key) {
        Set<V> original = this.map.get(key);
        this.map.remove(key);
        return original;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            return false;
        }
        return values.remove(value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (K key : this.map.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Set<V> values = this.map.get(key);
            sb.append("[" + key + ": " + values + "]");
        }
        sb.append("}");
        return sb.toString();
    }
}

