/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.util.Pair;
import polyglot.util.Transformation;
import polyglot.util.TransformingIterator;

public class CollectionUtil {
    public static <T> List<T> add(List<T> l, T o) {
        l.add(o);
        return l;
    }

    public static <T, U> boolean equals(Collection<T> a, Collection<U> b) {
        if (a == b) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        Iterator<T> i = a.iterator();
        Iterator<U> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            U p;
            T o = i.next();
            if (o == (p = j.next())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public static <T> List<T> list() {
        return Collections.emptyList();
    }

    public static <T> List<T> list(T o) {
        return Collections.singletonList(o);
    }

    public static <T> List<T> list(T o1, T o2) {
        ArrayList<T> l = new ArrayList<T>(2);
        l.add(o1);
        l.add(o2);
        return l;
    }

    public static <T> List<T> list(T o1, T o2, T o3) {
        ArrayList<T> l = new ArrayList<T>(3);
        l.add(o1);
        l.add(o2);
        l.add(o3);
        return l;
    }

    public static <T> List<T> list(T o1, T o2, T o3, T o4) {
        ArrayList<T> l = new ArrayList<T>(3);
        l.add(o1);
        l.add(o2);
        l.add(o3);
        l.add(o4);
        return l;
    }

    public static <T, U extends T, V extends T> T firstOrElse(Collection<U> l, V alt) {
        Iterator<U> i = l.iterator();
        if (i.hasNext()) {
            return (T)i.next();
        }
        return alt;
    }

    public static <T> Iterator<Pair<T, T>> pairs(Collection<T> l) {
        LinkedList<Pair<Object, T>> x = new LinkedList<Pair<Object, T>>();
        Object prev = null;
        for (T curr : l) {
            if (prev != null) {
                x.add(new Pair<Object, T>(prev, curr));
            }
            prev = curr;
        }
        return x.iterator();
    }

    public static <T, U> List<U> map(List<T> l, Transformation<T, U> t) {
        ArrayList m = new ArrayList(l.size());
        TransformingIterator<T, U> i = new TransformingIterator<T, U>(l.iterator(), t);
        while (i.hasNext()) {
            m.add(i.next());
        }
        return m;
    }

    public static <T> List<T> nonNullList(List<T> l) {
        if (l != null) {
            return l;
        }
        return Collections.emptyList();
    }
}

