/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LazyClassInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.Method;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class ClassFileLazyClassInitializer
implements LazyClassInitializer {
    protected ClassFile clazz;
    protected TypeSystem ts;
    protected ParsedClassType ct;
    protected boolean init;
    protected boolean constructorsInitialized;
    protected boolean fieldsInitialized;
    protected boolean interfacesInitialized;
    protected boolean memberClassesInitialized;
    protected boolean methodsInitialized;
    protected boolean superclassInitialized;
    protected static Collection<String> verbose = new HashSet<String>();

    public ClassFileLazyClassInitializer(ClassFile file, TypeSystem ts) {
        this.clazz = file;
        this.ts = ts;
    }

    @Override
    public void setClass(ParsedClassType ct) {
        this.ct = ct;
    }

    @Override
    public boolean fromClassFile() {
        return true;
    }

    public Position position() {
        return new Position(null, this.clazz.name() + ".class");
    }

    protected ParsedClassType createType() throws SemanticException {
        String name = this.clazz.classNameCP(this.clazz.getThisClass());
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "creating ClassType for " + name);
        }
        ParsedClassType ct = this.ts.createClassType(this);
        ct.flags(this.ts.flagsForBits(this.clazz.getModifiers()).clearSynchronized());
        ct.position(this.position());
        String packageName = StringUtil.getPackageComponent(name);
        if (!packageName.equals("")) {
            ct.package_(this.ts.packageForName(packageName));
        }
        String className = StringUtil.getShortNameComponent(name);
        ClassType.Kind kind = ClassType.TOP_LEVEL;
        InnerClasses innerClasses = this.clazz.getInnerClasses();
        if (innerClasses != null && className.lastIndexOf(36) >= 0) {
            for (InnerClasses.Info c : innerClasses.getClasses()) {
                if (c.classIndex != this.clazz.getThisClass() || c.classIndex == 0) continue;
                ct.flags(this.ts.flagsForBits(c.modifiers));
                if (c.nameIndex == 0) {
                    kind = ClassType.ANONYMOUS;
                    break;
                }
                String outerName = this.clazz.classNameCP(c.outerClassIndex);
                className = (String)this.clazz.getConstants()[c.nameIndex].value();
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "resolving " + outerName + " for " + name);
                }
                ClassType outer = this.typeForName(outerName);
                ClassType.Kind outerKind = ct.kind();
                kind = outerKind == ClassType.ANONYMOUS ? ClassType.LOCAL : ClassType.MEMBER;
                ct.outer(outer);
                break;
            }
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, name + " is " + kind);
        }
        ct.name(className);
        ct.kind(kind);
        this.ts.systemResolver().addNamed(name, ct);
        this.ts.systemResolver().addNamed(ct.fullName(), ct);
        return ct;
    }

    public ParsedClassType type() throws SemanticException {
        ParsedClassType ct = this.createType();
        return ct;
    }

    protected Type arrayOf(Type t, int dims) {
        if (dims == 0) {
            return t;
        }
        return this.ts.arrayOf(t, dims);
    }

    protected List<Type> typeListForString(String str) {
        ArrayList<Type> types = new ArrayList<Type>();
        block12: for (int i = 0; i < str.length(); ++i) {
            int dims = 0;
            while (str.charAt(i) == '[') {
                ++dims;
                ++i;
            }
            switch (str.charAt(i)) {
                case 'Z': {
                    types.add(this.arrayOf(this.ts.Boolean(), dims));
                    continue block12;
                }
                case 'B': {
                    types.add(this.arrayOf(this.ts.Byte(), dims));
                    continue block12;
                }
                case 'S': {
                    types.add(this.arrayOf(this.ts.Short(), dims));
                    continue block12;
                }
                case 'C': {
                    types.add(this.arrayOf(this.ts.Char(), dims));
                    continue block12;
                }
                case 'I': {
                    types.add(this.arrayOf(this.ts.Int(), dims));
                    continue block12;
                }
                case 'J': {
                    types.add(this.arrayOf(this.ts.Long(), dims));
                    continue block12;
                }
                case 'F': {
                    types.add(this.arrayOf(this.ts.Float(), dims));
                    continue block12;
                }
                case 'D': {
                    types.add(this.arrayOf(this.ts.Double(), dims));
                    continue block12;
                }
                case 'V': {
                    types.add(this.arrayOf(this.ts.Void(), dims));
                    continue block12;
                }
                case 'L': {
                    int start = ++i;
                    while (i < str.length()) {
                        if (str.charAt(i) == ';') {
                            String s = str.substring(start, i);
                            s = s.replace('/', '.');
                            types.add(this.arrayOf(this.quietTypeForName(s), dims));
                            continue block12;
                        }
                        ++i;
                    }
                    continue block12;
                }
            }
        }
        if (Report.should_report(verbose, 4)) {
            Report.report(4, "parsed \"" + str + "\" -> " + types);
        }
        return types;
    }

    public Type typeForString(String str) {
        List<Type> l = this.typeListForString(str);
        if (l.size() == 1) {
            return l.get(0);
        }
        throw new InternalCompilerError("Bad type string: \"" + str + "\"");
    }

    protected ClassType quietTypeForName(String name) {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        try {
            return (ClassType)this.ts.systemResolver().find(name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("could not load " + name, e);
        }
    }

    protected ClassType typeForName(String name) throws SemanticException {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        return (ClassType)this.ts.systemResolver().find(name);
    }

    @Override
    public void initTypeObject() {
        this.init = true;
    }

    @Override
    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    @Override
    public void initSuperclass() {
        if (this.superclassInitialized) {
            return;
        }
        if (this.ts.equals(this.ct, this.ts.Object())) {
            this.ct.superType(null);
        } else {
            ClassType superType;
            String superName = this.clazz.classNameCP(this.clazz.getSuperClass());
            ClassType classType = superType = superName == null ? this.ts.Object() : this.quietTypeForName(superName);
            if (this.ct.flags().isInterface()) {
                if (!this.ts.typeEquals(superType, this.ts.Object())) {
                    throw new ClassFormatError("The superclass of an interface is not Object.");
                }
            } else {
                this.ct.superType(superType);
            }
        }
        this.superclassInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initInterfaces() {
        int[] interfaces;
        if (this.interfacesInitialized) {
            return;
        }
        for (int interface1 : interfaces = this.clazz.getInterfaces()) {
            String name = this.clazz.classNameCP(interface1);
            this.ct.addInterface(this.quietTypeForName(name));
        }
        this.interfacesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initMemberClasses() {
        if (this.memberClassesInitialized) {
            return;
        }
        InnerClasses innerClasses = this.clazz.getInnerClasses();
        if (innerClasses != null) {
            for (int i = 0; i < innerClasses.getClasses().length; ++i) {
                String name;
                int index;
                InnerClasses.Info c = innerClasses.getClasses()[i];
                if (c.outerClassIndex != this.clazz.getThisClass() || c.classIndex == 0 || (index = (name = this.clazz.classNameCP(c.classIndex)).lastIndexOf(36)) >= 0 && Character.isDigit(name.charAt(index + 1))) continue;
                ClassType t = this.quietTypeForName(name);
                if (t.isMember()) {
                    if (Report.should_report(verbose, 3)) {
                        Report.report(3, "adding member " + t + " to " + this.ct);
                    }
                    this.ct.addMemberClass(t);
                    if (!(t instanceof ParsedClassType)) continue;
                    ParsedClassType pt = (ParsedClassType)t;
                    pt.flags(this.ts.flagsForBits(c.modifiers));
                    continue;
                }
                throw new InternalCompilerError(name + " should be a member class.");
            }
        }
        this.memberClassesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void canonicalFields() {
        this.initFields();
    }

    @Override
    public void canonicalMethods() {
        this.initMethods();
    }

    @Override
    public void canonicalConstructors() {
        this.initConstructors();
    }

    @Override
    public void initFields() {
        if (this.fieldsInitialized) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].name().startsWith("jlc$") || fields[i].isSynthetic()) continue;
            FieldInstance fi = this.fieldInstance(fields[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + fi + " to " + this.ct);
            }
            this.ct.addField(fi);
        }
        this.fieldsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initMethods() {
        if (this.methodsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        ArrayList<MethodInstance> declaredMethods = new ArrayList<MethodInstance>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].name().equals("<init>") || methods[i].name().equals("<clinit>") || methods[i].isSynthetic()) continue;
            MethodInstance mi = this.methodInstance(methods[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + mi + " to " + this.ct);
            }
            declaredMethods.add(mi);
            this.ct.addMethod(mi);
        }
        if (this.ct.flags().isInterface() && this.ct.interfaces().isEmpty()) {
            List<? extends MethodInstance> objectMethods = this.ts.Object().methods();
            ArrayList<MethodInstance> implicitlyDeclaredMethods = new ArrayList<MethodInstance>(objectMethods.size());
            for (MethodInstance methodInstance : objectMethods) {
                Flags flags = methodInstance.flags();
                if (!flags.isPublic()) continue;
                boolean methodNeeded = true;
                for (MethodInstance mj : declaredMethods) {
                    if (!methodInstance.name().equals(mj.name()) || !methodInstance.formalTypes().equals(mj.formalTypes())) continue;
                    methodNeeded = false;
                    break;
                }
                if (!methodNeeded) continue;
                implicitlyDeclaredMethods.add(methodInstance.container(this.ct).flags(flags.Abstract().clearFinal()));
            }
            for (MethodInstance methodInstance : implicitlyDeclaredMethods) {
                this.ct.addMethod(methodInstance);
            }
        }
        this.methodsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initConstructors() {
        if (this.constructorsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].name().equals("<init>") || methods[i].isSynthetic()) continue;
            ConstructorInstance ci = this.constructorInstance(methods[i], this.ct, this.clazz.getFields());
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + ci + " to " + this.ct);
            }
            this.ct.addConstructor(ci);
        }
        this.constructorsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    protected boolean initialized() {
        return this.superclassInitialized && this.interfacesInitialized && this.memberClassesInitialized && this.methodsInitialized && this.fieldsInitialized && this.constructorsInitialized;
    }

    protected MethodInstance methodInstance(Method method, ClassType ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[method.getName()].value();
        String type = (String)constants[method.getType()].value();
        if (type.charAt(0) != '(') {
            throw new ClassFormatError("Bad method type descriptor.");
        }
        int index = type.indexOf(41, 1);
        List<Type> argTypes = this.typeListForString(type.substring(1, index));
        Type returnType = this.typeForString(type.substring(index + 1));
        ArrayList<ClassType> excTypes = new ArrayList<ClassType>();
        Exceptions exceptions = method.getExceptions();
        if (exceptions != null) {
            int[] throwTypes;
            for (int throwType : throwTypes = exceptions.getThrowTypes()) {
                String s = this.clazz.classNameCP(throwType);
                excTypes.add(this.quietTypeForName(s));
            }
        }
        return this.ts.methodInstance(ct.position(), ct, this.ts.flagsForBits(method.getModifiers()), returnType, name, argTypes, excTypes);
    }

    protected ConstructorInstance constructorInstance(Method method, ClassType ct, Field[] fields) {
        MethodInstance mi = this.methodInstance(method, ct);
        List<? extends Type> formals = mi.formalTypes();
        if (ct.isInnerClass()) {
            int numSynthetic = 0;
            for (Field field : fields) {
                if (!field.isSynthetic()) continue;
                ++numSynthetic;
            }
            if (numSynthetic <= formals.size()) {
                formals = formals.subList(numSynthetic, formals.size());
            }
        }
        return this.ts.constructorInstance(mi.position(), ct, mi.flags(), formals, mi.throwTypes());
    }

    protected FieldInstance fieldInstance(Field field, ClassType ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[field.getName()].value();
        String type = (String)constants[field.getType()].value();
        FieldInstance fi = this.ts.fieldInstance(ct.position(), ct, this.ts.flagsForBits(field.getModifiers()), this.typeForString(type), name);
        if (field.isConstant()) {
            Constant c = field.constantValue();
            Object o = null;
            try {
                switch (c.tag()) {
                    case 8: {
                        o = field.getString();
                        break;
                    }
                    case 3: {
                        o = new Integer(field.getInt());
                        break;
                    }
                    case 5: {
                        o = new Long(field.getLong());
                        break;
                    }
                    case 4: {
                        o = new Float(field.getFloat());
                        break;
                    }
                    case 6: {
                        o = new Double(field.getDouble());
                    }
                }
            }
            catch (SemanticException e) {
                throw new ClassFormatError("Unexpected constant pool entry.");
            }
            fi.setConstantValue(o);
            return fi;
        }
        fi.setNotConstant();
        return fi;
    }

    static {
        verbose.add("loader");
    }
}

