/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import polyglot.types.Declaration;
import polyglot.types.FieldInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class ReferenceType_c
extends Type_c
implements ReferenceType {
    private static final long serialVersionUID = SerialVersionUID.generate();

    protected ReferenceType_c() {
    }

    public ReferenceType_c(TypeSystem ts) {
        this(ts, null);
    }

    public ReferenceType_c(TypeSystem ts, Position pos) {
        super(ts, pos);
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public ReferenceType toReference() {
        return this;
    }

    @Override
    public List<? extends MemberInstance> members() {
        ArrayList<Declaration> l = new ArrayList<Declaration>();
        l.addAll(this.methods());
        l.addAll(this.fields());
        return l;
    }

    @Override
    public abstract List<? extends MethodInstance> methods();

    @Override
    public abstract List<? extends FieldInstance> fields();

    @Override
    public abstract Type superType();

    @Override
    public abstract List<? extends ReferenceType> interfaces();

    @Override
    public final boolean hasMethod(MethodInstance mi) {
        return this.ts.hasMethod(this, mi);
    }

    @Override
    public boolean hasMethodImpl(MethodInstance mi) {
        for (MethodInstance methodInstance : this.methods()) {
            if (!this.ts.isSameMethod(mi, methodInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        if (!ancestor.isCanonical()) {
            return false;
        }
        if (ancestor.isNull()) {
            return false;
        }
        if (this.ts.typeEquals(this, ancestor)) {
            return false;
        }
        if (!ancestor.isReference()) {
            return false;
        }
        if (this.ts.typeEquals(ancestor, this.ts.Object())) {
            return true;
        }
        for (Type type : this.interfaces()) {
            if (!this.ts.isSubtype(type, ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        return this.ts.isSubtype(this, toType);
    }

    @Override
    public List<? extends MethodInstance> methodsNamed(String name) {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        for (MethodInstance methodInstance : this.methods()) {
            if (!methodInstance.name().equals(name)) continue;
            l.add(methodInstance);
        }
        return l;
    }

    @Override
    public List<? extends MethodInstance> methods(String name, List<? extends Type> argTypes) {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        for (MethodInstance methodInstance : this.methodsNamed(name)) {
            if (!methodInstance.hasFormals(argTypes)) continue;
            l.add(methodInstance);
        }
        return l;
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (!toType.isReference()) {
            return false;
        }
        return this.ts.isSubtype(this, toType) || this.ts.isSubtype(toType, this);
    }
}

