/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.types.Flags;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;

public abstract class ProcedureInstance_c
extends TypeObject_c
implements ProcedureInstance {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected ReferenceType container;
    protected Flags flags;
    protected List<Type> formalTypes;
    protected List<Type> throwTypes;

    protected ProcedureInstance_c() {
    }

    public ProcedureInstance_c(TypeSystem ts, Position pos, ReferenceType container, Flags flags, List<? extends Type> formalTypes, List<? extends Type> excTypes) {
        super(ts, pos);
        this.container = container;
        this.flags = flags;
        this.formalTypes = ListUtil.copy(formalTypes, true);
        this.throwTypes = ListUtil.copy(excTypes, true);
    }

    public ReferenceType container() {
        return this.container;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    public List<Type> formalTypes() {
        return Collections.unmodifiableList(this.formalTypes);
    }

    public List<Type> throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    public void setContainer(ReferenceType container) {
        this.container = container;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void setFormalTypes(List<? extends Type> formalTypes) {
        this.formalTypes = ListUtil.copy(formalTypes, true);
    }

    @Override
    public void setThrowTypes(List<? extends Type> throwTypes) {
        this.throwTypes = ListUtil.copy(throwTypes, true);
    }

    @Override
    public int hashCode() {
        return this.container.hashCode() + this.flags.hashCode();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (o instanceof ProcedureInstance) {
            ProcedureInstance i = (ProcedureInstance)o;
            return this.flags.equals(i.flags()) && this.ts.hasFormals(this, i.formalTypes());
        }
        return false;
    }

    protected boolean listIsCanonical(List<? extends TypeObject> l) {
        for (TypeObject typeObject : l) {
            if (typeObject.isCanonical()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean moreSpecific(ProcedureInstance p) {
        return this.ts.moreSpecific(this, p);
    }

    @Override
    public boolean moreSpecificImpl(ProcedureInstance p) {
        ProcedureInstance_c p1 = this;
        ProcedureInstance p2 = p;
        return p2.callValid(p1.formalTypes());
    }

    @Override
    public final boolean hasFormals(List<? extends Type> formalTypes) {
        return this.ts.hasFormals(this, formalTypes);
    }

    @Override
    public boolean hasFormalsImpl(List<? extends Type> formalTypes) {
        List<Type> l1 = this.formalTypes();
        List<? extends Type> l2 = formalTypes;
        Iterator<Type> i1 = l1.iterator();
        Iterator<? extends Type> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Type t2;
            Type t1 = i1.next();
            if (this.ts.equals(t1, t2 = i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    public final boolean throwsSubset(ProcedureInstance pi) {
        return this.ts.throwsSubset(this, pi);
    }

    @Override
    public boolean throwsSubsetImpl(ProcedureInstance pi) {
        SubtypeSet s1 = new SubtypeSet(this.ts.Throwable());
        SubtypeSet s2 = new SubtypeSet(this.ts.Throwable());
        s1.addAll((Collection<? extends Type>)this.throwTypes());
        s2.addAll((Collection<? extends Type>)pi.throwTypes());
        for (Type t : s1) {
            if (this.ts.isUncheckedException(t) || s2.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean callValid(List<? extends Type> argTypes) {
        return this.ts.callValid(this, argTypes);
    }

    @Override
    public boolean callValidImpl(List<? extends Type> argTypes) {
        List<Type> l1 = this.formalTypes();
        List<? extends Type> l2 = argTypes;
        Iterator<Type> i1 = l1.iterator();
        Iterator<? extends Type> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Type t1 = i1.next();
            Type t2 = i2.next();
            if (this.ts.isImplicitCastValid(t2, t1)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }
}

