/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.PrimitiveType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.util.SerialVersionUID;

public class PrimitiveType_c
extends Type_c
implements PrimitiveType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected PrimitiveType.Kind kind;

    protected PrimitiveType_c() {
    }

    public PrimitiveType_c(TypeSystem ts, PrimitiveType.Kind kind) {
        super(ts);
        this.kind = kind;
    }

    @Override
    public PrimitiveType.Kind kind() {
        return this.kind;
    }

    @Override
    public String toString() {
        return this.kind.toString();
    }

    @Override
    public String translate(Resolver c) {
        return this.kind.toString();
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public PrimitiveType toPrimitive() {
        return this;
    }

    @Override
    public boolean isVoid() {
        return this.kind == VOID;
    }

    @Override
    public boolean isBoolean() {
        return this.kind == BOOLEAN;
    }

    @Override
    public boolean isChar() {
        return this.kind == CHAR;
    }

    @Override
    public boolean isByte() {
        return this.kind == BYTE;
    }

    @Override
    public boolean isShort() {
        return this.kind == SHORT;
    }

    @Override
    public boolean isInt() {
        return this.kind == INT;
    }

    @Override
    public boolean isLong() {
        return this.kind == LONG;
    }

    @Override
    public boolean isFloat() {
        return this.kind == FLOAT;
    }

    @Override
    public boolean isDouble() {
        return this.kind == DOUBLE;
    }

    @Override
    public boolean isIntOrLess() {
        return this.kind == CHAR || this.kind == BYTE || this.kind == SHORT || this.kind == INT;
    }

    @Override
    public boolean isLongOrLess() {
        return this.isIntOrLess() || this.kind == LONG;
    }

    @Override
    public boolean isNumeric() {
        return this.isLongOrLess() || this.kind == FLOAT || this.kind == DOUBLE;
    }

    @Override
    public int hashCode() {
        return this.kind.hashCode();
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (t instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)t;
            return this.kind() == p.kind();
        }
        return false;
    }

    @Override
    public boolean typeEqualsImpl(Type t) {
        return this.ts.equals(this, t);
    }

    @Override
    public String wrapperTypeString(TypeSystem ts) {
        return ts.wrapperTypeString(this);
    }

    @Override
    public String name() {
        return this.kind.toString();
    }

    @Override
    public String fullName() {
        return this.name();
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        return false;
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        if (!toType.isPrimitive()) {
            return false;
        }
        PrimitiveType t = toType.toPrimitive();
        PrimitiveType_c f = this;
        if (t.isVoid()) {
            return false;
        }
        if (f.isVoid()) {
            return false;
        }
        if (this.ts.typeEquals(t, f)) {
            return true;
        }
        if (t.isBoolean()) {
            return f.isBoolean();
        }
        if (f.isBoolean()) {
            return false;
        }
        if (!f.isNumeric() || !t.isNumeric()) {
            return false;
        }
        if (t.isDouble()) {
            return true;
        }
        if (f.isDouble()) {
            return false;
        }
        if (t.isFloat()) {
            return true;
        }
        if (f.isFloat()) {
            return false;
        }
        if (t.isLong()) {
            return true;
        }
        if (f.isLong()) {
            return false;
        }
        if (t.isInt()) {
            return true;
        }
        if (f.isInt()) {
            return false;
        }
        if (t.isShort()) {
            return f.isShort() || f.isByte();
        }
        if (f.isShort()) {
            return false;
        }
        if (t.isChar()) {
            return f.isChar();
        }
        if (f.isChar()) {
            return false;
        }
        if (t.isByte()) {
            return f.isByte();
        }
        if (f.isByte()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (this.isVoid() || toType.isVoid()) {
            return false;
        }
        if (this.ts.typeEquals(this, toType)) {
            return true;
        }
        return this.isNumeric() && toType.isNumeric();
    }

    @Override
    public boolean numericConversionValidImpl(Object value) {
        long v;
        if (value == null) {
            return false;
        }
        if (value instanceof Float || value instanceof Double) {
            return false;
        }
        if (value instanceof Number) {
            v = ((Number)value).longValue();
        } else if (value instanceof Character) {
            v = ((Character)value).charValue();
        } else {
            return false;
        }
        if (this.isLong()) {
            return true;
        }
        if (value instanceof Long) {
            return false;
        }
        if (this.isInt()) {
            return Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE;
        }
        if (this.isChar()) {
            return 0L <= v && v <= 65535L;
        }
        if (this.isShort()) {
            return -32768L <= v && v <= 32767L;
        }
        if (this.isByte()) {
            return -128L <= v && v <= 127L;
        }
        return false;
    }
}

