/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.main.Report;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance_c;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class MethodInstance_c
extends ProcedureInstance_c
implements MethodInstance {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected String name;
    protected Type returnType;
    protected MethodInstance decl;

    protected MethodInstance_c() {
    }

    public MethodInstance_c(TypeSystem ts, Position pos, ReferenceType container, Flags flags, Type returnType, String name, List<? extends Type> formalTypes, List<? extends Type> excTypes) {
        super(ts, pos, container, flags, formalTypes, excTypes);
        this.returnType = returnType;
        this.name = name;
        this.decl = this;
    }

    @Override
    public Declaration declaration() {
        return this.decl;
    }

    @Override
    public void setDeclaration(Declaration decl) {
        this.decl = (MethodInstance)decl;
    }

    @Override
    public MethodInstance orig() {
        return (MethodInstance)this.declaration();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type returnType() {
        return this.returnType;
    }

    @Override
    public MethodInstance flags(Flags flags) {
        if (!flags.equals(this.flags)) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setFlags(flags);
            return n;
        }
        return this;
    }

    @Override
    public MethodInstance name(String name) {
        if (name != null && !name.equals(this.name) || name == null && name != this.name) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setName(name);
            return n;
        }
        return this;
    }

    @Override
    public MethodInstance returnType(Type returnType) {
        if (this.returnType != returnType) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setReturnType(returnType);
            return n;
        }
        return this;
    }

    @Override
    public MethodInstance formalTypes(List<? extends Type> l) {
        if (!CollectionUtil.equals(this.formalTypes, l)) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setFormalTypes(l);
            return n;
        }
        return this;
    }

    @Override
    public MethodInstance throwTypes(List<? extends Type> l) {
        if (!CollectionUtil.equals(this.throwTypes, l)) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setThrowTypes(l);
            return n;
        }
        return this;
    }

    @Override
    public MethodInstance container(ReferenceType container) {
        if (this.container != container) {
            MethodInstance_c n = (MethodInstance_c)this.copy();
            n.setContainer(container);
            return n;
        }
        return this;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    @Override
    public int hashCode() {
        return this.flags.hashCode() + this.name.hashCode();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (o instanceof MethodInstance) {
            MethodInstance i = (MethodInstance)o;
            return this.ts.equals(this.returnType, i.returnType()) && this.name.equals(i.name()) && this.ts.equals(this.container, i.container()) && super.equalsImpl(i);
        }
        return false;
    }

    public String toString() {
        String s = this.designator() + " " + this.flags.translate() + this.returnType + " " + this.container() + "." + this.signature();
        if (!this.throwTypes.isEmpty()) {
            s = s + " throws " + TypeSystem_c.listToString(this.throwTypes);
        }
        return s;
    }

    @Override
    public String signature() {
        return this.name + "(" + TypeSystem_c.listToString(this.formalTypes) + ")";
    }

    @Override
    public String designator() {
        return "method";
    }

    @Override
    public final boolean isSameMethod(MethodInstance mi) {
        return this.ts.isSameMethod(this, mi);
    }

    @Override
    public boolean isSameMethodImpl(MethodInstance mi) {
        return this.name().equals(mi.name()) && this.hasFormals(mi.formalTypes());
    }

    @Override
    public boolean isCanonical() {
        return this.container.isCanonical() && this.returnType.isCanonical() && this.listIsCanonical(this.formalTypes) && this.listIsCanonical(this.throwTypes);
    }

    @Override
    public final boolean methodCallValid(String name, List<? extends Type> argTypes) {
        return this.ts.methodCallValid(this, name, argTypes);
    }

    @Override
    public boolean methodCallValidImpl(String name, List<? extends Type> argTypes) {
        return this.name().equals(name) && this.ts.callValid(this, argTypes);
    }

    @Override
    public List<MethodInstance> overrides() {
        return this.ts.overrides(this);
    }

    @Override
    public List<MethodInstance> overridesImpl() {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        ReferenceType rt = this.container();
        while (rt != null) {
            l.addAll(rt.methods(this.name, this.formalTypes));
            ReferenceType sup = null;
            if (rt.superType() != null && rt.superType().isReference()) {
                sup = (ReferenceType)rt.superType();
            }
            rt = sup;
        }
        return l;
    }

    @Override
    public final boolean canOverride(MethodInstance mj) {
        return this.ts.canOverride(this, mj);
    }

    @Override
    public final void checkOverride(MethodInstance mj) throws SemanticException {
        this.ts.checkOverride(this, mj);
    }

    @Deprecated
    public final boolean canOverrideImpl(MethodInstance mj) {
        throw new InternalCompilerError("canOverrideImpl(MethodInstance mj) should not be called.");
    }

    @Override
    public boolean canOverrideImpl(MethodInstance mj, boolean quiet) throws SemanticException {
        String overridOrHid;
        MethodInstance_c mi = this;
        String string = overridOrHid = mi.flags().isStatic() ? "hid" : "overrid";
        if (!mi.name().equals(mj.name()) || !mi.hasFormals(mj.formalTypes())) {
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; incompatible parameter types", mi.position());
        }
        if (!this.ts.typeEquals(mi.returnType(), mj.returnType())) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "return type " + mi.returnType() + " != " + mj.returnType());
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; attempting to use incompatible return type\n" + "found: " + mi.returnType() + "\n" + "required: " + mj.returnType(), mi.position());
        }
        if (!this.ts.throwsSubset(mi, mj)) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.throwTypes() + " not subset of " + mj.throwTypes());
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; the throw set " + mi.throwTypes() + " is not a subset of the " + overridOrHid + "den method's throw set " + mj.throwTypes() + ".", mi.position());
        }
        if (mi.flags().moreRestrictiveThan(mj.flags())) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.flags() + " more restrictive than " + mj.flags());
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; attempting to assign weaker access privileges", mi.position());
        }
        if (mi.flags().isStatic() != mj.flags().isStatic()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.signature() + " is " + (mi.flags().isStatic() ? "" : "not") + " static but " + mj.signature() + " is " + (mj.flags().isStatic() ? "" : "not") + " static");
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; " + overridOrHid + "den method is " + (mj.flags().isStatic() ? "" : "not ") + "static", mi.position());
        }
        if (mi != mj && !((Object)mi).equals(mj) && mj.flags().isFinal()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mj.flags() + " final");
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot " + overridOrHid + "e " + mj.signature() + " in " + mj.container() + "; " + overridOrHid + "den method is final", mi.position());
        }
        return true;
    }

    @Override
    public List<? extends MethodInstance> implemented() {
        return this.ts.implemented(this);
    }

    @Override
    public List<MethodInstance> implementedImpl(ReferenceType rt) {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        for (MethodInstance mi : this.implementedImplAux(rt)) {
            if (mi.flags().isPrivate() || !this.ts.isAccessible(mi, mi.container(), rt, false)) continue;
            l.add(mi);
        }
        return l;
    }

    protected List<MethodInstance> implementedImplAux(ReferenceType rt) {
        if (rt == null) {
            return Collections.emptyList();
        }
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        l.addAll(rt.methods(this.name, this.formalTypes));
        Type superType = rt.superType();
        if (superType != null) {
            l.addAll(this.implementedImplAux(superType.toReference()));
        }
        List<? extends ReferenceType> ints = rt.interfaces();
        for (ReferenceType referenceType : ints) {
            l.addAll(this.implementedImplAux(referenceType));
        }
        return l;
    }
}

