/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.InvalidClassException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.BadSerializationException;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LazyInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.UnavailableTypeException;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ObjectDumper;
import polyglot.util.SimpleCodeWriter;
import polyglot.util.TypeEncoder;

public class LoadedClassResolver
implements TopLevelResolver {
    protected static final int NOT_COMPATIBLE = -1;
    protected static final int MINOR_NOT_COMPATIBLE = 1;
    protected static final int COMPATIBLE = 0;
    protected TypeSystem ts;
    protected TypeEncoder te;
    protected Version version;
    protected Set<String> nocache;
    protected boolean allowRawClasses;
    protected ExtensionInfo extInfo;
    protected static final Collection<String> report_topics = CollectionUtil.list("types", "resolver", "loader");
    protected ClassFileLoader loader;
    protected boolean recursive = false;

    public LoadedClassResolver(ExtensionInfo extInfo, boolean allowRawClasses) {
        this.extInfo = extInfo;
        this.ts = extInfo.typeSystem();
        this.te = new TypeEncoder(extInfo.typeSystem());
        this.loader = extInfo.classFileLoader();
        this.version = extInfo.version();
        this.nocache = new HashSet<String>();
        this.allowRawClasses = allowRawClasses;
    }

    public boolean allowRawClasses() {
        return this.allowRawClasses;
    }

    @Override
    public boolean packageExists(String name) {
        return this.loader.packageExists(name);
    }

    protected ClassFile loadFile(String name) {
        return this.loader.loadFile(name);
    }

    @Override
    public Named find(String name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "LoadedCR.find(" + name + ")");
        }
        Named result = null;
        ClassFile clazz = this.loadFile(name);
        if (clazz == null) {
            throw new NoClassException(name);
        }
        if (clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            result = this.getEncodedType(clazz, name);
        }
        if (this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            result = this.ts.classFileLazyClassInitializer(clazz).type();
        }
        if (result != null) {
            if (name.equals(result.fullName())) {
                return result;
            }
            if (result instanceof ClassType && name.equals(this.ts.getTransformedClassName((ClassType)result))) {
                return result;
            }
        }
        throw new SemanticException("Unable to find a suitable definition of \"" + name + "\". A class file was found," + " but it did not contain appropriate information for this" + " language extension. If the source for this file is written" + " in the language extension, try recompiling the source code.");
    }

    protected ClassType getEncodedType(ClassFile clazz, String name) throws SemanticException {
        int comp = this.checkCompilerVersion(clazz.compilerVersion(this.version.name()));
        if (comp == -1) {
            throw new SemanticException("Unable to find a suitable definition of " + clazz.name() + ". Try recompiling or obtaining " + " a newer version of the class file.");
        }
        SystemResolver oldResolver = null;
        if (Report.should_report("serialize", 1)) {
            Report.report(1, "Saving system resolver");
        }
        oldResolver = this.ts.saveSystemResolver();
        boolean okay = false;
        boolean oldRecursive = this.recursive;
        if (!this.recursive) {
            this.ts.systemResolver().clearAdded();
        }
        this.recursive = true;
        try {
            TypeObject dt;
            if (Report.should_report("serialize", 1)) {
                Report.report(1, "Decoding " + name + " in " + clazz);
            }
            if ((dt = this.te.decode(clazz.encodedClassType(this.version.name()), name)) == null) {
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "* Decoding " + name + " failed");
                }
                throw new UnavailableTypeException(null, "Could not decode " + name);
            }
            if (dt instanceof ClassType) {
                ClassType ct = (ClassType)dt;
                this.ts.systemResolver().addNamed(name, ct);
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "* Decoding " + name + " succeeded");
                }
                if (Report.should_report("typedump", 1)) {
                    new ObjectDumper(new SimpleCodeWriter(System.out, 72)).dump(dt);
                }
                if (Report.should_report("serialize", 2)) {
                    ParsedClassType pct;
                    LazyInitializer init = null;
                    if (ct instanceof ParsedClassType) {
                        pct = (ParsedClassType)ct;
                        init = pct.initializer();
                        pct.setInitializer(new LazyClassInitializer(){

                            @Override
                            public boolean fromClassFile() {
                                return false;
                            }

                            @Override
                            public void setClass(ParsedClassType ct) {
                            }

                            @Override
                            public void initTypeObject() {
                            }

                            @Override
                            public boolean isTypeObjectInitialized() {
                                return true;
                            }

                            @Override
                            public void initSuperclass() {
                            }

                            @Override
                            public void initInterfaces() {
                            }

                            @Override
                            public void initMemberClasses() {
                            }

                            @Override
                            public void initConstructors() {
                            }

                            @Override
                            public void initMethods() {
                            }

                            @Override
                            public void initFields() {
                            }

                            @Override
                            public void canonicalConstructors() {
                            }

                            @Override
                            public void canonicalMethods() {
                            }

                            @Override
                            public void canonicalFields() {
                            }
                        });
                    }
                    for (MethodInstance methodInstance : ct.methods()) {
                        Report.report(2, "* " + methodInstance);
                    }
                    for (FieldInstance fieldInstance : ct.fields()) {
                        Report.report(2, "* " + fieldInstance);
                    }
                    for (ConstructorInstance constructorInstance : ct.constructors()) {
                        Report.report(2, "* " + constructorInstance);
                    }
                    if (ct instanceof ParsedClassType) {
                        pct = (ParsedClassType)ct;
                        pct.setInitializer(init);
                    }
                }
                if (Report.should_report(report_topics, 2)) {
                    Report.report(2, "Returning serialized ClassType for " + clazz.name() + ".");
                }
                okay = true;
                ClassType classType = ct;
                return classType;
            }
            try {
                if (Report.should_report("serialize", 2)) {
                    Report.report(2, "Failing to deserialize: Class " + name + " not found in " + clazz.name() + ".");
                }
                throw new SemanticException("Class " + name + " not found in " + clazz.name() + ".");
            }
            catch (InvalidClassException e) {
                if (Report.should_report("serialize", 2)) {
                    Report.report(2, "Failing to deserialize: Bad serialization: " + clazz.name() + "@" + clazz.getClassFileURI());
                }
                throw new BadSerializationException(clazz.name() + "@" + clazz.getClassFileURI());
            }
            catch (UnavailableTypeException e) {
                throw e;
            }
            catch (InternalCompilerError e) {
                if (Report.should_report("serialize", 2)) {
                    Report.report(2, "Failing to deserialize: Internal compiler error: " + e.getMessage());
                }
                throw e;
            }
            catch (RuntimeException | SemanticException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.recursive = oldRecursive;
            if (okay) {
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "Deserialization successful.  Installing " + this.ts.systemResolver().justAdded() + " into restored system resolver.");
                }
                oldResolver.putAll(this.ts.systemResolver());
            } else if (Report.should_report("serialize", 1)) {
                Report.report(1, "Deserialization failed for " + name + ".  Restoring previous system resolver.");
                Report.report(1, "Discarding " + this.ts.systemResolver().justAdded());
            }
            this.ts.restoreSystemResolver(oldResolver);
        }
    }

    protected int checkCompilerVersion(String clazzVersion) {
        if (clazzVersion == null) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(clazzVersion, ".");
        try {
            int v = Integer.parseInt(st.nextToken());
            Version version = this.version;
            if (v != version.major()) {
                return -1;
            }
            v = Integer.parseInt(st.nextToken());
            if (v != version.minor()) {
                return 1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return 0;
    }
}

