/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class ImportTable
implements Resolver {
    protected TypeSystem ts;
    protected List<String> typeOnDemandImports;
    protected Map<String, Named> map;
    protected List<String> lazyImports;
    protected List<Position> lazyImportPositions;
    protected List<String> singleTypeImports;
    protected String sourceName;
    protected Position sourcePos;
    protected Package pkg;
    protected static final Named NOT_FOUND = new Named(){

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public TypeSystem typeSystem() {
            return null;
        }

        @Override
        public Position position() {
            return null;
        }

        @Override
        public boolean equalsImpl(TypeObject t) {
            return false;
        }

        @Override
        public TypeObject copy() {
            return null;
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public String fullName() {
            return null;
        }
    };
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver", "imports");

    public ImportTable(TypeSystem ts, Package pkg) {
        this(ts, pkg, null);
    }

    public ImportTable(TypeSystem ts, Package pkg, String src) {
        this.ts = ts;
        this.sourceName = src;
        this.sourcePos = src != null ? new Position(null, src) : null;
        this.pkg = pkg;
        this.map = new HashMap<String, Named>();
        this.typeOnDemandImports = new ArrayList<String>();
        this.lazyImports = new ArrayList<String>();
        this.lazyImportPositions = new ArrayList<Position>();
        this.singleTypeImports = new ArrayList<String>();
    }

    public Package package_() {
        return this.pkg;
    }

    public void addClassImport(String className) {
        this.addClassImport(className, null);
    }

    public void addClassImport(String className, Position pos) {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ": lazy import " + className);
        }
        this.lazyImports.add(className);
        this.lazyImportPositions.add(pos);
        this.singleTypeImports.add(className);
    }

    public void addTypeOnDemandImport(String pkgOrTypeName, Position pos) {
        this.addTypeOnDemandImport(pkgOrTypeName);
    }

    public void addTypeOnDemandImport(String pkgOrTypeName) {
        if (this.pkg != null && this.pkg.fullName().equals(pkgOrTypeName) || this.ts.defaultPackageImports().contains(pkgOrTypeName) || this.typeOnDemandImports.contains(pkgOrTypeName)) {
            return;
        }
        this.typeOnDemandImports.add(pkgOrTypeName);
    }

    public List<String> typeOnDemandImports() {
        return this.typeOnDemandImports;
    }

    public List<String> singleTypeImports() {
        return this.singleTypeImports;
    }

    public String sourceName() {
        return this.sourceName;
    }

    protected Named cachedFind(String name) throws SemanticException {
        Named res = this.map.get(name);
        if (res != null) {
            return res;
        }
        Named t = this.ts.systemResolver().find(name);
        this.map.put(name, t);
        return t;
    }

    @Override
    public Named find(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ".find(" + name + ")");
        }
        this.lazyImport();
        if (!StringUtil.isNameShort(name)) {
            return this.ts.systemResolver().find(name);
        }
        Named res = this.map.get(name);
        if (res != null) {
            if (res == NOT_FOUND) {
                throw new NoClassException(name, this.sourcePos);
            }
            return res;
        }
        res = this.findInPkgOrType(name, this.pkg == null ? "" : this.pkg.fullName());
        if (res != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, this + ".find(" + name + "): found in current package");
            }
            this.map.put(name, res);
            return res;
        }
        try {
            ArrayList<String> imports = new ArrayList<String>(this.typeOnDemandImports.size() + 5);
            imports.addAll(this.ts.defaultPackageImports());
            imports.addAll(this.typeOnDemandImports);
            Named resolved = null;
            for (String pkgOrTypeName : imports) {
                Named n = this.findInPkgOrType(name, pkgOrTypeName);
                if (n == null) continue;
                if (resolved == null) {
                    resolved = n;
                    continue;
                }
                throw new SemanticException("Reference to \"" + name + "\" is ambiguous; both " + resolved.fullName() + " and " + n.fullName() + " match.");
            }
            if (resolved == null && !this.isVisibleFrom(resolved = this.ts.systemResolver().find(name), "")) {
                throw new NoClassException(name, this.sourcePos);
            }
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, this + ".find(" + name + "): found as " + resolved.fullName());
            }
            this.map.put(name, resolved);
            return resolved;
        }
        catch (NoClassException e) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, this + ".find(" + name + "): didn't find it");
            }
            this.map.put(name, NOT_FOUND);
            throw e;
        }
    }

    protected Named findInPkgOrType(String name, String pkgOrTypeName) throws SemanticException {
        String separator;
        String actualPkg;
        if (!this.ts.packageExists(pkgOrTypeName)) {
            this.ts.systemResolver().find(pkgOrTypeName);
            actualPkg = StringUtil.getPackageComponent(pkgOrTypeName);
            separator = "$";
        } else {
            actualPkg = pkgOrTypeName;
            separator = ".";
        }
        String fullName = pkgOrTypeName.length() == 0 ? name : pkgOrTypeName + separator + name;
        try {
            Named n = this.ts.systemResolver().find(fullName);
            if (this.isVisibleFrom(n, actualPkg)) {
                return n;
            }
        }
        catch (NoClassException ex) {
            // empty catch block
        }
        return null;
    }

    protected boolean isVisibleFrom(Named n, String pkgName) {
        Type t;
        boolean inSamePackage;
        boolean isVisible = false;
        boolean bl = inSamePackage = this.pkg != null && this.pkg.fullName().equals(pkgName) || this.pkg == null && pkgName.equals("");
        isVisible = n instanceof Type ? !(t = (Type)((Object)n)).isClass() || t.toClass().flags().isPublic() || inSamePackage : true;
        return isVisible;
    }

    protected void lazyImport() throws SemanticException {
        if (this.lazyImports.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.lazyImports.size(); ++i) {
            String longName = this.lazyImports.get(i);
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, this + ": import " + longName);
            }
            try {
                this.lazyImportLongName(longName);
                continue;
            }
            catch (SemanticException e) {
                if (e.position == null) {
                    e.position = this.lazyImportPositions.get(i);
                }
                if (e.position == null) {
                    e.position = this.sourcePos;
                }
                throw e;
            }
        }
        this.lazyImports = new ArrayList<String>();
        this.lazyImportPositions = new ArrayList<Position>();
    }

    protected void lazyImportLongName(String longName) throws SemanticException {
        try {
            Named t = this.ts.systemResolver().find(longName);
            String shortName = StringUtil.getShortNameComponent(longName);
            this.map.put(shortName, t);
            return;
        }
        catch (NoClassException noClassException) {
            this.lazyImportLongNameStaticMember(longName);
            return;
        }
    }

    protected void lazyImportLongNameStaticMember(String longName) throws SemanticException {
        Named s;
        StringTokenizer st = new StringTokenizer(longName, ".");
        StringBuffer name = new StringBuffer();
        Named t = null;
        while (st.hasMoreTokens()) {
            block10: {
                String s2 = st.nextToken();
                if (name.length() > 0) {
                    name.append(".");
                }
                name.append(s2);
                try {
                    t = this.cachedFind(name.toString());
                }
                catch (NoClassException e) {
                    if (st.hasMoreTokens()) break block10;
                    throw e;
                }
            }
            if (t == null) continue;
            if (!st.hasMoreTokens()) break;
            while (st.hasMoreTokens()) {
                String n = st.nextToken();
                if (t instanceof ClassType) {
                    ClassType ct = (ClassType)t;
                    if ((t = ct.resolver().find(n)) instanceof ClassType) continue;
                    throw new NoClassException(n, ct);
                }
                if (t instanceof Package) {
                    Package p = (Package)t;
                    if (!((t = p.resolver().find(n)) instanceof ClassType)) continue;
                }
                throw new InternalCompilerError("Qualified type \"" + t + "\" is not a class type.", this.sourcePos);
            }
        }
        if (t == null) {
            this.cachedFind(longName);
        }
        String shortName = StringUtil.getShortNameComponent(longName);
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ": import " + shortName + " as " + t);
        }
        if (this.map.containsKey(shortName) && !this.ts.equals(s = this.map.get(shortName), t)) {
            throw new SemanticException("Class " + shortName + " already defined as " + this.map.get(shortName), this.sourcePos);
        }
        this.map.put(shortName, t);
    }

    public String toString() {
        if (this.sourceName != null) {
            return "(import " + this.sourceName + ")";
        }
        return "(import)";
    }
}

