/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.ClassType;
import polyglot.types.LazyClassInitializer;
import polyglot.types.ParsedClassType;
import polyglot.types.TypeSystem;

public class DeserializedClassInitializer
implements LazyClassInitializer {
    protected TypeSystem ts;
    protected ParsedClassType ct;
    protected boolean init;

    public DeserializedClassInitializer(TypeSystem ts) {
        this.ts = ts;
    }

    @Override
    public void setClass(ParsedClassType ct) {
        this.ct = ct;
    }

    @Override
    public boolean fromClassFile() {
        return false;
    }

    @Override
    public void initTypeObject() {
        if (this.init) {
            return;
        }
        if (this.ct.isMember() && this.ct.outer() instanceof ParsedClassType) {
            ParsedClassType outer = (ParsedClassType)this.ct.outer();
            outer.addMemberClass(this.ct);
        }
        for (ClassType classType : this.ct.memberClasses()) {
            ((ParsedClassType)classType).initializer().initTypeObject();
        }
        this.init = true;
    }

    @Override
    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    @Override
    public void initSuperclass() {
    }

    @Override
    public void initInterfaces() {
    }

    @Override
    public void initMemberClasses() {
    }

    @Override
    public void initConstructors() {
    }

    @Override
    public void initMethods() {
    }

    @Override
    public void initFields() {
    }

    @Override
    public void canonicalConstructors() {
    }

    @Override
    public void canonicalMethods() {
    }

    @Override
    public void canonicalFields() {
    }
}

