/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import polyglot.main.Report;
import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassType;
import polyglot.types.MemberInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class ClassContextResolver
extends AbstractAccessControlResolver {
    protected ClassType type;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver");

    public ClassContextResolver(TypeSystem ts, ClassType type) {
        super(ts);
        this.type = type;
    }

    public String toString() {
        return "(class-context " + this.type + ")";
    }

    @Override
    public Named find(String name, ClassType accessor) throws SemanticException {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Looking for " + name + " in " + this);
        }
        if (!StringUtil.isNameShort(name)) {
            throw new InternalCompilerError("Cannot lookup qualified name " + name);
        }
        LinkedList<ClassType> typeQueue = new LinkedList<ClassType>();
        typeQueue.addLast(this.type);
        HashSet<ClassType> acceptable = new HashSet<ClassType>();
        SemanticException error = null;
        while (!typeQueue.isEmpty()) {
            Type type;
            ClassType type2 = (ClassType)typeQueue.removeFirst();
            ClassType m = type2.memberClassNamed(name);
            if (m instanceof MemberInstance) {
                if (!this.ts.isMember(m, this.type)) {
                    if (error != null) continue;
                    error = new SemanticException("Member class " + m + " is not visible in class " + this.type);
                    continue;
                }
                if (!this.canAccess(m, accessor)) {
                    acceptable.add(m);
                    if (error != null) continue;
                    error = new SemanticException("Cannot access member type \"" + m + "\" from class " + accessor + ".");
                    continue;
                }
                acceptable.add(m);
                continue;
            }
            if (type2.superType() != null && (type = type2.superType()) instanceof ClassType) {
                ClassType classType = (ClassType)type;
                typeQueue.addLast(classType);
            }
            for (Type type3 : type2.interfaces()) {
                if (!(type3 instanceof ClassType)) continue;
                ClassType ct = (ClassType)type3;
                typeQueue.addLast(ct);
            }
        }
        if (acceptable.size() == 0) {
            throw error == null ? new NoClassException(name, this.type) : error;
        }
        if (acceptable.size() > 1) {
            HashSet<ReferenceType> containers = new HashSet<ReferenceType>(acceptable.size());
            for (Named named : acceptable) {
                if (!(named instanceof MemberInstance)) continue;
                MemberInstance memberInstance = (MemberInstance)((Object)named);
                containers.add(memberInstance.container());
            }
            if (containers.size() == 2) {
                Iterator i = containers.iterator();
                Type type = (Type)i.next();
                Type type4 = (Type)i.next();
                throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in both " + type + " and " + type4 + ".");
            }
            throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in " + containers + ".");
        }
        Named m = (Named)acceptable.iterator().next();
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Found member class " + m);
        }
        return m;
    }

    protected boolean canAccess(Named n, ClassType accessor) {
        if (n instanceof MemberInstance) {
            return accessor == null || this.ts.isAccessible((MemberInstance)((Object)n), ((MemberInstance)((Object)n)).container(), accessor);
        }
        return true;
    }

    public ClassType classType() {
        return this.type;
    }
}

