/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;

public class CachingResolver
implements Resolver,
Copy<CachingResolver> {
    protected Resolver inner;
    private Map<String, CachedResult> cache;
    private boolean cacheNotFound;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver");

    public CachingResolver(Resolver inner, boolean cacheNotFound) {
        this.inner = inner;
        this.cacheNotFound = cacheNotFound;
        this.cache = new HashMap<String, CachedResult>();
    }

    public CachingResolver(Resolver inner) {
        this(inner, true);
    }

    protected boolean shouldReport(int level) {
        return Report.should_report("sysresolver", level) && this instanceof SystemResolver || Report.should_report(TOPICS, level);
    }

    @Override
    public CachingResolver copy() {
        try {
            CachingResolver r = (CachingResolver)super.clone();
            r.cache = new HashMap<String, CachedResult>(this.cache);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("clone failed");
        }
    }

    public Resolver inner() {
        return this.inner;
    }

    public String toString() {
        return "(cache " + this.inner.toString() + ")";
    }

    protected Collection<CachedResult> cachedResults() {
        return this.cache.values();
    }

    @Override
    public Named find(String name) throws SemanticException {
        Named q;
        CachedResult cached;
        if (this.shouldReport(2)) {
            Report.report(2, "CachingResolver: find: " + name);
        }
        if ((cached = this.cache.get(name)) instanceof CachedResult.Error) {
            throw ((CachedResult.Error)cached).exc;
        }
        Named named = q = cached == null ? null : ((CachedResult.Success)cached).named;
        if (q == null) {
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: not cached: " + name);
            }
            try {
                q = this.inner.find(name);
            }
            catch (NoClassException e) {
                if (this.shouldReport(3)) {
                    Report.report(3, "CachingResolver: " + e.getMessage());
                    Report.report(3, "CachingResolver: installing " + name + "-> (not found) in resolver cache");
                }
                if (this.cacheNotFound) {
                    this.cache.put(name, new CachedResult.Error(e));
                }
                throw e;
            }
            this.addNamed(name, q);
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: loaded: " + name);
            }
        } else if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: cached: " + name);
        }
        return q;
    }

    public Named check(String name) {
        CachedResult cached = this.cache.get(name);
        if (!(cached instanceof CachedResult.Success)) {
            return null;
        }
        return ((CachedResult.Success)cached).named;
    }

    public void install(String name, Named q) {
        if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: installing " + name + "->" + q + " in resolver cache");
        }
        if (this.shouldReport(5)) {
            new Exception().printStackTrace();
        }
        this.cache.put(name, new CachedResult.Success(q));
    }

    public void addNamed(String name, Named q) throws SemanticException {
        this.install(name, q);
    }

    public void dump() {
        Report.report(1, "Dumping " + this);
        for (Map.Entry<String, CachedResult> e : this.cache.entrySet()) {
            Report.report(2, e.toString());
        }
    }

    protected static class CachedResult {
        protected CachedResult() {
        }

        protected static final class Error
        extends CachedResult {
            final NoClassException exc;

            Error(NoClassException exc) {
                this.exc = exc;
            }

            public String toString() {
                return this.exc.toString();
            }
        }

        protected static final class Success
        extends CachedResult {
            final Named named;

            Success(Named named) {
                this.named = named;
            }

            public String toString() {
                return this.named.toString();
            }
        }
    }
}

