/*
 * Decompiled with CFR 0.152.
 */
package polyglot.translate;

import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.qq.QQ;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class ExtensionRewriter
extends ContextVisitor {
    protected final ExtensionInfo from_ext;
    protected final ExtensionInfo to_ext;
    protected QQ qq;
    private final Lang lang;

    public ExtensionRewriter(Job job, ExtensionInfo from_ext, ExtensionInfo to_ext) {
        super(job, from_ext.typeSystem(), to_ext.nodeFactory());
        this.job = job;
        this.from_ext = from_ext;
        this.to_ext = to_ext;
        this.qq = new QQ(to_ext);
        this.rethrowMissingDependencies = true;
        this.lang = from_ext.nodeFactory().lang();
    }

    @Override
    public Lang lang() {
        return this.lang;
    }

    @Override
    public NodeVisitor enterCall(Node n) throws SemanticException {
        try {
            return this.lang().extRewriteEnter(n, this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return this;
        }
    }

    @Override
    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        try {
            return this.lang().extRewrite(n, this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return n;
        }
    }

    @Override
    protected void addDecls(Node old, Node n) {
        this.addDecls(old);
    }

    @Override
    public void finish(Node ast) {
        if (ast instanceof SourceCollection) {
            SourceCollection c = (SourceCollection)ast;
            for (SourceFile sf : c.sources()) {
                this.to_ext.scheduler().addJob(sf.source(), sf);
            }
        } else {
            this.to_ext.scheduler().addJob(this.job.source(), ast);
        }
    }

    public ExtensionInfo from_ext() {
        return this.from_ext;
    }

    public TypeSystem from_ts() {
        return this.from_ext.typeSystem();
    }

    public NodeFactory from_nf() {
        return this.from_ext.nodeFactory();
    }

    public ExtensionInfo to_ext() {
        return this.to_ext;
    }

    public TypeSystem to_ts() {
        return this.to_ext.typeSystem();
    }

    public NodeFactory to_nf() {
        return this.to_ext.nodeFactory();
    }

    @Override
    public ErrorQueue errorQueue() {
        return this.job.compiler().errorQueue();
    }

    public TypeNode typeToJava(Type t, Position pos) throws SemanticException {
        NodeFactory nf = this.to_nf();
        TypeSystem ts = this.to_ts();
        if (t.isNull()) {
            return this.canonical(nf, ts.Null(), pos);
        }
        if (t.isVoid()) {
            return this.canonical(nf, ts.Void(), pos);
        }
        if (t.isBoolean()) {
            return this.canonical(nf, ts.Boolean(), pos);
        }
        if (t.isByte()) {
            return this.canonical(nf, ts.Byte(), pos);
        }
        if (t.isChar()) {
            return this.canonical(nf, ts.Char(), pos);
        }
        if (t.isShort()) {
            return this.canonical(nf, ts.Short(), pos);
        }
        if (t.isInt()) {
            return this.canonical(nf, ts.Int(), pos);
        }
        if (t.isLong()) {
            return this.canonical(nf, ts.Long(), pos);
        }
        if (t.isFloat()) {
            return this.canonical(nf, ts.Float(), pos);
        }
        if (t.isDouble()) {
            return this.canonical(nf, ts.Double(), pos);
        }
        if (t.isArray()) {
            return nf.ArrayTypeNode(pos, this.typeToJava(t.toArray().base(), pos));
        }
        if (t.isClass()) {
            return nf.TypeNodeFromQualifiedName(pos, t.translate(this.context));
        }
        throw new InternalCompilerError("Cannot translate type " + t + ".");
    }

    protected TypeNode canonical(NodeFactory nf, Type t, Position pos) {
        return nf.CanonicalTypeNode(pos, t);
    }

    public QQ qq() {
        return this.qq;
    }
}

