/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import polyglot.filemanager.FileManager;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.main.UsageError;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.QuotedStringTokenizer;
import polyglot.util.SerialVersionUID;
import polyglot.util.StdErrorQueue;

public class Main {
    private Set<String> source;
    public static final String verbose = "verbose";
    private static final JavaCompiler javaCompiler = Main.javaCompiler();
    private static Collection<String> timeTopics = new ArrayList<String>(1);

    public static JavaCompiler javaCompiler() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new InternalCompilerError("Java compiler not found.  Does java that runs Polyglot have javac along with it?");
        }
        return compiler;
    }

    protected ExtensionInfo getExtensionInfo(List<String> args) throws TerminationException {
        ExtensionInfo ext = null;
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (s.equals("-ext") || s.equals("-extension")) {
                if (ext != null) {
                    throw new TerminationException("only one extension can be specified");
                }
                i.remove();
                if (!i.hasNext()) {
                    throw new TerminationException("missing argument");
                }
                String extName = i.next();
                i.remove();
                ext = Main.loadExtension("polyglot.ext." + extName + ".ExtensionInfo");
                continue;
            }
            if (!s.equals("-extclass")) continue;
            if (ext != null) {
                throw new TerminationException("only one extension can be specified");
            }
            i.remove();
            if (!i.hasNext()) {
                throw new TerminationException("missing argument");
            }
            String extClass = i.next();
            i.remove();
            ext = Main.loadExtension(extClass);
        }
        if (ext != null) {
            return ext;
        }
        return Main.loadExtension("polyglot.frontend.JLExtensionInfo");
    }

    public void start(String[] argv) throws TerminationException {
        this.start(argv, null, null);
    }

    public void start(String[] argv, ExtensionInfo ext) throws TerminationException {
        this.start(argv, ext, null);
    }

    public void start(String[] argv, ErrorQueue eq) throws TerminationException {
        this.start(argv, null, eq);
    }

    public void start(String[] argv, ExtensionInfo ext, ErrorQueue eq) throws TerminationException {
        Collection<JavaFileObject> outputFiles;
        Options options;
        this.source = new LinkedHashSet<String>();
        List<String> args = Main.explodeOptions(argv);
        if (ext == null) {
            ext = this.getExtensionInfo(args);
        }
        Options.global = options = ext.getOptions();
        try {
            argv = args.toArray(new String[0]);
            options.parseCommandLine(argv, this.source);
        }
        catch (UsageError ue) {
            PrintStream out;
            PrintStream printStream = out = ue.exitCode == 0 ? System.out : System.err;
            if (ue.getMessage() != null && ue.getMessage().length() > 0) {
                out.println(ext.compilerName() + ": " + ue.getMessage());
            }
            options.usage(out);
            throw new TerminationException(ue.exitCode);
        }
        if (eq == null) {
            eq = new StdErrorQueue(System.err, options.error_count, ext.compilerName());
        }
        Compiler compiler = new Compiler(ext, eq);
        long time0 = System.currentTimeMillis();
        if (!compiler.compileFiles(this.source)) {
            throw new TerminationException(1);
        }
        if (Report.should_report(verbose, 1)) {
            Report.report(1, "Output files: " + compiler.outputFiles());
        }
        if ((outputFiles = compiler.outputFiles()) == null || outputFiles.size() == 0) {
            return;
        }
        long start_time = System.currentTimeMillis();
        if (!this.invokePostCompiler(options, compiler, eq)) {
            throw new TerminationException(1);
        }
        if (Report.should_report(verbose, 1)) {
            Main.reportTime("Finished compiling Java output files. time=" + (System.currentTimeMillis() - start_time), 1);
            Main.reportTime("Total time=" + (System.currentTimeMillis() - time0), 1);
        }
    }

    protected List<String> getSystemJavacArgs(Options options) {
        ArrayList<String> postCompilerArgs;
        if (options.post_compiler_opts != null) {
            QuotedStringTokenizer st = new QuotedStringTokenizer(options.post_compiler_opts);
            int pc_size = st.countTokens();
            postCompilerArgs = new ArrayList(pc_size + 1);
            while (st.hasMoreTokens()) {
                postCompilerArgs.add(st.nextToken());
            }
        } else {
            postCompilerArgs = new ArrayList<String>(1);
        }
        if (options.generate_debugging_info) {
            postCompilerArgs.add("-g");
        }
        return postCompilerArgs;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean invokePostCompiler(Options options, Compiler compiler, ErrorQueue eq) {
        block34: {
            if (!options.output_source_only && !options.output_stdout) {
                try {
                    String[] javacCmd;
                    if (options.post_compiler == null) {
                        List<String> postCompilerArgs = this.getSystemJavacArgs(options);
                        ByteArrayOutputStream err = new ByteArrayOutputStream();
                        OutputStreamWriter javac_err = new OutputStreamWriter(err);
                        compiler.sourceExtension().configureFileManagerForPostCompiler();
                        FileManager fileManager = compiler.sourceExtension().extFileManager();
                        JavaCompiler.CompilationTask task = javaCompiler.getTask(javac_err, fileManager, null, postCompilerArgs, null, compiler.outputFiles());
                        task.call();
                        String error = err.toString();
                        if (!error.isEmpty()) {
                            eq.enqueue(6, error);
                        }
                        break block34;
                    }
                    int options_size = 3;
                    if (options.classOutputLocation() != null) {
                        options_size += 2;
                    }
                    if (options.generate_debugging_info) {
                        ++options_size;
                    }
                    int j = 0;
                    if (options.post_compiler_opts != null) {
                        QuotedStringTokenizer st = new QuotedStringTokenizer(options.post_compiler_opts);
                        javacCmd = new String[st.countTokens() + options_size + compiler.outputFiles().size()];
                        javacCmd[j++] = options.post_compiler;
                        while (st.hasMoreTokens()) {
                            javacCmd[j++] = st.nextToken();
                        }
                    } else {
                        javacCmd = new String[options_size + compiler.outputFiles().size()];
                        javacCmd[j++] = options.post_compiler;
                    }
                    javacCmd[j++] = "-classpath";
                    javacCmd[j++] = options.constructPostCompilerClasspath();
                    if (options.classOutputLocation() != null) {
                        javacCmd[j++] = "-d";
                        javacCmd[j++] = options.classOutputDirectory().getPath();
                    }
                    if (options.generate_debugging_info) {
                        javacCmd[j++] = "-g";
                    }
                    for (JavaFileObject jfo : compiler.outputFiles()) {
                        void var10_19;
                        URI jfoURI = jfo.toUri();
                        if (!jfoURI.isAbsolute()) {
                            File file = new File(jfoURI.getPath());
                        } else {
                            File file = new File(jfoURI);
                        }
                        javacCmd[j++] = var10_19.getAbsolutePath();
                    }
                    if (Report.should_report(verbose, 1)) {
                        void var10_23;
                        StringBuffer cmdStr = new StringBuffer();
                        String[] arr$ = javacCmd;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var10_23 < len$) {
                            String element = arr$[var10_23];
                            cmdStr.append(element + " ");
                            ++var10_23;
                        }
                        Report.report(1, "Executing post-compiler " + cmdStr);
                    }
                    Runtime runtime = Runtime.getRuntime();
                    Process proc = runtime.exec(javacCmd);
                    Throwable throwable = null;
                    try (InputStreamReader err = new InputStreamReader(proc.getErrorStream());){
                        int len;
                        char[] c = new char[72];
                        StringBuffer sb = new StringBuffer();
                        while ((len = err.read(c)) > 0) {
                            sb.append(String.valueOf(c, 0, len));
                        }
                        if (sb.length() != 0) {
                            eq.enqueue(6, sb.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    proc.waitFor();
                    if (!options.keep_output_files) {
                        for (FileObject fileObject : compiler.outputFiles()) {
                            fileObject.delete();
                        }
                    }
                    if (proc.exitValue() > 0) {
                        eq.enqueue(6, "Non-zero return code: " + proc.exitValue());
                        return false;
                    }
                }
                catch (Exception e) {
                    eq.enqueue(6, e.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    private static List<String> explodeOptions(String[] args) throws TerminationException {
        LinkedList<String> ll = new LinkedList<String>();
        for (String arg : args) {
            if (arg.startsWith("@")) {
                String fn = arg.substring(1);
                try (BufferedReader lr = new BufferedReader(new FileReader(fn));){
                    String l;
                    LinkedList<String> newArgs = new LinkedList<String>();
                    while ((l = lr.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(l, " ");
                        while (st.hasMoreTokens()) {
                            newArgs.add(st.nextToken());
                        }
                    }
                    ll.addAll(newArgs);
                    continue;
                }
                catch (IOException e) {
                    throw new TerminationException("cmdline parser: couldn't read args file " + fn);
                }
            }
            ll.add(arg);
        }
        return ll;
    }

    public static void main(String[] args) {
        try {
            new Main().start(args);
        }
        catch (TerminationException te) {
            if (te.getMessage() != null) {
                (te.exitCode == 0 ? System.out : System.err).println(te.getMessage());
            }
            System.exit(te.exitCode);
        }
    }

    static ExtensionInfo loadExtension(String ext) throws TerminationException {
        if (ext != null && !ext.equals("")) {
            Object extobj;
            Class<?> extClass = null;
            try {
                extClass = Class.forName(ext);
            }
            catch (ClassNotFoundException e) {
                throw new TerminationException("Extension " + ext + " not found: could not find class " + ext + ".");
            }
            try {
                extobj = extClass.newInstance();
            }
            catch (Exception e) {
                throw new InternalCompilerError("Extension " + ext + " could not be loaded: could not instantiate " + ext + ".", e);
            }
            try {
                return (ExtensionInfo)extobj;
            }
            catch (ClassCastException e) {
                throw new TerminationException(ext + " is not a valid Polyglot extension:" + " extension class " + ext + " exists but is not a subclass of ExtensionInfo.");
            }
        }
        return null;
    }

    private static void reportTime(String msg, int level) {
        Report.report(level, msg);
    }

    static {
        timeTopics.add("time");
    }

    public static class TerminationException
    extends RuntimeException {
        private static final long serialVersionUID = SerialVersionUID.generate();
        public final int exitCode;

        public TerminationException(String msg) {
            this(msg, 1);
        }

        public TerminationException(int exit) {
            this.exitCode = exit;
        }

        public TerminationException(String msg, int exit) {
            super(msg);
            this.exitCode = exit;
        }
    }
}

