/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.util.StringUtil;

public abstract class AbstractGoal
implements Goal {
    protected Job job;
    protected String name;
    protected int state = 0;
    protected Set<Goal> corequisites;
    protected Set<Goal> prerequisites = Collections.emptySet();

    private AbstractGoal() {
        this.corequisites = Collections.emptySet();
    }

    protected AbstractGoal(Job job) {
        this();
        this.job = job;
        this.name = StringUtil.getShortNameComponent(this.getClass().getName());
    }

    protected AbstractGoal(Job job, String name) {
        this();
        this.job = job;
        this.name = name;
    }

    @Override
    public boolean conflictsWith(Goal goal) {
        return this.job() != null && this.job() == goal.job();
    }

    @Override
    public abstract Pass createPass(ExtensionInfo var1);

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Job job() {
        return this.job;
    }

    @Override
    public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
        return this.prerequisites;
    }

    @Override
    public Collection<Goal> corequisiteGoals(Scheduler scheduler) {
        return this.corequisites;
    }

    @Override
    public void addPrerequisiteGoal(Goal g, Scheduler scheduler) throws CyclicDependencyException {
        if (this.prerequisites == Collections.EMPTY_SET) {
            this.prerequisites = new LinkedHashSet<Goal>();
        }
        this.prerequisites.add(g);
    }

    protected void checkCycles(Goal current, Scheduler scheduler) throws CyclicDependencyException {
        if (this == current) {
            throw new CyclicDependencyException("Goal " + this + " cannot depend on itself.");
        }
        for (Goal subgoal : current.prerequisiteGoals(scheduler)) {
            this.checkCycles(subgoal, scheduler);
        }
    }

    @Override
    public void addCorequisiteGoal(Goal g, Scheduler scheduler) {
        if (this.corequisites == Collections.EMPTY_SET) {
            this.corequisites = new LinkedHashSet<Goal>();
        }
        this.corequisites.add(g);
    }

    @Override
    public void setUnreachableThisRun() {
        this.setState(-2);
    }

    @Override
    public int state() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public boolean hasBeenReached() {
        return this.state == 2;
    }

    @Override
    public void setUnreachable() {
        this.setState(-1);
    }

    @Override
    public boolean isReachable() {
        return this.state != -1;
    }

    public int hashCode() {
        return (this.job != null ? this.job.hashCode() : 0) + this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Goal) {
            Goal g = (Goal)o;
            if (this.job == null) {
                return g.job() == null && this.name.equals(g.name());
            }
            return this.job.equals(g.job()) && this.name.equals(g.name());
        }
        return false;
    }

    protected String stateString() {
        switch (this.state) {
            case -1: {
                return "unreachable";
            }
            case -2: {
                return "running-but-unreachable-this-run";
            }
            case 0: {
                return "unreached";
            }
            case 1: {
                return "attempted";
            }
            case 2: {
                return "reached";
            }
            case 3: {
                return "running";
            }
        }
        return "unknown-goal-state";
    }

    public String toString() {
        return this.job + ":" + (this.job != null ? this.job.extensionInfo() + ":" : "") + this.name + " (" + this.stateString() + ")";
    }
}

