/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Pass;
import polyglot.frontend.SchedulerException;
import polyglot.frontend.Source;
import polyglot.frontend.Stats;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.EndGoal;
import polyglot.frontend.goals.Goal;
import polyglot.main.Main;
import polyglot.main.Report;
import polyglot.types.FieldInstance;
import polyglot.types.ParsedClassType;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public abstract class Scheduler {
    protected ExtensionInfo extInfo;
    protected Set<Goal> inWorklist;
    protected LinkedList<Goal> worklist;
    protected Map<Source, Job> jobs;
    protected Collection<Job> commandLineJobs;
    protected Map<Goal, Goal> goals;
    protected Map<Goal, Integer> runCount;
    protected boolean failed;
    protected Pass currentPass;
    protected static int dumpCounter = 0;
    protected static final int MAX_RUN_COUNT = 200;
    protected Goal infiniteLoopGoal = null;

    public Scheduler(ExtensionInfo extInfo) {
        this.extInfo = extInfo;
        this.jobs = new LinkedHashMap<Source, Job>();
        this.goals = new LinkedHashMap<Goal, Goal>();
        this.runCount = new LinkedHashMap<Goal, Integer>();
        this.inWorklist = new LinkedHashSet<Goal>();
        this.worklist = new LinkedList();
        this.currentPass = null;
    }

    public Collection<Job> commandLineJobs() {
        return this.commandLineJobs;
    }

    public void setCommandLineJobs(Collection<Job> c) {
        this.commandLineJobs = Collections.unmodifiableCollection(c);
    }

    public boolean prerequisiteDependsOn(Goal goal, Goal subgoal) {
        if (goal == subgoal) {
            return true;
        }
        for (Goal g : goal.prerequisiteGoals(this)) {
            if (!this.prerequisiteDependsOn(g, subgoal)) continue;
            return true;
        }
        return false;
    }

    public void addCorequisiteDependency(Goal goal, Goal subgoal) {
        if (!goal.corequisiteGoals(this).contains(subgoal)) {
            if (Report.should_report("frontend", 3) || Report.should_report("deps", 1)) {
                Report.report(3, "Adding coreq edge: " + subgoal + " -> " + goal);
            }
            goal.addCorequisiteGoal(subgoal, this);
        }
    }

    public void addCorequisiteDependencyAndEnqueue(Goal goal, Goal subgoal) {
        this.addCorequisiteDependency(goal, subgoal);
    }

    public void addDependencyAndEnqueue(Goal goal, Goal subgoal, boolean prerequisite) {
        if (prerequisite) {
            try {
                this.addPrerequisiteDependency(goal, subgoal);
            }
            catch (CyclicDependencyException e) {
                throw new InternalCompilerError(e);
            }
        } else {
            this.addCorequisiteDependency(goal, subgoal);
        }
    }

    public void addPrerequisiteDependency(Goal goal, Goal subgoal) throws CyclicDependencyException {
        if (!goal.prerequisiteGoals(this).contains(subgoal)) {
            if (Report.should_report("frontend", 3) || Report.should_report("deps", 1)) {
                Report.report(3, "Adding prereq edge: " + subgoal + " => " + goal);
            }
            goal.addPrerequisiteGoal(subgoal, this);
        }
    }

    public void addPrerequisiteDependencyChain(List<Goal> deps) throws CyclicDependencyException {
        Goal prev = null;
        for (Goal curr : deps) {
            if (prev != null) {
                this.addPrerequisiteDependency(curr, prev);
            }
            prev = curr;
        }
    }

    public synchronized Goal internGoal(Goal goal) {
        Goal g = this.goals.get(goal);
        if (g == null) {
            g = goal;
            this.goals.put(g, g);
            if (Report.should_report("frontend", 4)) {
                Report.report(4, "new goal " + g);
            }
            if (Report.should_report("frontend", 5)) {
                Report.report(5, "goals = " + this.goals.keySet());
            }
        }
        return g;
    }

    public void addGoal(Goal goal) {
        if (!this.inWorklist.contains(goal)) {
            this.inWorklist.add(goal);
            this.worklist.add(goal);
        }
    }

    public boolean reached(Goal g) {
        return g.hasBeenReached();
    }

    protected void completeJob(Job job) {
        if (job != null) {
            this.jobs.put(job.source(), Job.COMPLETED);
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Completed job " + job);
            }
        }
    }

    protected List<Goal> worklist() {
        return this.worklist;
    }

    public boolean runToCompletion() {
        Goal theEnd = this.internGoal(new TheEndGoal(this));
        boolean okay = true;
        while (okay && !this.reached(theEnd)) {
            okay = this.attemptGoal(theEnd);
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished all passes for " + this.getClass().getName() + " -- " + (okay ? "okay" : "failed"));
        }
        return okay;
    }

    public Job loadSource(FileSource source, boolean compile) {
        Job job = this.addJob(source);
        if (job == null) {
            return null;
        }
        Goal compileGoal = this.extInfo.getCompileGoal(job);
        if (compile) {
            this.addGoal(compileGoal);
        }
        return job;
    }

    public boolean sourceHasJob(Source s) {
        return this.jobs.get(s) != null;
    }

    public Job currentJob() {
        return this.currentPass != null ? this.currentPass.goal().job() : null;
    }

    public Pass currentPass() {
        return this.currentPass;
    }

    public Goal currentGoal() {
        return this.currentPass != null ? this.currentPass.goal() : null;
    }

    public boolean attemptGoal(Goal goal) {
        return this.attemptGoal(goal, new LinkedHashSet<Goal>());
    }

    protected boolean attemptGoal(Goal goal, Set<Goal> above) {
        if (Report.should_report("dump-dep-graph", 2)) {
            this.dumpInFlightDependenceGraph();
        }
        if (Report.should_report("frontend", 2)) {
            Report.report(2, "Running to goal " + goal);
        }
        if (Report.should_report("frontend", 4)) {
            Report.report(4, "  Reachable = " + goal.isReachable());
            Report.report(4, "  Prerequisites for " + goal + " = " + goal.prerequisiteGoals(this));
            Report.report(4, "  Corequisites for " + goal + " = " + goal.corequisiteGoals(this));
        }
        if (above.contains(goal)) {
            if (Report.should_report("frontend", 4)) {
                Report.report(4, goal + " is being attempted by a caller; returning");
            }
            return true;
        }
        boolean progress = true;
        LinkedHashSet<Goal> newAbove = new LinkedHashSet<Goal>();
        newAbove.addAll(above);
        newAbove.add(goal);
        while (progress && !this.reached(goal)) {
            boolean result;
            progress = false;
            if (Report.should_report("frontend", 4)) {
                Report.report(4, "outer loop for " + goal);
            }
            for (Goal subgoal : new ArrayList<Goal>(goal.prerequisiteGoals(this))) {
                if (this.reached(subgoal)) continue;
                if (Report.should_report("frontend", 4)) {
                    Report.report(4, "running prereq: " + subgoal + "->" + goal);
                }
                if (!this.attemptGoal(subgoal, newAbove)) {
                    return false;
                }
                if (!this.reached(goal)) continue;
                return true;
            }
            boolean runPass = true;
            for (Goal subgoal : goal.prerequisiteGoals(this)) {
                if (this.reached(subgoal)) continue;
                runPass = false;
            }
            if (!runPass) {
                return true;
            }
            if (Report.should_report("frontend", 4)) {
                Report.report(4, "running goal " + goal);
            }
            if (!(result = this.runGoal(goal))) {
                return false;
            }
            if (this.reached(goal)) {
                if (goal instanceof EndGoal) {
                    this.completeJob(goal.job());
                }
                return true;
            }
            for (Goal subgoal : new ArrayList<Goal>(goal.corequisiteGoals(this))) {
                if (this.reached(subgoal)) continue;
                if (Report.should_report("frontend", 4)) {
                    Report.report(4, "running coreq: " + subgoal + "->" + goal);
                }
                if (!this.attemptGoal(subgoal, newAbove)) {
                    return false;
                }
                if (this.reached(subgoal)) {
                    progress = true;
                }
                if (!this.reached(goal)) continue;
                return true;
            }
        }
        return true;
    }

    protected boolean runGoal(Goal goal) {
        if (this.reached(goal)) {
            if (Report.should_report("frontend", 3)) {
                Report.report(3, "Already reached goal " + goal);
            }
            return true;
        }
        if (!goal.isReachable()) {
            if (Report.should_report("frontend", 3)) {
                Report.report(3, "Cannot reach goal " + goal);
            }
            return false;
        }
        Pass pass = goal.createPass(this.extInfo);
        return this.runPass(pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runPass(Pass pass) {
        Goal goal = pass.goal();
        Job job = goal.job();
        if (this.extInfo.getOptions().disable_passes.contains(pass.name())) {
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Skipping pass " + pass);
            }
            goal.setState(2);
            return true;
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Running pass " + pass + " for " + goal);
        }
        if (this.reached(goal)) {
            throw new InternalCompilerError("Cannot run a pass for completed goal " + goal);
        }
        Integer countObj = this.runCount.get(goal);
        int count = countObj != null ? countObj : 0;
        this.runCount.put(goal, ++count);
        if (count >= 200) {
            String[] suffix = new String[]{"th", "st", "nd", "rd"};
            int index = count % 10;
            if (index > 3) {
                index = 0;
            }
            if (11 <= count && count <= 13) {
                index = 0;
            }
            String cardinal = count + suffix[index];
            String message = "Possible infinite loop detected trying to run a pass for " + goal + " for the " + cardinal + " time.";
            ErrorQueue eq = this.extInfo.compiler().errorQueue();
            if (goal.equals(this.infiniteLoopGoal)) {
                if (Report.should_report("dump-dep-graph", 1)) {
                    this.dumpInFlightDependenceGraph();
                }
                if (Report.should_report("dump-dep-graph", 1)) {
                    this.dumpDependenceGraph();
                }
                eq.enqueue(1, message + "  Aborting.");
                throw new Main.TerminationException(1);
            }
            if (this.infiniteLoopGoal == null) {
                this.infiniteLoopGoal = goal;
                Report.addTopic("frontend", 4);
                Report.addTopic("deps", 1);
                eq.enqueue(7, message + "  The compiler will attempt the goal one more time with reporting enabled, then abort.");
            }
        }
        pass.resetTimers();
        boolean result = false;
        if (job == null || job.status()) {
            Pass oldPass = this.currentPass;
            this.currentPass = pass;
            Report.pushTopic(pass.name());
            if (oldPass != null) {
                oldPass.toggleTimers(true);
            }
            if (job != null) {
                job.setRunningPass(pass);
            }
            pass.toggleTimers(false);
            goal.setState(3);
            long t = System.currentTimeMillis();
            String key = goal.toString();
            this.extInfo.getStats().accumPassTimes(key + " attempts", 1L, 1L);
            this.extInfo.getStats().accumPassTimes("total goal attempts", 1L, 1L);
            try {
                result = pass.run();
                if (!result) {
                    this.extInfo.getStats().accumPassTimes(key + " failures", 1L, 1L);
                    this.extInfo.getStats().accumPassTimes("total goal failures", 1L, 1L);
                    goal.setState(-1);
                    if (Report.should_report("frontend", 1)) {
                        Report.report(1, "Failed pass " + pass + " for " + goal);
                    }
                } else if (goal.state() == 3) {
                    this.extInfo.getStats().accumPassTimes(key + " reached", 1L, 1L);
                    this.extInfo.getStats().accumPassTimes("total goal reached", 1L, 1L);
                    goal.setState(2);
                    if (Report.should_report("frontend", 1)) {
                        Report.report(1, "Completed pass " + pass + " for " + goal);
                    }
                } else {
                    this.extInfo.getStats().accumPassTimes(key + " unreached", 1L, 1L);
                    this.extInfo.getStats().accumPassTimes("total goal unreached", 1L, 1L);
                    goal.setState(1);
                    if (Report.should_report("frontend", 1)) {
                        Report.report(1, "Completed (unreached) pass " + pass + " for " + goal);
                    }
                }
            }
            catch (MissingDependencyException e) {
                if (Report.should_report("frontend", 1)) {
                    Report.report(1, "Did not complete pass " + pass + " for " + goal + " (missing " + e.goal() + ")");
                }
                if (Report.should_report("frontend", 3)) {
                    e.printStackTrace();
                }
                this.extInfo.getStats().accumPassTimes(key + " aborts", 1L, 1L);
                this.extInfo.getStats().accumPassTimes("total goal aborts", 1L, 1L);
                this.addDependencyAndEnqueue(goal, e.goal(), e.prerequisite());
                goal.setState(1);
                result = true;
            }
            catch (SchedulerException e) {
                if (Report.should_report("frontend", 1)) {
                    Report.report(1, "Did not complete pass " + pass + " for " + goal);
                }
                this.extInfo.getStats().accumPassTimes(key + " aborts", 1L, 1L);
                this.extInfo.getStats().accumPassTimes("goal aborts", 1L, 1L);
                goal.setState(1);
                result = true;
            }
            finally {
                t = System.currentTimeMillis() - t;
                this.extInfo.getStats().accumPassTimes(key, t, t);
                pass.toggleTimers(false);
                if (job != null) {
                    job.setRunningPass(null);
                }
                Report.popTopic();
                this.currentPass = oldPass;
                if (oldPass != null) {
                    oldPass.toggleTimers(true);
                }
            }
            if (job != null && this.extInfo.getOptions().print_ast.contains(pass.name())) {
                System.err.println("----------------------------------------------------------------");
                System.err.println("Pretty-printing AST for " + job + " after " + pass.name());
                this.extInfo.nodeFactory().lang().prettyPrint(job.ast(), (Lang)this.extInfo.nodeFactory().lang(), System.err);
            }
            if (job != null && this.extInfo.getOptions().dump_ast.contains(pass.name())) {
                System.err.println("----------------------------------------------------------------");
                System.err.println("Dumping AST for " + job + " after " + pass.name());
                this.extInfo.nodeFactory().lang().dump(job.ast(), (Lang)this.extInfo.nodeFactory().lang(), System.err);
            }
        }
        Stats stats = this.extInfo.getStats();
        stats.accumPassTimes(pass.name(), pass.inclusiveTime(), pass.exclusiveTime());
        if (!result) {
            this.failed = true;
        }
        if (Report.should_report("time", 2)) {
            Report.report(2, "Finished " + pass + " status=" + Scheduler.statusString(result) + " inclusive_time=" + pass.inclusiveTime() + " exclusive_time=" + pass.exclusiveTime());
        } else if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished " + pass + " status=" + Scheduler.statusString(result));
        }
        if (job != null) {
            job.updateStatus(result);
        }
        return result;
    }

    protected static String statusString(boolean okay) {
        if (okay) {
            return "done";
        }
        return "failed";
    }

    public abstract Goal TypeExists(String var1);

    public abstract Goal MembersAdded(ParsedClassType var1);

    public abstract Goal SupertypesResolved(ParsedClassType var1);

    public abstract Goal SignaturesResolved(ParsedClassType var1);

    public abstract Goal FieldConstantsChecked(FieldInstance var1);

    public abstract Goal Parsed(Job var1);

    public abstract Goal TypesInitialized(Job var1);

    public abstract Goal TypesInitializedForCommandLine();

    public abstract Goal ImportTableInitialized(Job var1);

    public abstract Goal SignaturesDisambiguated(Job var1);

    public abstract Goal SupertypesDisambiguated(Job var1);

    public abstract Goal Disambiguated(Job var1);

    public abstract Goal TypeChecked(Job var1);

    public abstract Goal ConstantsChecked(Job var1);

    public abstract Goal ReachabilityChecked(Job var1);

    public abstract Goal ExceptionsChecked(Job var1);

    public abstract Goal ExitPathsChecked(Job var1);

    public abstract Goal InitializationsChecked(Job var1);

    public abstract Goal ConstructorCallsChecked(Job var1);

    public abstract Goal ForwardReferencesChecked(Job var1);

    public abstract Goal Serialized(Job var1);

    public abstract Goal CodeGenerated(Job var1);

    public Collection<Job> jobs() {
        ArrayList<Job> l = new ArrayList<Job>(this.jobs.size());
        for (Job job : this.jobs.values()) {
            if (job == Job.COMPLETED) continue;
            l.add(job);
        }
        return l;
    }

    public Job addJob(Source source) {
        return this.addJob(source, null);
    }

    public Job addJob(Source source, Node ast) {
        Job job = this.jobs.get(source);
        if (job == Job.COMPLETED) {
            return null;
        }
        if (job != null) {
            return job;
        }
        job = this.createSourceJob(source, ast);
        this.jobs.put(source, job);
        if (Report.should_report("frontend", 4)) {
            Report.report(4, "Adding job for " + source + " at the " + "request of pass " + this.currentPass);
        }
        return job;
    }

    protected Job createSourceJob(Source source, Node ast) {
        return new Job(this.extInfo, this.extInfo.jobExt(), source, ast);
    }

    public String toString() {
        return this.getClass().getName() + " worklist=" + this.worklist;
    }

    public boolean inInfiniteLoop() {
        return this.infiniteLoopGoal != null;
    }

    protected void dumpDependenceGraph() {
        String name = "FullDepGraph";
        name = name + dumpCounter++;
        Report.report(2, "digraph " + name + " {");
        Report.report(2, "  fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        for (Goal g : new ArrayList<Goal>(this.goals.keySet())) {
            int h2;
            g = this.internGoal(g);
            int h = System.identityHashCode(g);
            Report.report(2, h + " [ label = \"" + StringUtil.escape(g.toString()) + "\" ];");
            for (Goal g2 : g.prerequisiteGoals(this)) {
                g2 = this.internGoal(g2);
                h2 = System.identityHashCode(g2);
                Report.report(2, h2 + " -> " + h + " [style=bold]");
            }
            for (Goal g2 : g.corequisiteGoals(this)) {
                g2 = this.internGoal(g2);
                h2 = System.identityHashCode(g2);
                Report.report(2, h2 + " -> " + h);
            }
        }
        Report.report(2, "}");
    }

    protected void dumpInFlightDependenceGraph() {
        String name = "InFlightDepGraph";
        name = name + dumpCounter++;
        Report.report(2, "digraph " + name + " {");
        Report.report(2, "  fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        LinkedHashSet<Goal> print = new LinkedHashSet<Goal>();
        for (Goal g : new ArrayList<Goal>(this.goals.keySet())) {
            if ((g = this.internGoal(g)).state() == 2 || g.state() == 0 || g.state() == -1) continue;
            print.add(g);
            for (Goal g2 : g.prerequisiteGoals(this)) {
                g2 = this.internGoal(g2);
                print.add(g2);
            }
            for (Goal g2 : g.corequisiteGoals(this)) {
                g2 = this.internGoal(g2);
                print.add(g2);
            }
        }
        for (Goal g : print) {
            int h2;
            g = this.internGoal(g);
            int h = System.identityHashCode(g);
            Report.report(2, h + " [ label = \"" + StringUtil.escape(g.toString()) + "\" ];");
            for (Goal g2 : g.prerequisiteGoals(this)) {
                if (!print.contains(g2 = this.internGoal(g2))) continue;
                h2 = System.identityHashCode(g2);
                Report.report(2, h2 + " -> " + h + " [style=bold]");
            }
            for (Goal g2 : g.corequisiteGoals(this)) {
                if (!print.contains(g2 = this.internGoal(g2))) continue;
                h2 = System.identityHashCode(g2);
                Report.report(2, h2 + " -> " + h);
            }
        }
        Report.report(2, "}");
    }

    protected void dumpDependenceGraph(Goal g) {
        int h2;
        String name = "DepGraph";
        name = name + dumpCounter++;
        Report.report(2, "digraph " + name + " {");
        Report.report(2, "  fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        g = this.internGoal(g);
        int h = System.identityHashCode(g);
        Report.report(2, h + " [ label = \"" + StringUtil.escape(g.toString()) + "\" ];");
        HashSet<Integer> seen = new HashSet<Integer>();
        seen.add(h);
        for (Goal g2 : g.prerequisiteGoals(this)) {
            h2 = System.identityHashCode(g2 = this.internGoal(g2));
            if (!seen.contains(h2)) {
                seen.add(h2);
                Report.report(2, h2 + " [ label = \"" + StringUtil.escape(g2.toString()) + "\" ];");
            }
            Report.report(2, h2 + " -> " + h + " [style=bold]");
        }
        for (Goal g2 : g.corequisiteGoals(this)) {
            h2 = System.identityHashCode(g2 = this.internGoal(g2));
            if (!seen.contains(h2)) {
                seen.add(h2);
                Report.report(2, h2 + " [ label = \"" + StringUtil.escape(g2.toString()) + "\" ];");
            }
            Report.report(2, h2 + " -> " + h);
        }
        Report.report(2, "}");
    }

    protected static class TheEndGoal
    extends AbstractGoal {
        protected Scheduler scheduler;

        public TheEndGoal(Scheduler scheduler) {
            super(null);
            this.scheduler = scheduler;
        }

        @Override
        public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
            return scheduler.worklist();
        }

        @Override
        public String toString() {
            return "TheEnd(" + this.scheduler.getClass().getName() + ")";
        }

        protected Collection<Goal> goals() {
            return this.scheduler.worklist();
        }

        @Override
        public Pass createPass(ExtensionInfo extInfo) {
            return new EndPass(this);
        }

        @Override
        public int hashCode() {
            return Boolean.TRUE.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof TheEndGoal;
        }

        protected static class EndPass
        extends AbstractPass {
            protected EndPass(TheEndGoal g) {
                super(g);
            }

            @Override
            public boolean run() {
                TheEndGoal end = (TheEndGoal)this.goal();
                for (Goal goal : end.goals()) {
                    if (goal.hasBeenReached()) continue;
                    throw new MissingDependencyException(goal, true);
                }
                return true;
            }
        }
    }
}

