/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import polyglot.ast.Node;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.JobExt;
import polyglot.frontend.Pass;
import polyglot.frontend.Source;
import polyglot.util.CodeWriter;

public class Job {
    protected JobExt ext;
    protected ExtensionInfo lang;
    protected Node ast;
    protected Pass runningPass;
    protected boolean status;
    protected int initialErrorCount;
    protected boolean reportedErrors;
    protected Source source;
    public static final Job COMPLETED = new Job(null, null, null, null);

    public Job(ExtensionInfo lang, JobExt ext, Source source, Node ast) {
        this.lang = lang;
        this.ext = ext;
        this.source = source;
        this.ast = ast;
        this.runningPass = null;
        this.status = true;
        this.initialErrorCount = 0;
        this.reportedErrors = false;
    }

    public JobExt ext() {
        return this.ext;
    }

    public void setRunningPass(Pass pass) {
        if (pass != null) {
            this.initialErrorCount = this.compiler().errorQueue().errorCount();
        } else {
            int errorCount = this.compiler().errorQueue().errorCount();
            if (errorCount > this.initialErrorCount) {
                this.reportedErrors = true;
            }
        }
        this.runningPass = pass;
    }

    public boolean isRunning() {
        return this.runningPass != null;
    }

    public Pass runningPass() {
        return this.runningPass;
    }

    public Node ast() {
        return this.ast;
    }

    public void ast(Node ast) {
        this.ast = ast;
    }

    public boolean reportedErrors() {
        return this.reportedErrors;
    }

    public void dump(CodeWriter cw) {
        if (this.ast != null) {
            this.ast.dump(cw);
        }
    }

    public Source source() {
        return this.source;
    }

    public boolean userSpecified() {
        return this.source().userSpecified();
    }

    public void updateStatus(boolean status) {
        if (!status) {
            this.status = false;
        }
    }

    public boolean status() {
        return this.status;
    }

    public ExtensionInfo extensionInfo() {
        return this.lang;
    }

    public Compiler compiler() {
        return this.lang.compiler();
    }

    public String toString() {
        return this.source.toString();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Job && ((Job)o).source.equals(this.source);
    }
}

