/*
 * Decompiled with CFR 0.152.
 */
package polyglot.filemanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class ExtFileObject
extends SimpleJavaFileObject {
    protected final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public ExtFileObject(URI u, JavaFileObject.Kind k) {
        super(u, k);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        try {
            Reader r = this.openReader(ignoreEncodingErrors);
            try {
                return new Scanner(r).useDelimiter("\\A").next();
            }
            catch (NoSuchElementException e) {
                return "";
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.baos.reset();
        return this.baos;
    }

    @Override
    public Reader openReader(boolean arg0) throws IOException {
        return new InputStreamReader(this.openInputStream());
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }
}

