/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.param.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ext.param.types.Param;
import polyglot.ext.param.types.ParamTypeSystem;
import polyglot.ext.param.types.Subst;
import polyglot.ext.param.types.SubstType;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class SubstClassType_c<Formal extends Param, Actual extends TypeObject>
extends ClassType_c
implements SubstType<Formal, Actual> {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected transient List<? extends ReferenceType> interfaces;
    protected transient List<? extends FieldInstance> fields;
    protected transient List<? extends MethodInstance> methods;
    protected transient List<? extends ConstructorInstance> constructors;
    protected transient List<? extends ClassType> memberClasses;
    protected transient List<? extends ReferenceType> substInterfaces;
    protected transient List<? extends FieldInstance> substFields;
    protected transient List<? extends MethodInstance> substMethods;
    protected transient List<? extends ConstructorInstance> substConstructors;
    protected transient List<? extends ClassType> substMemberClasses;
    protected ClassType base;
    protected Subst<Formal, Actual> subst;

    public SubstClassType_c(ParamTypeSystem<Formal, Actual> ts, Position pos, ClassType base, Subst<Formal, Actual> subst) {
        super(ts, pos);
        this.base = base;
        this.subst = subst;
        if (subst == null) {
            throw new IllegalArgumentException("null subst");
        }
        if (base == null) {
            throw new IllegalArgumentException("null base");
        }
    }

    @Override
    public Iterator<Map.Entry<Formal, Actual>> entries() {
        return this.subst.entries();
    }

    @Override
    public Type base() {
        return this.base;
    }

    @Override
    public Subst<Formal, Actual> subst() {
        return this.subst;
    }

    @Override
    public Type superType() {
        return this.subst.substType(this.base.superType());
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        List<? extends ReferenceType> interfaces = this.base.interfaces();
        if (!interfaces.equals(this.interfaces)) {
            this.interfaces = this.deepCopy(interfaces);
            this.substInterfaces = this.subst.substTypeList(interfaces);
        }
        return this.substInterfaces;
    }

    @Override
    public List<? extends FieldInstance> fields() {
        List<? extends FieldInstance> fields = this.base.fields();
        if (!fields.equals(this.fields)) {
            this.fields = this.deepCopy(fields);
            this.substFields = this.subst.substFieldList(fields);
        }
        return this.substFields;
    }

    @Override
    public List<? extends MethodInstance> methods() {
        List<? extends MethodInstance> methods = this.base.methods();
        if (!methods.equals(this.methods)) {
            this.methods = this.deepCopy(methods);
            this.substMethods = this.subst.substMethodList(methods);
        }
        return this.substMethods;
    }

    @Override
    public List<? extends ConstructorInstance> constructors() {
        List<? extends ConstructorInstance> constructors = this.base.constructors();
        if (!constructors.equals(this.constructors)) {
            this.constructors = this.deepCopy(constructors);
            this.substConstructors = this.subst.substConstructorList(constructors);
        }
        return this.substConstructors;
    }

    @Override
    public List<? extends ClassType> memberClasses() {
        List<? extends ClassType> memberClasses = this.base.memberClasses();
        if (!memberClasses.equals(this.memberClasses)) {
            this.memberClasses = this.deepCopy(memberClasses);
            this.substMemberClasses = this.subst.substTypeList(memberClasses);
        }
        return this.substMemberClasses;
    }

    @Override
    public ClassType outer() {
        return (ClassType)this.subst.substType(this.base.outer());
    }

    protected <T extends TypeObject> List<T> deepCopy(List<T> src) {
        ArrayList<TypeObject> dst = new ArrayList<TypeObject>(src.size());
        for (TypeObject t : src) {
            dst.add(Copy.Util.copy(t));
        }
        return dst;
    }

    @Override
    public ClassType.Kind kind() {
        return this.base.kind();
    }

    @Override
    public boolean inStaticContext() {
        return this.base.inStaticContext();
    }

    @Override
    public String fullName() {
        return this.base.fullName();
    }

    @Override
    public String name() {
        return this.base.name();
    }

    @Override
    public Package package_() {
        return this.base.package_();
    }

    @Override
    public Flags flags() {
        return this.base.flags();
    }

    @Override
    public String translate(Resolver c) {
        return this.base.translate(c);
    }

    @Override
    public boolean typeEqualsImpl(Type t) {
        if (t instanceof SubstType) {
            SubstType x = (SubstType)t;
            return this.base.typeEquals(x.base()) && this.subst.equals(x.subst());
        }
        return false;
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (t instanceof SubstType) {
            SubstType x = (SubstType)t;
            return this.base.equals(x.base()) && this.subst.equals(x.subst());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() ^ this.subst.hashCode();
    }

    @Override
    public String toString() {
        return this.base.toString() + this.subst.toString();
    }

    @Override
    public Job job() {
        return null;
    }

    @Override
    public void setFlags(Flags flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContainer(ReferenceType container) {
        throw new UnsupportedOperationException();
    }
}

