/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.types.inference;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.inference.InferenceSolver_c;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.types.ConstructorInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;

public class JL7InferenceSolver_c
extends InferenceSolver_c {
    public JL7InferenceSolver_c(JL5ProcedureInstance pi, List<? extends Type> actuals, JL5TypeSystem ts) {
        super(pi, actuals, ts);
    }

    @Override
    protected List<TypeVariable> typeVariablesToSolve(JL5ProcedureInstance pi) {
        JL5ConstructorInstance ci;
        ReferenceType ct;
        if (pi instanceof JL5ConstructorInstance && (ct = (ci = (JL5ConstructorInstance)pi).container()) instanceof JL5ParsedClassType) {
            JL5ParsedClassType pct = (JL5ParsedClassType)ct;
            ArrayList<TypeVariable> result = new ArrayList<TypeVariable>(pct.typeVariables().size() + pi.typeParams().size());
            result.addAll(pct.typeVariables());
            result.addAll(pi.typeParams());
            return result;
        }
        return super.typeVariablesToSolve(pi);
    }

    @Override
    protected Type returnType(JL5ProcedureInstance pi) {
        if (pi instanceof ConstructorInstance) {
            ConstructorInstance ci = (ConstructorInstance)((Object)pi);
            ReferenceType container = ci.container();
            if (container.isClass()) {
                JL5ParsedClassType ct = (JL5ParsedClassType)container.toClass();
                JL7TypeSystem ts = (JL7TypeSystem)ci.typeSystem();
                LinkedHashMap<TypeVariable, TypeVariable> substm = new LinkedHashMap<TypeVariable, TypeVariable>();
                for (TypeVariable tv : ct.typeVariables()) {
                    substm.put(tv, tv);
                }
                return ts.subst(container, substm);
            }
            return container;
        }
        return super.returnType(pi);
    }
}

