/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl7.types.DiamondType;
import polyglot.ext.jl7.types.DiamondType_c;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.ext.jl7.types.inference.JL7InferenceSolver_c;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.MemberInstance;
import polyglot.types.NoMemberException;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;

public class JL7TypeSystem_c
extends JL5TypeSystem_c
implements JL7TypeSystem {
    protected ClassType AUTOCLOSEABLE_;

    @Override
    public ClassType AutoCloseable() {
        if (this.AUTOCLOSEABLE_ != null) {
            return this.AUTOCLOSEABLE_;
        }
        this.AUTOCLOSEABLE_ = this.load("java.lang.AutoCloseable");
        return this.AUTOCLOSEABLE_;
    }

    @Override
    public DiamondType diamondType(Position pos, JL5ParsedClassType base) {
        return new DiamondType_c(pos, base);
    }

    @Override
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> typeArgs, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findConstructor(container, argTypes, typeArgs, currClass, null, fromClient);
    }

    @Override
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> typeArgs, ClassType currClass, Type expectedObjectType, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        List<ConstructorInstance> acceptable = this.findAcceptableConstructors(container, argTypes, typeArgs, currClass, expectedObjectType, fromClient);
        if (acceptable.size() == 0) {
            throw new NoMemberException(2, "No valid constructor found for " + container + "(" + JL7TypeSystem_c.listToString(argTypes) + ").");
        }
        Collection<ConstructorInstance> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() > 1) {
            StringBuffer sb = new StringBuffer();
            Iterator<ConstructorInstance> i = maximal.iterator();
            while (i.hasNext()) {
                ConstructorInstance ci = i.next();
                sb.append(ci.container());
                sb.append(".");
                sb.append(ci.signature());
                if (!i.hasNext()) continue;
                if (maximal.size() == 2) {
                    sb.append(" and ");
                    continue;
                }
                sb.append(", ");
            }
            throw new SemanticException("Reference to " + container + " is ambiguous, multiple constructors match: " + sb.toString());
        }
        ConstructorInstance ci = maximal.iterator().next();
        return ci;
    }

    @Override
    protected List<ConstructorInstance> findAcceptableConstructors(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findAcceptableConstructors(container, argTypes, actualTypeArgs, currClass, null, fromClient);
    }

    protected List<ConstructorInstance> findAcceptableConstructors(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, ClassType currClass, Type expectedObjectType, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        container = (ClassType)this.applyCaptureConversion(container, container.position());
        NoMemberException error = null;
        ArrayList<ConstructorInstance> phase1constructors = new ArrayList<ConstructorInstance>();
        ArrayList<ConstructorInstance> phase2constructors = new ArrayList<ConstructorInstance>();
        ArrayList<ConstructorInstance> phase3constructors = new ArrayList<ConstructorInstance>();
        if (Report.should_report("types", 2)) {
            Report.report(2, "Searching type " + container + " for constructor " + container + "(" + JL7TypeSystem_c.listToString(argTypes) + ")");
        }
        List<? extends ConstructorInstance> constructors = container.constructors();
        for (JL5ConstructorInstance jL5ConstructorInstance : constructors) {
            JL5ConstructorInstance substCi;
            if (Report.should_report("types", 3)) {
                Report.report(3, "Trying " + jL5ConstructorInstance);
            }
            if ((substCi = (JL5ConstructorInstance)this.callValid(jL5ConstructorInstance, argTypes, actualTypeArgs, expectedObjectType)) != null) {
                JL5ConstructorInstance jL5ConstructorInstance2 = substCi;
                if (this.isAccessible((MemberInstance)jL5ConstructorInstance2, currClass, fromClient)) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "->acceptable: " + jL5ConstructorInstance2);
                    }
                    if (this.varArgsRequired(jL5ConstructorInstance2)) {
                        phase3constructors.add(jL5ConstructorInstance2);
                        continue;
                    }
                    if (this.boxingRequired(jL5ConstructorInstance2, argTypes)) {
                        phase2constructors.add(jL5ConstructorInstance2);
                        continue;
                    }
                    phase1constructors.add(jL5ConstructorInstance2);
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(2, "Constructor " + jL5ConstructorInstance2.signature() + " is inaccessible.");
                continue;
            }
            if (error != null) continue;
            error = new NoMemberException(2, "Constructor " + jL5ConstructorInstance.signature() + " cannot be invoked with arguments " + "(" + JL7TypeSystem_c.listToString(argTypes) + ").");
        }
        if (!phase1constructors.isEmpty()) {
            return phase1constructors;
        }
        if (!phase2constructors.isEmpty()) {
            return phase2constructors;
        }
        if (!phase3constructors.isEmpty()) {
            return phase3constructors;
        }
        if (error == null) {
            error = new NoMemberException(2, "No valid constructor found for " + container + "(" + JL7TypeSystem_c.listToString(argTypes) + ").");
        }
        throw error;
    }

    @Override
    public boolean callValid(ProcedureInstance mi, List<? extends Type> argTypes) {
        return this.callValid((JL5ProcedureInstance)mi, argTypes, null, null) != null;
    }

    @Override
    public JL5ProcedureInstance callValid(JL5ProcedureInstance pi, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, Type expectedReturnType) {
        if (actualTypeArgs == null) {
            actualTypeArgs = Collections.emptyList();
        }
        if (!(argTypes.size() == pi.formalTypes().size() || pi.isVariableArity() && argTypes.size() >= pi.formalTypes().size() - 1)) {
            return null;
        }
        JL5Subst subst = null;
        ReferenceType ct = pi.container();
        if (ct instanceof JL5ParsedClassType && !((JL5ParsedClassType)ct).typeVariables().isEmpty() || !pi.typeParams().isEmpty() && actualTypeArgs.isEmpty()) {
            subst = this.inferTypeArgs(pi, argTypes, expectedReturnType);
        } else if (!pi.typeParams().isEmpty() && !actualTypeArgs.isEmpty()) {
            HashMap<TypeVariable, ReferenceType> m = new HashMap<TypeVariable, ReferenceType>();
            Iterator<ReferenceType> iter = actualTypeArgs.iterator();
            for (TypeVariable tv : pi.typeParams()) {
                m.put(tv, iter.next());
            }
            subst = (JL5Subst)this.subst(m);
        }
        JL5ProcedureInstance mj = pi;
        if ((ct instanceof JL5ParsedClassType && !((JL5ParsedClassType)ct).typeVariables().isEmpty() || !pi.typeParams().isEmpty()) && subst != null) {
            for (TypeVariable tv : subst.substitutions().keySet()) {
                Type a = (Type)subst.substitutions().get(tv);
                if (this.isSubtype(a, tv.upperBound())) continue;
                return null;
            }
            mj = subst.substProcedure(pi);
        }
        if (super.callValid(mj, argTypes)) {
            return mj;
        }
        return null;
    }

    @Override
    protected InferenceSolver inferenceSolver(JL5ProcedureInstance pi, List<? extends Type> argTypes) {
        return new JL7InferenceSolver_c(pi, argTypes, this);
    }
}

