/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Conditional;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.StringLit;
import polyglot.ast.Throw;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.frontend.Job;
import polyglot.types.ArrayType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class TVCaster
extends AscriptionVisitor {
    public TVCaster(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        Call c;
        Field f;
        if (e.type() == null || toType == null || !toType.isCanonical()) {
            return e;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        Type fromType = ts.erasureType(e.type());
        toType = ts.erasureType(toType);
        if (!fromType.isReference() || !toType.isReference() || ts.Object().equals(toType)) {
            return e;
        }
        if (e instanceof Special || e instanceof ArrayInit || e instanceof Lit) {
            return e;
        }
        if (e instanceof New && ts.isImplicitCastValid(((New)e).objectType().type(), toType)) {
            return e;
        }
        if (this.isStringLiterals(e)) {
            return e;
        }
        if (e instanceof Field && !this.mayBeParameterizedField((f = (Field)e).fieldInstance())) {
            return e;
        }
        if (e instanceof Call && !this.mayHaveParameterizedReturn((c = (Call)e).methodInstance()) && !this.mayHaveCovariantReturn(c.methodInstance())) {
            return e;
        }
        if (ts.isCastValid(fromType, toType)) {
            Type castType = toType;
            if (toType.isClass() && !ts.classAccessible(toType.toClass(), this.context())) {
                castType = fromType;
            }
            return this.insertCast(e, castType);
        }
        return e;
    }

    @Override
    public NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (n instanceof AnnotationElem) {
            return this.bypassChildren(n);
        }
        return super.enterCall(parent, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mayBeParameterizedField(FieldInstance fi) {
        FieldInstance bfi;
        JL5ParsedClassType pct;
        ReferenceType container = fi.container();
        if (container.isArray()) {
            Type base = container.toArray().base();
            while (base.isArray()) {
                base = base.toArray().base();
            }
            if (base instanceof TypeVariable) {
                return true;
            }
            if (!base.isReference()) return false;
            pct = TVCaster.getBase(base.toReference());
        } else {
            pct = TVCaster.getBase(container);
        }
        if ((bfi = pct.fieldNamed(fi.name())) != null) return this.hasTypeVariable(bfi.type());
        throw new InternalCompilerError("Couldn't find field named " + fi.name() + " in " + pct);
    }

    private boolean mayHaveParameterizedReturn(MethodInstance mi) {
        ArrayList<MethodInstance> overrides = new ArrayList<MethodInstance>();
        overrides.add(mi);
        overrides.addAll(this.ts.overrides(mi));
        overrides.addAll(this.ts.implemented(mi));
        for (MethodInstance mj : overrides) {
            if (!this.mayHaveParameterizedReturnImpl(mj)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mayHaveParameterizedReturnImpl(MethodInstance mi) {
        JL5ParsedClassType pct;
        ReferenceType container = mi.container();
        if (container.isArray()) {
            Type base = container.toArray().base();
            while (base.isArray()) {
                base = base.toArray().base();
            }
            if (base instanceof TypeVariable) {
                return true;
            }
            if (!base.isReference()) return false;
            pct = TVCaster.getBase(base.toReference());
        } else {
            pct = TVCaster.getBase(container);
        }
        List<? extends MethodInstance> meths = pct.methodsNamed(mi.name());
        for (MethodInstance methodInstance : meths) {
            if (methodInstance.formalTypes().size() != mi.formalTypes().size() || !this.hasTypeVariable(methodInstance.returnType())) continue;
            return true;
        }
        return false;
    }

    private boolean mayHaveCovariantReturn(MethodInstance mi) {
        if (mi.returnType().isReference()) {
            List<MethodInstance> overrides = this.ts.overrides(mi);
            overrides.addAll(this.ts.implemented(mi));
            ReferenceType ret = mi.returnType().toReference();
            for (MethodInstance ovr : overrides) {
                ReferenceType supRet = ovr.returnType().toReference();
                if (this.ts.equals(ret, supRet)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTypeVariable(Type t) {
        if (t instanceof TypeVariable) {
            return true;
        }
        if (t instanceof ArrayType) {
            return this.hasTypeVariable(((ArrayType)t).base());
        }
        return false;
    }

    private static JL5ParsedClassType getBase(ReferenceType container) {
        if (container instanceof JL5SubstClassType) {
            return ((JL5SubstClassType)container).base();
        }
        if (container instanceof RawClass) {
            return ((RawClass)container).base();
        }
        if (container instanceof JL5ParsedClassType) {
            return (JL5ParsedClassType)container;
        }
        throw new InternalCompilerError("Don't know how to deal with container of type " + container.getClass());
    }

    private boolean isStringLiterals(Expr e) {
        if (e instanceof StringLit) {
            return true;
        }
        if (e instanceof Binary) {
            Binary b = (Binary)e;
            return b.operator() == Binary.ADD && this.isStringLiterals(b.left()) && this.isStringLiterals(b.right());
        }
        return false;
    }

    private Expr insertCast(Expr e, Type toType) {
        if (toType.isClass() && toType.toClass().fullName().equals("java.lang.Enum")) {
            String enumImpl;
            JL5Options opts = (JL5Options)this.job.extensionInfo().getOptions();
            if (opts.removeJava5isms && !"java.lang.Enum".equals(enumImpl = opts.enumImplClass)) {
                Type eType = e.type();
                JL5TypeSystem ts = (JL5TypeSystem)this.ts;
                if (eType.isNull()) {
                    return e;
                }
                if (ts.erasureType(eType).equals(ts.erasureType(ts.Enum()))) {
                    return e;
                }
                toType = ts.erasureType(eType);
            }
        }
        CanonicalTypeNode tn = this.nf.CanonicalTypeNode(Position.compilerGenerated(), toType);
        Cast newE = this.nf.Cast(Position.compilerGenerated(), tn, e);
        return newE.type(toType);
    }

    @Override
    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        Cast c;
        Binary b;
        Expr c2;
        Node ret = super.leaveCall(parent, old, n, v);
        if (parent instanceof Eval && ret instanceof Cast) {
            Cast c3 = (Cast)ret;
            return c3.expr();
        }
        if (parent instanceof Assign && ret instanceof Cast && ((Assign)parent).left() == old) {
            Cast c4 = (Cast)ret;
            return c4.expr();
        }
        if (parent instanceof Throw && ret instanceof Cast) {
            c2 = (Cast)ret;
            c2 = c2.castType(c2.castType().type(c2.expr().type()));
            c2 = (Cast)c2.type(c2.expr().type());
            ret = c2;
        }
        if (parent instanceof Conditional && ((c2 = (Conditional)parent).consequent() == old || c2.alternative() == old) && c2.type().isReference() && !((Expr)n).type().equals(c2.type())) {
            return this.insertCast((Expr)n, c2.type());
        }
        if (parent instanceof Binary && (b = (Binary)parent).type().equals(this.ts.String()) && ret instanceof Cast && (c = (Cast)ret).castType().type().equals(this.ts.String())) {
            return c.expr();
        }
        return ret;
    }
}

