/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import polyglot.ast.ArrayAccess;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Cast;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Unary;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DeepCopy;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class SimplifyExpressionsForBoxing
extends HaltingVisitor {
    NodeFactory nf;
    TypeSystem ts;

    public SimplifyExpressionsForBoxing(NodeFactory nf, TypeSystem ts) {
        super(nf.lang());
        this.nf = nf;
        this.ts = ts;
    }

    @Override
    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (n instanceof Assign) {
            return this.simplifyAssignment((Assign)n);
        }
        if (n instanceof Unary) {
            return this.simplifyUnary((Unary)n, parent instanceof Eval);
        }
        return super.leave(old, n, v);
    }

    private Node simplifyUnary(Unary u, boolean discardValue) {
        JL5TypeSystem ts = (JL5TypeSystem)u.type().typeSystem();
        PrimitiveType primType = ts.primitiveTypeOfWrapper(u.expr().type());
        if (primType == null) {
            return u;
        }
        if (Unary.PRE_DEC.equals(u.operator()) || Unary.PRE_INC.equals(u.operator()) || discardValue && (Unary.POST_DEC.equals(u.operator()) || Unary.POST_INC.equals(u.operator()))) {
            if (!this.isTargetPure(u.expr())) {
                throw new InternalCompilerError("Don't support effectful LHS " + u + " " + u.expr().getClass());
            }
            Expr left = u.expr();
            boolean add = Unary.PRE_INC.equals(u.operator()) || Unary.POST_INC.equals(u.operator());
            Assign.Operator newOp = add ? Assign.ADD_ASSIGN : Assign.SUB_ASSIGN;
            Assign ass = this.nf.Assign(u.position(), left, newOp, this.nf.IntLit(u.position(), IntLit.INT, 1L).type(ts.Int()));
            ass = (Assign)ass.type(left.type());
            return this.simplifyAssignment(ass);
        }
        if (Unary.POST_DEC.equals(u.operator()) || Unary.POST_INC.equals(u.operator())) {
            if (!this.isTargetPure(u.expr())) {
                throw new InternalCompilerError("Don't support effectful LHS " + u + " " + u.expr().getClass());
            }
            Expr left = u.expr();
            Assign.Operator newOp = Unary.POST_INC.equals(u.operator()) ? Assign.ADD_ASSIGN : Assign.SUB_ASSIGN;
            Assign ass = this.nf.Assign(u.position(), left, newOp, this.nf.IntLit(u.position(), IntLit.INT, 1L).type(ts.Int()));
            Expr sa = this.simplifyAssignment((Assign)ass.type(left.type()));
            Binary b = this.nf.Binary(u.position(), sa, Unary.POST_INC.equals(u.operator()) ? Binary.SUB : Binary.ADD, this.nf.IntLit(u.position(), IntLit.INT, 1L).type(ts.Int()));
            b = (Binary)b.type(primType);
            return b;
        }
        return u;
    }

    protected Expr simplifyAssignment(Assign ass) {
        JL5TypeSystem ts = (JL5TypeSystem)ass.left().type().typeSystem();
        PrimitiveType leftTypePrim = ts.primitiveTypeOfWrapper(ass.left().type());
        if (ass.operator().equals(Assign.ASSIGN) || leftTypePrim == null) {
            return ass;
        }
        Type rightTypePrim = ass.right().type();
        if (!rightTypePrim.isPrimitive()) {
            rightTypePrim = ts.primitiveTypeOfWrapper(ass.right().type());
        }
        Binary.Operator op = ass.operator().binaryOperator();
        Expr right = ass.right();
        Binary b = this.nf.Binary(ass.position(), (Expr)ass.left().visit(new DeepCopy(this.lang())), op, right);
        if (leftTypePrim.isNumeric() && rightTypePrim.isNumeric()) {
            try {
                b = (Binary)b.type(ts.promote(leftTypePrim, rightTypePrim));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError(e);
            }
        } else {
            b = (Binary)b.type(ass.left().type());
        }
        Binary rightExpr = b;
        ass = ass.operator(Assign.ASSIGN).right(rightExpr);
        return ass;
    }

    private boolean isTargetPure(Receiver target) {
        if (target instanceof Expr) {
            return this.isTargetPure((Expr)target);
        }
        return true;
    }

    private boolean isTargetPure(Expr target) {
        if (target instanceof Special) {
            return true;
        }
        if (target instanceof Local) {
            return true;
        }
        if (target instanceof Field) {
            return this.isTargetPure(((Field)target).target());
        }
        if (target instanceof Cast) {
            return this.isTargetPure(((Cast)target).expr());
        }
        if (target instanceof ArrayAccess) {
            ArrayAccess aa = (ArrayAccess)target;
            return this.isTargetPure(aa.array()) && this.isTargetPure(aa.index());
        }
        return false;
    }
}

