/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import polyglot.ast.ArrayInit;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.Case;
import polyglot.ast.Cast;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassLit;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.ast.JL5ClassDeclExt;
import polyglot.ext.jl5.ast.JL5EnumDeclExt;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.frontend.Job;
import polyglot.qq.QQ;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class RemoveEnums
extends ContextVisitor {
    private QQ qq;
    private boolean inEnumDecl = false;
    private ClassType enumDeclType = null;
    private final String enumImplClass;
    private final String enumSetImplClass;
    private final boolean translateEnumSet;
    private Stack<List<ClassMember>> classMembersToAdd = new Stack();

    public RemoveEnums(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.qq = new QQ(job.extensionInfo());
        this.enumImplClass = ((JL5Options)job.extensionInfo().getOptions()).enumImplClass;
        this.enumSetImplClass = ((JL5Options)job.extensionInfo().getOptions()).enumSetImplClass;
        this.translateEnumSet = !this.enumSetImplClass.equals("java.util.EnumSet");
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        JL5ClassDeclExt ext;
        if (n instanceof ClassBody) {
            this.classMembersToAdd.push(new ArrayList());
        }
        if (n instanceof ClassDecl && (ext = (JL5ClassDeclExt)JL5Ext.ext(n)) instanceof JL5EnumDeclExt) {
            return this.inEnumDecl(((ClassDecl)n).type());
        }
        return super.enterCall(n);
    }

    private NodeVisitor inEnumDecl(ClassType enumDeclType) {
        RemoveEnums re = (RemoveEnums)this.copy();
        re.inEnumDecl = true;
        re.enumDeclType = enumDeclType;
        return re;
    }

    @Override
    protected Node leaveCall(Node n) throws SemanticException {
        if (n instanceof ClassBody) {
            n = this.addWaitingClassMembers((ClassBody)n);
        }
        if (n instanceof ClassDecl && JL5Ext.ext(n) instanceof JL5EnumDeclExt) {
            return this.translateEnumDecl((ClassDecl)n);
        }
        if (n instanceof EnumConstantDecl) {
            return this.translateEnumConstantDecl((EnumConstantDecl)n);
        }
        if (this.inEnumDecl && n instanceof ConstructorDecl) {
            return this.translateEnumConstructor((ConstructorDecl)n);
        }
        if (n instanceof Switch) {
            return this.translateSwitch((Switch)n);
        }
        if (n instanceof Case) {
            return this.translateCase((Case)n);
        }
        if (n instanceof TypeNode) {
            return this.translateTypeNode((TypeNode)n);
        }
        return n;
    }

    private Node addWaitingClassMembers(ClassBody n) {
        List<ClassMember> membersToAdd = this.classMembersToAdd.pop();
        for (ClassMember m : membersToAdd) {
            MethodDecl md;
            FieldDecl fd;
            if (m instanceof FieldDecl && (fd = (FieldDecl)m).fieldInstance().container() == null) {
                fd.fieldInstance().setContainer(this.context().currentClass());
            }
            if (m instanceof MethodDecl && (md = (MethodDecl)m).methodInstance().container() == null) {
                md.methodInstance().setContainer(this.context().currentClass());
            }
            n = n.addMember(m);
        }
        return n;
    }

    private Node translateEnumDecl(ClassDecl enumDecl) throws SemanticException {
        ClassBody body = enumDecl.body();
        body = this.addEnumUtilityMembers(body, enumDecl.type());
        ClassDecl classDecl = this.nf.ClassDecl(enumDecl.position(), JL5Flags.clearEnum(enumDecl.type().flags()), enumDecl.id(), (TypeNode)this.nf.CanonicalTypeNode(enumDecl.position(), this.ts.typeForName(this.enumImplClass)), enumDecl.interfaces(), body);
        classDecl = classDecl.type(enumDecl.type());
        return classDecl;
    }

    private Node translateEnumConstructor(ConstructorDecl n) {
        Position pos = Position.compilerGenerated();
        Id enumName = this.nodeFactory().Id(pos, "enum$name");
        Id enumOrdinal = this.nodeFactory().Id(pos, "enum$ordinal");
        LinkedList<Stmt> oldStmts = new LinkedList<Stmt>(n.body().statements());
        ConstructorCall existingCC = null;
        existingCC = !oldStmts.isEmpty() && oldStmts.get(0) instanceof ConstructorCall ? (ConstructorCall)oldStmts.remove(0) : this.nodeFactory().ConstructorCall(pos, ConstructorCall.SUPER, Collections.emptyList());
        ArrayList<Formal> newFormals = new ArrayList<Formal>();
        JL5LocalInstance enumNameLI = (JL5LocalInstance)this.ts.localInstance(pos, Flags.NONE, this.ts.String(), enumName.id());
        enumNameLI.setProcedureFormal(true);
        newFormals.add(this.nodeFactory().Formal(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, this.ts.String()), enumName).localInstance(enumNameLI));
        JL5LocalInstance enumOrdLI = (JL5LocalInstance)this.ts.localInstance(pos, Flags.NONE, this.ts.Int(), enumOrdinal.id());
        enumOrdLI.setProcedureFormal(true);
        newFormals.add(this.nodeFactory().Formal(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, this.ts.Int()), enumOrdinal).localInstance(enumOrdLI));
        newFormals.addAll(n.formals());
        n = (ConstructorDecl)n.formals(newFormals);
        ArrayList<Expr> constructorCallArgs = new ArrayList<Expr>();
        constructorCallArgs.add(this.nodeFactory().Local(pos, enumName).localInstance(enumNameLI));
        constructorCallArgs.add(this.nodeFactory().Local(pos, enumOrdinal).localInstance(enumOrdLI));
        if (existingCC.kind() == ConstructorCall.THIS) {
            constructorCallArgs.addAll(existingCC.arguments());
        }
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        newStmts.add((ConstructorCall)existingCC.arguments(constructorCallArgs));
        newStmts.addAll(oldStmts);
        n = (ConstructorDecl)n.body(this.nodeFactory().Block(pos, newStmts));
        return n;
    }

    private ClassBody addEnumUtilityMembers(ClassBody body, ClassType enumDeclType) throws SemanticException {
        ClassType old = this.enumDeclType;
        this.enumDeclType = enumDeclType;
        body = this.addValuesField(body);
        body = this.addValuesMethod(body);
        body = this.addValueOfMethod(body);
        this.enumDeclType = old;
        return body;
    }

    private ClassBody addValuesField(ClassBody body) {
        Position pos = Position.compilerGenerated();
        ArrayList<Expr> decls = new ArrayList<Expr>();
        for (MemberInstance memberInstance : this.enumDeclType.toClass().members()) {
            if (!(memberInstance instanceof EnumInstance)) continue;
            EnumInstance ei = (EnumInstance)memberInstance;
            Field f = this.nf.Field(pos, (Receiver)this.nf.CanonicalTypeNode(pos, this.enumDeclType), this.nf.Id(pos, ei.name()));
            decls.add(f);
        }
        ArrayInit ai = this.nf.ArrayInit(pos, decls);
        FieldDecl fieldDecl = this.nf.FieldDecl(pos, Flags.STATIC.Final(), (TypeNode)this.nf.CanonicalTypeNode(pos, this.ts.arrayOf(this.enumDeclType)), this.nf.Id(pos, "values"), (Expr)ai);
        FieldInstance fi = this.ts.fieldInstance(pos, this.enumDeclType, Flags.NONE, this.ts.arrayOf(this.enumDeclType), "values");
        FieldDecl fieldDecl2 = fieldDecl.fieldInstance(fi);
        body = body.addMember(fieldDecl2);
        return body;
    }

    private ClassBody addValuesMethod(ClassBody body) {
        Position pos = Position.compilerGenerated();
        Field f = this.nf.Field(pos, (Receiver)this.nf.CanonicalTypeNode(pos, this.enumDeclType), this.nf.Id(pos, "values"));
        Id clid = this.nodeFactory().Id(pos, "clone");
        Call cl = this.nf.Call(pos, (Receiver)f, clid, new Expr[0]);
        Cast cst = this.nf.Cast(pos, this.nf.CanonicalTypeNode(pos, this.ts.arrayOf(this.enumDeclType)), cl);
        Return ret = this.nf.Return(pos, cst);
        Id mdid = this.nodeFactory().Id(pos, "values");
        MethodDecl md = this.nf.MethodDecl(pos, Flags.PUBLIC.Static(), (TypeNode)this.nf.CanonicalTypeNode(pos, this.ts.arrayOf(this.enumDeclType)), mdid, Collections.emptyList(), Collections.emptyList(), this.nf.Block(pos, ret));
        MethodInstance mi = this.ts.methodInstance(pos, this.enumDeclType, Flags.NONE, this.ts.arrayOf(this.enumDeclType), "values", Collections.emptyList(), Collections.emptyList());
        md = md.methodInstance(mi);
        return body.addMember(md);
    }

    private ClassBody addValueOfMethod(ClassBody body) throws SemanticException {
        Position pos = Position.compilerGenerated();
        Local arg = this.nf.Local(pos, this.nf.Id(pos, "s"));
        ClassLit clazz = this.nf.ClassLit(pos, this.nf.CanonicalTypeNode(pos, this.enumDeclType));
        LocalInstance argLI = this.ts.localInstance(pos, Flags.NONE, this.ts.String(), arg.name());
        arg = arg.localInstance(argLI);
        Call cl = this.nf.Call(pos, (Receiver)this.nf.CanonicalTypeNode(pos, this.ts.typeForName(this.enumImplClass)), this.nf.Id(pos, "valueOf"), clazz, arg);
        Cast cst = this.nf.Cast(pos, this.nf.CanonicalTypeNode(pos, this.enumDeclType), cl);
        Return ret = this.nf.Return(pos, cst);
        Formal formal = this.nf.Formal(pos, Flags.NONE, (TypeNode)this.nf.CanonicalTypeNode(pos, this.ts.String()), this.nf.Id(pos, "s")).localInstance(argLI);
        MethodDecl md = this.nf.MethodDecl(pos, Flags.PUBLIC.Static(), (TypeNode)this.nf.CanonicalTypeNode(pos, this.enumDeclType), this.nf.Id(pos, "valueOf"), Collections.singletonList(formal), Collections.emptyList(), this.nf.Block(pos, ret));
        MethodInstance mi = this.ts.methodInstance(pos, this.enumDeclType, Flags.NONE, this.enumDeclType, "valueOf", Collections.singletonList(this.ts.String()), Collections.emptyList());
        md = md.methodInstance(mi);
        return body.addMember(md);
    }

    private Node translateEnumConstantDecl(EnumConstantDecl ecd) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(this.nf.StringLit(Position.compilerGenerated(), ecd.name().id()));
        args.add(this.nf.IntLit(Position.compilerGenerated(), IntLit.INT, ecd.ordinal()));
        args.addAll(ecd.args());
        Expr init = this.nf.New(Position.compilerGenerated(), this.nf.CanonicalTypeNode(Position.compilerGenerated(), this.enumDeclType), args, ecd.body());
        init = init.type(this.enumDeclType);
        FieldDecl fd = this.nf.FieldDecl(ecd.position(), Flags.FINAL.Public().Static(), (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), this.enumDeclType), ecd.name(), init);
        return fd;
    }

    public static void prettyPrintClassDeclAsEnum(ClassDecl decl, CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(decl.flags().clearStatic().translate());
        w.write("enum ");
        w.write(decl.name());
        w.unifiedBreak(0);
        w.end();
        w.write("{");
        ArrayList<FieldDecl> enumConstDecls = new ArrayList<FieldDecl>();
        ArrayList<ClassMember> otherMembers = new ArrayList<ClassMember>();
        for (ClassMember cm : decl.body().members()) {
            MethodDecl md;
            boolean isEnumConstDecl = false;
            boolean addMember = true;
            if (cm instanceof FieldDecl) {
                FieldDecl fd = (FieldDecl)cm;
                if (fd.type().type() == decl.type()) {
                    isEnumConstDecl = true;
                }
                if (fd.name().equals("values")) {
                    addMember = false;
                }
            }
            if (cm instanceof MethodDecl && ((md = (MethodDecl)cm).name().equals("valueOf") || md.name().equals("values"))) {
                addMember = false;
            }
            if (isEnumConstDecl) {
                enumConstDecls.add((FieldDecl)cm);
                continue;
            }
            if (!addMember) continue;
            otherMembers.add(cm);
        }
        Iterator iter = enumConstDecls.iterator();
        w.allowBreak(1, " ");
        while (iter.hasNext()) {
            FieldDecl fd = (FieldDecl)iter.next();
            RemoveEnums.prettyPrintEnumConstFieldDecl(fd, w, tr);
            if (!iter.hasNext()) continue;
            w.write(",");
            w.allowBreak(1, " ");
        }
        w.write(";");
        w.newline();
        w.begin(0);
        ClassMember prev = null;
        Iterator i = otherMembers.iterator();
        while (i.hasNext()) {
            ClassMember member = (ClassMember)i.next();
            if (member instanceof CodeDecl || prev instanceof CodeDecl) {
                w.newline(0);
            }
            prev = member;
            w.begin(0);
            if (member instanceof ConstructorDecl) {
                RemoveEnums.prettyPrintConstructorDeclAsEnumConstructorDecl((ConstructorDecl)member, w, tr);
            } else {
                tr.print(decl, member, w);
            }
            w.end();
            if (!i.hasNext()) continue;
            w.newline(0);
        }
        w.end();
        w.write("}");
        w.newline(0);
    }

    private static void prettyPrintEnumConstFieldDecl(FieldDecl fd, CodeWriter w, PrettyPrinter tr) {
        w.write(fd.name());
        Expr init = fd.init();
        if (init instanceof New) {
            New ne = (New)init;
            LinkedList<Expr> newArgs = new LinkedList<Expr>(ne.arguments());
            newArgs.remove(0);
            newArgs.remove(0);
            if (!newArgs.isEmpty()) {
                w.write("(");
                Iterator iter = newArgs.iterator();
                while (iter.hasNext()) {
                    Expr e = (Expr)iter.next();
                    tr.lang().prettyPrint((Node)e, w, tr);
                    if (!iter.hasNext()) continue;
                    w.write(",");
                    w.allowBreak(1, " ");
                }
                w.write(")");
            }
            if (ne.body() != null) {
                w.write(" {");
                tr.lang().prettyPrint((Node)ne.body(), w, tr);
                w.write("}");
            }
        } else {
            throw new InternalCompilerError("Uh oh, don't know how to translate " + fd);
        }
    }

    private static void prettyPrintConstructorDeclAsEnumConstructorDecl(ConstructorDecl cd, CodeWriter w, PrettyPrinter tr) {
        LinkedList<Formal> newFormals = new LinkedList<Formal>(cd.formals());
        newFormals.remove(0);
        newFormals.remove(0);
        cd = (ConstructorDecl)cd.formals(newFormals);
        LinkedList<Stmt> newStmts = new LinkedList<Stmt>(cd.body().statements());
        if (!newStmts.isEmpty() && newStmts.get(0) instanceof ConstructorCall) {
            newStmts.remove(0);
        }
        if (newStmts.isEmpty() && newFormals.isEmpty()) {
            return;
        }
        Block newBody = cd.body().statements(newStmts);
        cd = (ConstructorDecl)cd.body(newBody);
        tr.lang().prettyPrint((Node)cd, w, tr);
    }

    private Node translateSwitch(Switch n) {
        if (n.expr().type().isPrimitive()) {
            return n;
        }
        Position pos = Position.compilerGenerated();
        ClassType enumType = n.expr().type().toClass();
        Id methodName = this.nodeFactory().Id(pos, "enum$SwitchMap$" + enumType.fullName().replace('.', '_'));
        Call methodCall = this.nodeFactory().Call(pos, methodName, n.expr());
        n = n.expr(methodCall);
        Id arg = this.nodeFactory().Id(pos, "e");
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        LocalInstance argLI = this.ts.localInstance(pos, Flags.NONE, enumType, arg.id());
        for (FieldInstance field : RemoveEnums.enumConstantFieldInstances(enumType)) {
            int index = RemoveEnums.findEnumConstIndex(enumType, field);
            Stmt s = this.qq.parseStmt("if (%E == %T." + field.name() + ") return " + index + ";", this.nodeFactory().Local(pos, arg).localInstance(argLI).type(enumType), enumType);
            stmts.add(s);
        }
        stmts.add(this.nodeFactory().Return(pos, this.nodeFactory().IntLit(pos, IntLit.INT, -1L).type(this.ts.Int())));
        ArrayList<Formal> formals = new ArrayList<Formal>();
        formals.add(this.nodeFactory().Formal(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, this.ts.Object()), arg).localInstance(argLI));
        Flags methodFlags = Flags.PRIVATE;
        if (this.context().currentClass().flags().isStatic() || this.context().currentClass().isTopLevel()) {
            methodFlags = methodFlags.Static();
        }
        MethodDecl switchMethod = this.nodeFactory().MethodDecl(pos, methodFlags, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, this.ts.Int()), methodName, formals, Collections.emptyList(), this.nodeFactory().Block(pos, stmts));
        ClassType container = this.context().currentClass();
        MethodInstance mi = this.ts.methodInstance(pos, container, methodFlags, this.ts.Int(), methodName.id(), Collections.singletonList(this.ts.Object()), Collections.emptyList());
        switchMethod = switchMethod.methodInstance(mi);
        this.addClassMemberToAdd(switchMethod);
        return n;
    }

    private void addClassMemberToAdd(MethodDecl switchMethod) {
        String methodName = switchMethod.name();
        List<ClassMember> list = this.classMembersToAdd.peek();
        for (ClassMember cm : list) {
            if (!(cm instanceof MethodDecl) || !((MethodDecl)cm).name().equals(methodName)) continue;
            return;
        }
        list.add(switchMethod);
    }

    private static int findEnumConstIndex(ClassType enumType, FieldInstance field) {
        List<FieldInstance> l = RemoveEnums.enumConstantFieldInstances(enumType);
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) != field) continue;
            return i;
        }
        throw new InternalCompilerError("Couldn't find field " + field + " in " + enumType + " as an enum constant");
    }

    private static List<FieldInstance> enumConstantFieldInstances(ClassType enumType) {
        ArrayList<FieldInstance> l = new ArrayList<FieldInstance>();
        for (FieldInstance fieldInstance : enumType.fields()) {
            if (!fieldInstance.flags().isStatic() || fieldInstance.type() != enumType) continue;
            l.add(fieldInstance);
        }
        return l;
    }

    private Node translateCase(Case n) {
        if (n.isDefault() || n.expr() == null || n.expr().type().isPrimitive()) {
            return n;
        }
        n = n.expr(this.nodeFactory().IntLit(Position.compilerGenerated(), IntLit.INT, n.value()));
        return n;
    }

    private Node translateTypeNode(TypeNode n) throws SemanticException {
        if (!this.translateEnumSet) {
            return n;
        }
        JL5TypeSystem jl5ts = (JL5TypeSystem)this.ts;
        if (this.ts.typeEquals(jl5ts.erasureType(n.type()), jl5ts.erasureType(this.ts.typeForName("java.util.EnumSet")))) {
            return this.nf.CanonicalTypeNode(n.position(), this.ts.typeForName(this.enumSetImplClass));
        }
        return n;
    }
}

