/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.Collections;
import polyglot.ast.ClassDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ext.jl5.ast.AnnotatedElement;
import polyglot.ext.jl5.ast.AnnotationElemDecl;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class RemoveAnnotations
extends ContextVisitor {
    public RemoveAnnotations(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            cd = cd.flags(JL5Flags.clearAnnotation(cd.flags()));
            cd = (ClassDecl)((AnnotatedElement)((Object)JL5Ext.ext(cd))).annotationElems(Collections.emptyList());
            return cd;
        }
        if (n instanceof AnnotationElemDecl) {
            return this.translateAnnotationElemDecl((AnnotationElemDecl)n);
        }
        JL5Ext ext = JL5Ext.ext(n);
        if (ext instanceof AnnotatedElement) {
            return ((AnnotatedElement)((Object)ext)).annotationElems(Collections.emptyList());
        }
        return n;
    }

    private MethodDecl translateAnnotationElemDecl(AnnotationElemDecl n) {
        Flags f = JL5Flags.clearAnnotation(n.flags());
        MethodDecl md = this.nodeFactory().MethodDecl(n.position(), f, n.returnType(), n.id(), n.formals(), n.throwTypes(), n.body());
        md = md.methodInstance(n.methodInstance());
        return md;
    }
}

