/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ext.jl5.ast.AnnotatedElement;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.AnnotationElementValueArray;
import polyglot.ext.jl5.types.AnnotationElementValueConstant;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Declaration;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class AnnotationChecker
extends ContextVisitor {
    public AnnotationChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        JL5Ext ext = JL5Ext.ext(n);
        if (ext instanceof AnnotatedElement) {
            AnnotatedElement ae = (AnnotatedElement)((Object)ext);
            return ae.annotationCheck((AnnotationChecker)v);
        }
        return n;
    }

    @Override
    public JL5TypeSystem typeSystem() {
        return (JL5TypeSystem)super.typeSystem();
    }

    public void checkAnnotationApplicability(AnnotationElem n, Declaration decl) throws SemanticException {
        Annotations ra;
        AnnotationElem annotation = n;
        JL5ClassType annotationType = (JL5ClassType)annotation.typeName().type().toClass();
        if (annotationType.equals(this.typeSystem().OverrideAnnotation())) {
            this.checkOverrideAnnotation(decl);
        }
        if ((ra = annotationType.annotations()) != null) {
            for (Type at : ra.annotationTypes()) {
                if (!at.equals(this.typeSystem().TargetAnnotation())) continue;
                this.checkTargetMetaAnnotation((AnnotationElementValueArray)ra.singleElement(at), n, decl);
            }
        }
    }

    protected void checkOverrideAnnotation(Declaration decl) throws SemanticException {
        if (!(decl instanceof MethodInstance)) {
            throw new SemanticException("An override annotation can apply only to methods.", decl.position());
        }
        MethodInstance mi = (MethodInstance)decl;
        JL5TypeSystem ts = this.typeSystem();
        LinkedList<MethodInstance> overrides = new LinkedList<MethodInstance>(ts.implemented(mi));
        overrides.remove(mi);
        if (overrides.isEmpty()) {
            throw new SemanticException("Method " + mi.signature() + " does not override a method.", decl.position());
        }
    }

    protected void checkTargetMetaAnnotation(AnnotationElementValueArray targetKinds, AnnotationElem n, Declaration decl) throws SemanticException {
        AnnotationElem annotation = n;
        Collection<EnumInstance> eis = this.annotationElementTypesForDeclaration(decl);
        boolean foundAppropriateTarget = false;
        block0: for (EnumInstance required : eis) {
            for (AnnotationElementValue found : targetKinds.vals()) {
                AnnotationElementValueConstant c = (AnnotationElementValueConstant)found;
                if (!required.equals(c.constantValue())) continue;
                foundAppropriateTarget = true;
                break block0;
            }
        }
        if (!foundAppropriateTarget) {
            throw new SemanticException("Annotation " + annotation + " not applicable to this kind of declaration.", n.position());
        }
    }

    public Collection<EnumInstance> annotationElementTypesForDeclaration(Declaration decl) {
        ClassType aet = this.typeSystem().AnnotationElementType();
        if (decl instanceof MethodInstance) {
            return Collections.singleton((EnumInstance)aet.fieldNamed("METHOD"));
        }
        if (decl instanceof FieldInstance) {
            return Collections.singleton((EnumInstance)aet.fieldNamed("FIELD"));
        }
        if (decl instanceof LocalInstance) {
            JL5LocalInstance li = (JL5LocalInstance)decl;
            if (li.isProcedureFormal()) {
                return Collections.singleton((EnumInstance)aet.fieldNamed("PARAMETER"));
            }
            return Collections.singleton((EnumInstance)aet.fieldNamed("LOCAL_VARIABLE"));
        }
        if (decl instanceof ClassType) {
            ClassType ct = (ClassType)decl;
            if (ct.flags().isInterface() && JL5Flags.isAnnotation(ct.flags())) {
                return Arrays.asList((EnumInstance)aet.fieldNamed("TYPE"), (EnumInstance)aet.fieldNamed("ANNOTATION_TYPE"));
            }
            return Collections.singleton((EnumInstance)aet.fieldNamed("TYPE"));
        }
        if (decl instanceof ConstructorInstance) {
            return Collections.singleton((EnumInstance)aet.fieldNamed("CONSTRUCTOR"));
        }
        if (decl instanceof Package) {
            return Collections.singleton((EnumInstance)aet.fieldNamed("PACKAGE"));
        }
        throw new InternalCompilerError("Don't know how to deal with " + decl);
    }
}

